/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AlignType implements Enumerator
{
    BYTE_LITERAL(0, "byte", "byte"),
    HALFWORD_LITERAL(1, "halfword", "halfword"),
    WORD_LITERAL(2, "word", "word"),
    DOUBLEWORD_LITERAL(3, "doubleword", "doubleword"),
    BIT_LITERAL(4, "bit", "bit");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int BYTE = 0;
    public static final int HALFWORD = 1;
    public static final int WORD = 2;
    public static final int DOUBLEWORD = 3;
    public static final int BIT = 4;
    private static final AlignType[] VALUES_ARRAY;
    public static final List<AlignType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AlignType[]{BYTE_LITERAL, HALFWORD_LITERAL, WORD_LITERAL, DOUBLEWORD_LITERAL, BIT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AlignType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignType get(int value) {
        switch (value) {
            case 0: {
                return BYTE_LITERAL;
            }
            case 1: {
                return HALFWORD_LITERAL;
            }
            case 2: {
                return WORD_LITERAL;
            }
            case 3: {
                return DOUBLEWORD_LITERAL;
            }
            case 4: {
                return BIT_LITERAL;
            }
        }
        return null;
    }

    private AlignType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

