/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AddressMode implements Enumerator
{
    MODE16_LITERAL(0, "mode16", "mode16"),
    MODE24_LITERAL(1, "mode24", "mode24"),
    MODE31_LITERAL(2, "mode31", "mode31"),
    MODE32_LITERAL(3, "mode32", "mode32"),
    MODE64_LITERAL(4, "mode64", "mode64"),
    MODE128_LITERAL(5, "mode128", "mode128");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int MODE16 = 0;
    public static final int MODE24 = 1;
    public static final int MODE31 = 2;
    public static final int MODE32 = 3;
    public static final int MODE64 = 4;
    public static final int MODE128 = 5;
    private static final AddressMode[] VALUES_ARRAY;
    public static final List<AddressMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AddressMode[]{MODE16_LITERAL, MODE24_LITERAL, MODE31_LITERAL, MODE32_LITERAL, MODE64_LITERAL, MODE128_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AddressMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AddressMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AddressMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AddressMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AddressMode get(int value) {
        switch (value) {
            case 0: {
                return MODE16_LITERAL;
            }
            case 1: {
                return MODE24_LITERAL;
            }
            case 2: {
                return MODE31_LITERAL;
            }
            case 3: {
                return MODE32_LITERAL;
            }
            case 4: {
                return MODE64_LITERAL;
            }
            case 5: {
                return MODE128_LITERAL;
            }
        }
        return null;
    }

    private AddressMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

