/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AccessorValue implements Enumerator
{
    READ_ONLY_LITERAL(0, "readOnly", "readOnly"),
    WRITE_ONLY_LITERAL(1, "writeOnly", "writeOnly"),
    READ_WRITE_LITERAL(2, "readWrite", "readWrite"),
    NO_ACCESS_LITERAL(3, "noAccess", "noAccess");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int READ_ONLY = 0;
    public static final int WRITE_ONLY = 1;
    public static final int READ_WRITE = 2;
    public static final int NO_ACCESS = 3;
    private static final AccessorValue[] VALUES_ARRAY;
    public static final List<AccessorValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AccessorValue[]{READ_ONLY_LITERAL, WRITE_ONLY_LITERAL, READ_WRITE_LITERAL, NO_ACCESS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AccessorValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessorValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessorValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessorValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessorValue get(int value) {
        switch (value) {
            case 0: {
                return READ_ONLY_LITERAL;
            }
            case 1: {
                return WRITE_ONLY_LITERAL;
            }
            case 2: {
                return READ_WRITE_LITERAL;
            }
            case 3: {
                return NO_ACCESS_LITERAL;
            }
        }
        return null;
    }

    private AccessorValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

