/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.internal.pref;

import com.ibm.datatools.quick.launch.ui.Activator;
import com.ibm.datatools.quick.launch.ui.i18n.IAManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class QuickLaunchPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String QUERY_CHANGE_PERSPECTIVE = "com.ibm.datatools.quick.launch.ui.changePerspective.query";
    public static final String CHANGE_PERSPECTIVE = "com.ibm.datatools.quick.launch.ui.changePerspective.action";
    public static final String QUERY_SHOW_HELP = "com.ibm.datatools.quick.launch.ui.showHelp.query";
    public static final String SHOW_HELP = "com.ibm.datatools.quick.launch.ui.showHelp.action";
    public static final String QUERY_ON_CLOSE = "com.ibm.datatools.quick.launch.ui.onClose.information";
    public static final String SHOW_HELP_WINDOW = "com.ibm.datatools.quick.launch.ui.showHelpWindow.action";
    public static final String SHOW_TASKLAUNCHER = "com.ibm.datatools.quick.launch.ui.showTaskLauncher";
    IWorkbench m_workbench;
    Button m_queryShowHelp;
    Button m_alwaysShowHelp;
    Button m_neverShowHelp;
    Button m_neverPrompOnEditorClose;
    Button m_showHelpWindow;
    Button m_showTaskLauncher;

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        page.setLayout((Layout)gridLayout);
        this.createEditorPreferences(page);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.quick.launch.ui.task_launcher");
        return page;
    }

    private void createEditorPreferences(Composite p_parent) {
        TableWrapLayout layout = new TableWrapLayout();
        p_parent.setLayout((Layout)layout);
        Group showHelpGroup = new Group(p_parent, 0);
        showHelpGroup.setText(IAManager.QuickLaunchPreferences_ShowHelp);
        showHelpGroup.setLayout((Layout)new GridLayout(1, false));
        showHelpGroup.setLayoutData((Object)new TableWrapData(128));
        boolean promptShowHelp = this.getPreferences().getBoolean(QUERY_SHOW_HELP);
        boolean showHelp = this.getPreferences().getBoolean(SHOW_HELP);
        boolean showHelpWindow = this.getPreferences().getBoolean(SHOW_HELP_WINDOW);
        this.m_queryShowHelp = new Button((Composite)showHelpGroup, 16);
        this.m_queryShowHelp.setText(IAManager.QuickLaunchPreferences_PromptShowHelp);
        this.m_queryShowHelp.setSelection(promptShowHelp);
        this.m_alwaysShowHelp = new Button((Composite)showHelpGroup, 16);
        this.m_alwaysShowHelp.setText(IAManager.QuickLaunchPreferences_AlwaysShowHelp);
        this.m_alwaysShowHelp.setSelection(!promptShowHelp && showHelp);
        this.m_neverShowHelp = new Button((Composite)showHelpGroup, 16);
        this.m_neverShowHelp.setText(IAManager.QuickLaunchPreferences_NeverShowHelp);
        this.m_neverShowHelp.setSelection(!promptShowHelp && !showHelp);
        this.m_showHelpWindow = new Button((Composite)showHelpGroup, 32);
        this.m_showHelpWindow.setText(IAManager.QuickLaunchPreferences_ShowExternalHelp);
        this.m_showHelpWindow.setSelection(showHelpWindow);
        ActivateExternalHelpOptionListener activate = new ActivateExternalHelpOptionListener();
        this.m_queryShowHelp.addSelectionListener((SelectionListener)activate);
        this.m_alwaysShowHelp.addSelectionListener((SelectionListener)activate);
        DeactivateExternalHelpOptionListener deactivate = new DeactivateExternalHelpOptionListener();
        this.m_neverShowHelp.addSelectionListener((SelectionListener)deactivate);
        Group onCloseGroup = new Group(p_parent, 0);
        onCloseGroup.setText(IAManager.QuickLaunchPreferences_CloseLauncher);
        onCloseGroup.setLayout((Layout)new GridLayout(1, false));
        onCloseGroup.setLayoutData((Object)new TableWrapData(128));
        boolean neverPromptOnCloseEditor = this.getPreferences().getBoolean(QUERY_ON_CLOSE);
        this.m_neverPrompOnEditorClose = new Button((Composite)onCloseGroup, 32);
        this.m_neverPrompOnEditorClose.setText(IAManager.QuickLaunchPreferences_DoNotShowDialog);
        this.m_neverPrompOnEditorClose.setSelection(neverPromptOnCloseEditor);
        Group grpShowTaskLauncher = new Group(p_parent, 0);
        grpShowTaskLauncher.setText(IAManager.QuickLaunchPreferences_TaskLauncher);
        grpShowTaskLauncher.setLayout((Layout)new GridLayout(1, false));
        grpShowTaskLauncher.setLayoutData((Object)new TableWrapData(128));
        boolean showTaskLauncher = this.getPreferences().getBoolean(SHOW_TASKLAUNCHER);
        this.m_showTaskLauncher = new Button((Composite)grpShowTaskLauncher, 32);
        this.m_showTaskLauncher.setText(IAManager.QuickLaunchPreferences_TaskLauncher_Desc);
        this.m_showTaskLauncher.setSelection(showTaskLauncher);
    }

    public boolean performOk() {
        Preferences p = this.getPreferences();
        p.setValue(QUERY_SHOW_HELP, this.m_queryShowHelp.getSelection());
        p.setValue(SHOW_HELP, !this.m_neverShowHelp.getSelection());
        p.setValue(QUERY_ON_CLOSE, this.m_neverPrompOnEditorClose.getSelection());
        p.setValue(SHOW_HELP_WINDOW, this.m_showHelpWindow.getSelection());
        p.setValue(SHOW_TASKLAUNCHER, this.m_showTaskLauncher.getSelection());
        return true;
    }

    private Preferences getPreferences() {
        return Activator.getDefault().getPluginPreferences();
    }

    protected void performDefaults() {
        this.m_queryShowHelp.setSelection(true);
        this.m_alwaysShowHelp.setSelection(false);
        this.m_neverShowHelp.setSelection(false);
        this.m_neverPrompOnEditorClose.setSelection(false);
        this.m_showHelpWindow.setSelection(false);
    }

    public void init(IWorkbench p_workbench) {
        this.m_workbench = p_workbench;
    }

    private class ActivateExternalHelpOptionListener
    extends SelectionAdapter {
        private ActivateExternalHelpOptionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            QuickLaunchPreferences.this.m_showHelpWindow.setEnabled(true);
        }
    }

    private class DeactivateExternalHelpOptionListener
    extends SelectionAdapter {
        private DeactivateExternalHelpOptionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            QuickLaunchPreferences.this.m_showHelpWindow.setEnabled(false);
        }
    }
}

