/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.internal.editor;

import com.ibm.datatools.quick.launch.ui.Activator;
import com.ibm.datatools.quick.launch.ui.i18n.IAManager;
import com.ibm.datatools.quick.launch.ui.i18n.IconManager;
import com.ibm.datatools.quick.launch.ui.internal.core.QuickLaunchSolutionManager;
import com.ibm.datatools.quick.launch.ui.internal.editor.QuickLaunchEditorInput;
import com.ibm.datatools.quick.launch.ui.internal.pref.QuickLaunchPreferences;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class QuickLaunchEditor
extends SharedHeaderFormEditor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IManagedForm m_form;
    private QuickLaunchEditorInput m_input;
    public static final String BODY_BG_COLOR = "0xB8D0F0";
    public static final String BANNER_BG_COLOR = "0x638ECE";
    public static final String TAB_BLUE_COLOR = "0x5888C8";
    public static final String TITLE_BLUE_COLOR = "0x0050AA";
    public static final String WHITE_COLOR = "0xFFFFFF";
    public static final String GROUP_BORDER_COLOR = "0x90B6DC";
    public static final String GROUP_BG_COLOR = "0xFAFCFC";
    public static final String UC_TITLE_COLOR = "0x0050AA";
    public static final String UC_DESC_COLOR = "0x4D4D4D";
    public static final String TAB_BEGIN = "   ";
    public static final String TAB_END = "   ";
    public static final String SEPARATOR = " | ";
    private static int BOX_BORDER_WIDTH = 20;

    protected void createPages() {
        super.createPages();
        if (this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    protected void addPages() {
        try {
            QuickLaunchSolutionManager.Solution[] solutions;
            FormPage solutionPage = null;
            String solutionId = null;
            JFaceResources.getColorRegistry().put(BODY_BG_COLOR, new RGB(184, 208, 240));
            JFaceResources.getColorRegistry().put(BANNER_BG_COLOR, new RGB(99, 142, 206));
            JFaceResources.getColorRegistry().put(TAB_BLUE_COLOR, new RGB(88, 136, 200));
            JFaceResources.getColorRegistry().put(WHITE_COLOR, new RGB(255, 255, 255));
            JFaceResources.getColorRegistry().put("0x0050AA", new RGB(0, 80, 170));
            JFaceResources.getColorRegistry().put(GROUP_BORDER_COLOR, new RGB(144, 182, 220));
            JFaceResources.getColorRegistry().put(GROUP_BG_COLOR, new RGB(250, 252, 252));
            JFaceResources.getColorRegistry().put("0x0050AA", new RGB(0, 80, 170));
            JFaceResources.getColorRegistry().put(UC_DESC_COLOR, new RGB(77, 77, 77));
            QuickLaunchSolutionManager.Solution[] solutionArray = solutions = QuickLaunchSolutionManager.getTopSolutions();
            int n = solutions.length;
            int n2 = 0;
            while (n2 < n) {
                QuickLaunchSolutionManager.Solution solution = solutionArray[n2];
                if (solution == null) {
                    solutionPage = new FormPage((FormEditor)this, "default", "default");
                    this.m_form = solutionPage.getManagedForm();
                    TableWrapLayout layout = new TableWrapLayout();
                    layout.numColumns = 2;
                    this.m_form.getForm().getBody().setLayout((Layout)layout);
                    this.m_form.reflow(true);
                    return;
                }
                if (solution.getId().equals(this.m_input.getSolutionId())) {
                    solutionId = solution.getId();
                }
                solutionPage = new SolutionsPage((FormEditor)this, solution);
                this.addPage((IFormPage)solutionPage);
                ++n2;
            }
            QuickLaunchSolutionManager.setEditorSolutionId(solutionId);
            IFormPage activePage = this.setActivePage(QuickLaunchSolutionManager.getEditorSolutionId());
            if (activePage != null && activePage.getManagedForm() != null) {
                activePage.getManagedForm().reflow(true);
            }
            QuickLaunchSolutionManager.getSwitcher().run();
        }
        catch (PartInitException e) {
            Activator.log(e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof QuickLaunchEditorInput)) {
            throw new PartInitException("OptimSolutionsEditorInput required");
        }
        this.m_input = (QuickLaunchEditorInput)input;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    class SolutionsPage
    extends FormPage {
        QuickLaunchSolutionManager.Solution solution;
        ScrolledForm m_form;

        protected SolutionsPage(FormEditor editor, QuickLaunchSolutionManager.Solution solution) {
            super(editor, solution.getId(), null);
            this.solution = solution;
        }

        protected void createFormContent(IManagedForm managedForm) {
            this.m_form = managedForm.getForm();
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            layout.rightMargin = 0;
            layout.leftMargin = 0;
            layout.topMargin = 0;
            layout.bottomMargin = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            this.m_form.getBody().setLayout((Layout)layout);
            this.m_form.getBody().setBackground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.BODY_BG_COLOR));
            this.createBanner(managedForm, this.solution);
            this.createBody(managedForm, this.solution);
            Rectangle rect = this.m_form.getParent().getBounds();
            this.m_form.setSize(rect.width, rect.height);
        }

        public void createBanner(IManagedForm headerForm, QuickLaunchSolutionManager.Solution p_activeSolution) {
            Color BANNER_COLOR = JFaceResources.getColorRegistry().get(QuickLaunchEditor.BANNER_BG_COLOR);
            Color TAB_COLOR = JFaceResources.getColorRegistry().get(QuickLaunchEditor.TAB_BLUE_COLOR);
            ScrolledForm form = headerForm.getForm();
            Composite bannerGroup = headerForm.getToolkit().createComposite(form.getBody());
            TableWrapLayout bLayout = new TableWrapLayout();
            bLayout.numColumns = 1;
            bLayout.makeColumnsEqualWidth = false;
            bLayout.verticalSpacing = 0;
            bLayout.horizontalSpacing = 0;
            bLayout.rightMargin = 0;
            bLayout.leftMargin = 0;
            bLayout.topMargin = 0;
            bLayout.bottomMargin = 0;
            bannerGroup.setLayout((Layout)bLayout);
            TableWrapData td = new TableWrapData(256);
            td.colspan = 1;
            bannerGroup.setLayoutData((Object)td);
            bannerGroup.setBackground(BANNER_COLOR);
            Label banner = new Label(bannerGroup, 128);
            Image img = IconManager.getImage("platform:/plugin/com.ibm.im.ims.workbench.quick.launch.ui/icons/optimBanner.png");
            banner.setImage(img);
            TableWrapData td1 = new TableWrapData(256);
            td1.colspan = 1;
            banner.setLayoutData((Object)td1);
            banner.setBackground(BANNER_COLOR);
            QuickLaunchSolutionManager.Solution[] solutions = QuickLaunchSolutionManager.getTopSolutions();
            int numtabs = solutions == null || solutions.length < 1 ? 1 : solutions.length;
            int cells = numtabs > 1 ? numtabs * 2 : 1;
            Composite linksGroup = headerForm.getToolkit().createComposite(bannerGroup);
            Composite tabGroup = headerForm.getToolkit().createComposite(linksGroup);
            TableWrapLayout linkLayout = new TableWrapLayout();
            linkLayout.numColumns = 2;
            linkLayout.makeColumnsEqualWidth = false;
            linkLayout.verticalSpacing = 0;
            linkLayout.horizontalSpacing = 0;
            linkLayout.rightMargin = 0;
            linkLayout.leftMargin = 0;
            linkLayout.topMargin = 0;
            linkLayout.bottomMargin = 0;
            TableWrapData tdLinkGroup = new TableWrapData(256);
            tdLinkGroup.colspan = 1;
            linksGroup.setBackground(TAB_COLOR);
            linksGroup.setLayoutData((Object)tdLinkGroup);
            linksGroup.setLayout((Layout)linkLayout);
            TableWrapLayout tLayout = new TableWrapLayout();
            tLayout.numColumns = cells;
            tLayout.makeColumnsEqualWidth = false;
            bLayout.verticalSpacing = 0;
            tLayout.horizontalSpacing = 0;
            tLayout.rightMargin = 0;
            tLayout.leftMargin = 0;
            tLayout.topMargin = 0;
            tLayout.bottomMargin = 0;
            tabGroup.setLayout((Layout)tLayout);
            TableWrapData tdtab = new TableWrapData(2);
            tdtab.colspan = 1;
            tabGroup.setLayoutData((Object)tdtab);
            tabGroup.setBackground(TAB_COLOR);
            if (cells > 0) {
                Hyperlink[] tabs = new Hyperlink[numtabs];
                int i = 0;
                Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.headerfont");
                String actionSolutionId = p_activeSolution.getId();
                QuickLaunchSolutionManager.Solution[] solutionArray = solutions;
                int n = solutions.length;
                int n2 = 0;
                while (n2 < n) {
                    QuickLaunchSolutionManager.Solution solution = solutionArray[n2];
                    Hyperlink tab = new Hyperlink(tabGroup, 16384);
                    tab.setText("   " + solution.getLabel() + "   ");
                    tab.setData((Object)solution.getId());
                    tab.setFont(bold);
                    tab.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            String solutionId = (String)e.widget.getData();
                            if (solutionId != null && solutionId.trim().length() > 0) {
                                QuickLaunchSolutionManager.setEditorSolutionId(solutionId);
                                IFormPage page = QuickLaunchEditor.this.setActivePage(solutionId);
                                if (page.getManagedForm() != null) {
                                    page.getManagedForm().reflow(true);
                                }
                            }
                        }
                    });
                    tdtab = new TableWrapData();
                    tdtab.colspan = 1;
                    tab.setLayoutData((Object)tdtab);
                    tab.setBackground(TAB_COLOR);
                    if (actionSolutionId != null && actionSolutionId.equals(solution.getId())) {
                        tab.setBackground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.BODY_BG_COLOR));
                        tab.setForeground(JFaceResources.getColorRegistry().get("0x0050AA"));
                    } else {
                        tab.setBackground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.TAB_BLUE_COLOR));
                        tab.setForeground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.WHITE_COLOR));
                    }
                    tabs[i] = tab;
                    if (++i < solutions.length) {
                        Label label = headerForm.getToolkit().createLabel(tabGroup, QuickLaunchEditor.SEPARATOR);
                        label.setFont(bold);
                        label.setBackground(TAB_COLOR);
                        label.setForeground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.WHITE_COLOR));
                        TableWrapData tdlab = new TableWrapData(256);
                        tdlab.colspan = 1;
                        label.setLayoutData((Object)tdlab);
                    }
                    ++n2;
                }
            }
            Hyperlink prefLink = new Hyperlink(linksGroup, 1024);
            prefLink.setText("   " + IAManager.QuickLaunchEditor_Preferences + "   ");
            Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            prefLink.setForeground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.WHITE_COLOR));
            prefLink.setBackground(TAB_COLOR);
            prefLink.setFont(bold);
            TableWrapData prefData = new TableWrapData(8);
            prefData.grabHorizontal = true;
            prefData.valign = 64;
            prefLink.setLayoutData((Object)prefData);
            prefLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    QuickLaunchPreferences page = new QuickLaunchPreferences();
                    page.setTitle(IAManager.QuickLaunchEditor_TaskLauncher);
                    PreferenceManager mgr = new PreferenceManager();
                    PreferenceNode node = new PreferenceNode("com.ibm.im.ims.workbench.quick.launch.ui.internal.preference", (IPreferencePage)page);
                    mgr.addToRoot((IPreferenceNode)node);
                    PreferenceDialog dialog = new PreferenceDialog(SolutionsPage.this.m_form.getShell(), mgr);
                    dialog.create();
                    dialog.setMessage(page.getTitle());
                    dialog.open();
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
            Rectangle rect = form.getParent().getBounds();
            form.setSize(rect.width, rect.height);
        }

        protected void createBody(IManagedForm headerForm, QuickLaunchSolutionManager.Solution p_solution) {
            ScrolledForm form = headerForm.getForm();
            Composite bodyGroup = headerForm.getToolkit().createComposite(form.getBody());
            TableWrapLayout bLayout = new TableWrapLayout();
            bLayout.numColumns = 2;
            bLayout.makeColumnsEqualWidth = true;
            bLayout.horizontalSpacing = bLayout.verticalSpacing = BOX_BORDER_WIDTH;
            bLayout.leftMargin = bLayout.rightMargin = BOX_BORDER_WIDTH;
            bLayout.topMargin = bLayout.rightMargin;
            bLayout.bottomMargin = bLayout.rightMargin;
            bodyGroup.setLayout((Layout)bLayout);
            TableWrapData td = new TableWrapData(256);
            td.colspan = 1;
            bodyGroup.setLayoutData((Object)td);
            bodyGroup.setBackground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.BODY_BG_COLOR));
            for (QuickLaunchSolutionManager.Group group : p_solution.getGroups()) {
                this.addGroup(bodyGroup, p_solution, group);
            }
        }

        private void addGroup(Composite parent, QuickLaunchSolutionManager.Solution solution, QuickLaunchSolutionManager.Group group) {
            ArrayList<QuickLaunchSolutionManager.UseCase> usecases = solution.getUseCases(group.getId());
            if (usecases != null) {
                Composite highlightBox = QuickLaunchEditor.this.getToolkit().createComposite(parent);
                TableWrapData td = new TableWrapData();
                td.align = 128;
                td.rowspan = group.getRowspan();
                highlightBox.setLayoutData((Object)td);
                TableWrapLayout layout = new TableWrapLayout();
                layout.rightMargin = 10;
                layout.leftMargin = 10;
                layout.topMargin = 10;
                layout.bottomMargin = 10;
                layout.numColumns = 1;
                highlightBox.setLayout((Layout)layout);
                highlightBox.setBackground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.GROUP_BORDER_COLOR));
                Composite groupBox = QuickLaunchEditor.this.getToolkit().createComposite(highlightBox);
                td = new TableWrapData(256);
                groupBox.setLayoutData((Object)td);
                layout = new TableWrapLayout();
                layout.bottomMargin = layout.topMargin = BOX_BORDER_WIDTH - 5;
                layout.leftMargin = layout.rightMargin = BOX_BORDER_WIDTH;
                layout.numColumns = 2;
                layout.verticalSpacing = group.getVerticalSpacing();
                groupBox.setLayout((Layout)layout);
                Color color = JFaceResources.getColorRegistry().get(QuickLaunchEditor.GROUP_BG_COLOR);
                groupBox.setBackground(color);
                this.header(group.getLabel(), groupBox, color);
                for (QuickLaunchSolutionManager.UseCase usecase : usecases) {
                    this.usecase(usecase, groupBox, color);
                }
            }
        }

        private void header(String label, Composite learnbox, Color color) {
            Label header = QuickLaunchEditor.this.getToolkit().createLabel(learnbox, label);
            TableWrapData td = new TableWrapData(256);
            td.colspan = 2;
            header.setLayoutData((Object)td);
            header.setFont(JFaceResources.getHeaderFont());
            header.setBackground(color);
            header.setForeground(JFaceResources.getColorRegistry().get("0x0050AA"));
        }

        private void usecase(QuickLaunchSolutionManager.UseCase usecase, Composite groupbox, Color color) {
            Image img = IconManager.getImage(usecase.getImagePath());
            final IAction action = usecase.getAction();
            HyperlinkAdapter hyperlinkAction = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (action != null) {
                        action.run();
                    } else {
                        System.out.println("Link active: " + String.valueOf(e.getHref()));
                    }
                }
            };
            ImageHyperlink image1 = new ImageHyperlink(groupbox, 1024);
            TableWrapData td = new TableWrapData(2);
            td.colspan = 1;
            image1.setLayoutData((Object)td);
            if (img != null) {
                image1.setActiveImage(img);
                image1.setImage(img);
            }
            image1.setBackground(color);
            image1.addHyperlinkListener((IHyperlinkListener)hyperlinkAction);
            Composite usecaseBox = QuickLaunchEditor.this.getToolkit().createComposite(groupbox);
            td = new TableWrapData(256);
            td.colspan = 1;
            usecaseBox.setLayoutData((Object)td);
            TableWrapLayout layout = new TableWrapLayout();
            layout.rightMargin = 0;
            layout.leftMargin = 0;
            layout.topMargin = 0;
            layout.bottomMargin = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            usecaseBox.setLayout((Layout)layout);
            usecaseBox.setBackground(color);
            Hyperlink link = new Hyperlink(usecaseBox, 64);
            link.setText(usecase.getLabel());
            link.addHyperlinkListener((IHyperlinkListener)hyperlinkAction);
            td = new TableWrapData(256);
            td.colspan = 1;
            link.setLayoutData((Object)td);
            Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            link.setFont(bold);
            link.setBackground(color);
            link.setForeground(JFaceResources.getColorRegistry().get("0x0050AA"));
            String description = usecase.getDescription();
            if (description != null && description.trim().length() > 0) {
                Hyperlink descr = new Hyperlink(usecaseBox, 64);
                descr.setText(description);
                descr.addHyperlinkListener((IHyperlinkListener)hyperlinkAction);
                td = new TableWrapData(128);
                td.colspan = 1;
                descr.setLayoutData((Object)td);
                descr.setBackground(color);
                link.setForeground(JFaceResources.getColorRegistry().get(QuickLaunchEditor.UC_DESC_COLOR));
            }
        }
    }
}

