/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.internal.core;

import com.ibm.datatools.quick.launch.ui.Activator;
import com.ibm.datatools.quick.launch.ui.actions.CheckboxMessageDialog;
import com.ibm.datatools.quick.launch.ui.actions.GenericCommandAction;
import com.ibm.datatools.quick.launch.ui.actions.OpenBrowserCommandAction;
import com.ibm.datatools.quick.launch.ui.actions.OpenHelpAction;
import com.ibm.datatools.quick.launch.ui.actions.OpenNewWizardCommandAction;
import com.ibm.datatools.quick.launch.ui.actions.OpenPerspectiveAction;
import com.ibm.datatools.quick.launch.ui.actions.OpenWebPageAction;
import com.ibm.datatools.quick.launch.ui.actions.ShowSolutionCommandAction;
import com.ibm.datatools.quick.launch.ui.actions.ShowViewAction;
import com.ibm.datatools.quick.launch.ui.i18n.IAManager;
import com.ibm.datatools.quick.launch.ui.internal.editor.QuickLaunchEditor;
import com.ibm.datatools.quick.launch.ui.internal.editor.QuickLaunchEditorInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.editor.IFormPage;

public class QuickLaunchSolutionManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SOLUTIONS_POINT_ID = "com.ibm.im.ims.workbench.quick.launch.ui.solution";
    public static final String SOLUTION_TAG = "solution";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String SHOW_IN_ATTR = "showIn";
    public static final String ON_OPEN_MACRO_ID_ATTR = "onOpenMacroId";
    public static final String PARENT_SOLUTION_ID_ATTR = "parentSolutionId";
    public static final String GROUP_TAG = "group";
    public static final String MACRO_TAG = "macro";
    public static final String COLOR_ATTR = "color";
    public static final String V_SPACE_ATTR = "vspace";
    public static final String USECASES_TAG = "usecases";
    public static final String SOLUTION_ID_ATTR = "solutionId";
    public static final String GROUP_ID_ATTR = "groupId";
    public static final String ROWSPAN_ATTR = "rowspan";
    public static final String PERSPECTIVE_ID_ATTR = "perspectiveId";
    public static final String USECASE_TAG = "usecase";
    public static final String DESCRIPTION_ATTR = "description";
    public static final String IMAGE_ATTR = "image";
    public static final String RANK_ATTR = "rank";
    public static final String ACTION_TAG = "action";
    public static final String CLASS_ATTR = "class";
    public static final String SHOW_VIEW_TAG = "showViewAction";
    public static final String VIEW_ID_ATTR = "viewId";
    public static final String STATE_ATTR = "state";
    public static final String SHOW_CHEAT_SHEET_TAG = "showCheatSheetAction";
    public static final String CHEAT_SHEET_ID_ATTR = "cheatSheetId";
    public static final String SHOW_HELP_TAG = "showHelpAction";
    public static final String HELP_URL_ATTR = "helpURL";
    public static final String HIDE_VIEW_TAG = "hideViewAction";
    public static final String SHOW_SOLUTION_TAG = "showSolutionAction";
    public static final String COMMAND_ACTION_TAG = "commandAction";
    public static final String COMMAND_ID_ATTR = "commandId";
    public static final String SHOW_NEW_WIZARD_TAG = "showNewWizardAction";
    public static final String WIZARD_ID_ATTR = "wizardId";
    public static final String STARTUP_TAG = "startup";
    public static final String PRODUCT_ID_ATTR = "productId";
    public static final String SHOW_WEB_PAGE_TAG = "showWebPageAction";
    public static final String URL_ATTR = "url";
    public static final String IN_EDITOR_ATTR = "inEditor";
    public static final String QUICK_LAUNCH_GROUP = "quickLaunch";
    public static final String FIRST_STEPS_GROUP = "firstSteps";
    public static final String SHOW_IN_EDITOR_VALUE = "editor";
    public static final String SHOW_IN_VIEW_VALUE = "view";
    public static final String SHOW_IN_SAME_VALUE = "same";
    public static final String HIDE_VALUE = "hide";
    public static final int DEFAULT_RGB = 255;
    public static final String DEFAULT_COLOR_KEY = "0xFFFFFF";
    public static final int SHOW_IN_EDITOR_CODE = 0;
    public static final int SHOW_IN_VIEW_CODE = 1;
    public static final int SHOW_IN_SAME_CODE = 2;
    public static final int HIDE_CODE = 3;
    public static Map<String, Solution> m_solutions;
    public static String m_editorSolutionId;
    public static String m_viewSolutionId;
    private static QuickLaunchEditorInput m_editorInput;
    private static IAction switcher;

    static {
        switcher = null;
    }

    private static IEditorInput getEditorInput() {
        if (m_editorInput == null) {
            m_editorInput = QuickLaunchSolutionManager.getEditorSolutionId() != null ? new QuickLaunchEditorInput(QuickLaunchSolutionManager.getEditorSolutionId()) : new QuickLaunchEditorInput(QuickLaunchSolutionManager.getCurrentPerspectiveId());
        }
        return m_editorInput;
    }

    public static void setViewSolutionId(String id) {
        m_viewSolutionId = id;
    }

    public static void setEditorSolutionId(String id) {
        m_editorSolutionId = id;
    }

    public static void setSolutionId(String id) {
        QuickLaunchSolutionManager.setEditorSolutionId(id);
        QuickLaunchSolutionManager.setViewSolutionId(id);
    }

    public static String getEditorSolutionId() {
        if (m_editorSolutionId == null || m_editorSolutionId.trim().length() == 0) {
            return QuickLaunchSolutionManager.getBestSolutionId(QuickLaunchSolutionManager.getCurrentPerspectiveId());
        }
        return QuickLaunchSolutionManager.getBestSolutionId(m_editorSolutionId);
    }

    public static String getViewSolutionId() {
        if (m_viewSolutionId == null || m_viewSolutionId.trim().length() == 0) {
            return QuickLaunchSolutionManager.getBestSolutionId(QuickLaunchSolutionManager.getCurrentPerspectiveId());
        }
        return QuickLaunchSolutionManager.getBestSolutionId(m_viewSolutionId);
    }

    private static String getCurrentPerspectiveId() {
        IWorkbenchPage page;
        IWorkbenchWindow active = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (active != null && (page = active.getActivePage()) != null) {
            String perspectiveId = page.getPerspective().getId();
            return perspectiveId;
        }
        return null;
    }

    private static String getBestSolutionId(String p_requestedId) {
        Solution solution = QuickLaunchSolutionManager.getSolution(p_requestedId);
        if (solution == null && (solution = QuickLaunchSolutionManager.getFirstSolution(QuickLaunchSolutionManager.getTopSolutions())) == null) {
            solution = QuickLaunchSolutionManager.getFirstSolution(QuickLaunchSolutionManager.getAllSolutions());
        }
        return solution != null ? solution.getId() : null;
    }

    private static Solution getFirstSolution(Solution[] solutions) {
        if (solutions != null && solutions.length > 0) {
            return solutions[0];
        }
        return null;
    }

    public static Solution getEditorSolution() {
        Solution solution;
        if (m_editorSolutionId != null && (solution = QuickLaunchSolutionManager.getSolution(m_editorSolutionId)) != null && solution.isDefined()) {
            return solution;
        }
        return null;
    }

    public static Solution getViewSolution() {
        Solution solution = QuickLaunchSolutionManager.getSolution(QuickLaunchSolutionManager.getViewSolutionId());
        if (solution != null && solution.isDefined()) {
            return solution;
        }
        return null;
    }

    public static Solution[] getAllSolutions() {
        return QuickLaunchSolutionManager.getSolutions(true, false);
    }

    public static Solution getDefaultSolution() {
        Solution[] solutions = QuickLaunchSolutionManager.getSolutions(true, false);
        if (solutions != null && solutions.length > 0) {
            Solution lowestRank = null;
            Solution[] solutionArray = solutions;
            int n = solutions.length;
            int n2 = 0;
            while (n2 < n) {
                Solution sol = solutionArray[n2];
                if (lowestRank == null || lowestRank.getRank() > sol.getRank()) {
                    lowestRank = sol;
                }
                ++n2;
            }
            return lowestRank;
        }
        return null;
    }

    private static Solution[] getSolutions(boolean p_isRequireDefined, boolean p_isTop) {
        QuickLaunchSolutionManager.initSolutions(false);
        ArrayList<Solution> solutions = new ArrayList<Solution>(m_solutions.size());
        for (Solution solution : m_solutions.values()) {
            if (p_isRequireDefined && !solution.isDefined()) continue;
            if (!p_isTop) {
                solutions.add(solution);
                continue;
            }
            String parentId = solution.getParentSolutionId();
            if (parentId != null && parentId.trim().length() != 0) continue;
            solutions.add(solution);
        }
        return solutions.toArray(new Solution[solutions.size()]);
    }

    public static Solution[] getTopSolutions() {
        Solution[] solutions = QuickLaunchSolutionManager.getSolutions(true, true);
        Arrays.sort(solutions, new Comparator<Solution>(){

            @Override
            public int compare(Solution object1, Solution object2) {
                return object1.getRank() - object2.getRank();
            }
        });
        return solutions;
    }

    public static void showUpdate() throws PartInitException {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && QuickLaunchSolutionManager.getViewSolution() != null && (editor = page.findEditor(QuickLaunchSolutionManager.getEditorInput())) != null && page.getActiveEditor() == editor) {
            page.activate((IWorkbenchPart)editor);
        }
    }

    public static void showSolutionTabChange() throws PartInitException {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && QuickLaunchSolutionManager.getViewSolution() != null && (editor = page.findEditor(QuickLaunchSolutionManager.getEditorInput())) != null && page.getActiveEditor() == editor) {
            IFormPage formPage;
            page.activate((IWorkbenchPart)editor);
            if (editor instanceof QuickLaunchEditor && (formPage = ((QuickLaunchEditor)editor).setActivePage(QuickLaunchSolutionManager.getEditorSolutionId())).getManagedForm() != null) {
                formPage.getManagedForm().reflow(true);
            }
        }
    }

    public static boolean isShowQuickLaunchEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && QuickLaunchSolutionManager.getViewSolution() != null) {
            return page.findEditor(QuickLaunchSolutionManager.getEditorInput()) != null;
        }
        return false;
    }

    public static void showSolutionsEditor(boolean show) throws PartInitException {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorPart editor = page.findEditor(QuickLaunchSolutionManager.getEditorInput());
            if (show) {
                if (editor == null) {
                    page.openEditor(QuickLaunchSolutionManager.getEditorInput(), "com.ibm.im.ims.workbench.quick.launch.ui.editor.QuickLaunchEditor");
                } else {
                    page.activate((IWorkbenchPart)editor);
                    if (editor instanceof QuickLaunchEditor) {
                        ((QuickLaunchEditor)editor).setActivePage(QuickLaunchSolutionManager.getEditorSolutionId());
                    }
                }
            } else if (editor != null) {
                page.closeEditor(editor, false);
            }
        }
    }

    private static Color getColor(String key) {
        int blue;
        int green;
        int red;
        RGB color;
        Color result = null;
        if (key == null || key.length() != 8 || !"0x".equals(key.substring(0, 2))) {
            key = DEFAULT_COLOR_KEY;
        }
        if ((result = JFaceResources.getColorRegistry().get(key)) == null && (color = new RGB(red = QuickLaunchSolutionManager.parseIntHex(key.substring(2, 4), 255), green = QuickLaunchSolutionManager.parseIntHex(key.substring(4, 6), 255), blue = QuickLaunchSolutionManager.parseIntHex(key.substring(6), 255))) != null) {
            JFaceResources.getColorRegistry().put(key, color);
            result = JFaceResources.getColorRegistry().get(key);
        }
        return result;
    }

    private static int parseIntHex(String hex, int defaultValue) {
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static void initSolutions(boolean reload) {
        QuickLaunchSolutionManager.assurePerspectiveListener();
        QuickLaunchSolutionManager.assurePageListener();
        if (m_solutions != null && !reload) {
            return;
        }
        m_solutions = new HashMap<String, Solution>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(SOLUTIONS_POINT_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension anExtension = extensions[i];
                IConfigurationElement[] elements = anExtension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement anElement = elements[j];
                    if (SOLUTION_TAG.equals(anElement.getName())) {
                        IConfigurationElement[] groups;
                        String solutionId = anElement.getAttribute(ID);
                        String label = anElement.getAttribute(LABEL);
                        String image = anElement.getAttribute(IMAGE_ATTR);
                        int show = QuickLaunchSolutionManager.processShowIn(anElement.getAttribute(SHOW_IN_ATTR));
                        String onOpenMacroId = anElement.getAttribute(ON_OPEN_MACRO_ID_ATTR);
                        String parentSolutionId = anElement.getAttribute(PARENT_SOLUTION_ID_ATTR);
                        int solutionRank = QuickLaunchSolutionManager.convertToInt(anElement.getAttribute(RANK_ATTR), 10000);
                        Solution solution = m_solutions.get(solutionId);
                        if (solution == null) {
                            solution = new Solution(solutionId, label, image, show, onOpenMacroId, parentSolutionId, solutionRank);
                            m_solutions.put(solutionId, solution);
                        } else if (!solution.isDefined()) {
                            solution.setDefined(true, label, image, show, solutionRank);
                        }
                        IConfigurationElement[] iConfigurationElementArray = groups = anElement.getChildren();
                        int n = groups.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement groupElement = iConfigurationElementArray[n2];
                            if (GROUP_TAG.equals(groupElement.getName())) {
                                String groupLabel = groupElement.getAttribute(LABEL);
                                String groupId = groupElement.getAttribute(ID);
                                String groupColor = groupElement.getAttribute(COLOR_ATTR);
                                int groupRank = QuickLaunchSolutionManager.convertToInt(groupElement.getAttribute(RANK_ATTR), 10000);
                                int groupRowspan = QuickLaunchSolutionManager.convertToInt(groupElement.getAttribute(ROWSPAN_ATTR), 1);
                                int groupVerticalSpacing = QuickLaunchSolutionManager.convertToInt(groupElement.getAttribute(V_SPACE_ATTR), 15);
                                Group group = new Group(groupId, groupLabel, groupColor, groupRank, groupRowspan, groupVerticalSpacing);
                                solution.add(group);
                            } else if (MACRO_TAG.equals(groupElement.getName())) {
                                String macroId = groupElement.getAttribute(ID);
                                ArrayList<IAction> actions = QuickLaunchSolutionManager.processActions(groupElement);
                                solution.addMacro(macroId, actions);
                            }
                            ++n2;
                        }
                    } else if (USECASES_TAG.equals(anElement.getName())) {
                        IConfigurationElement[] usecases = anElement.getChildren();
                        solutionId = anElement.getAttribute(SOLUTION_ID_ATTR);
                        String groupId = anElement.getAttribute(GROUP_ID_ATTR);
                        String perspectiveId = anElement.getAttribute(PERSPECTIVE_ID_ATTR);
                        Solution solution = m_solutions.get(solutionId);
                        if (solution == null) {
                            solution = new Solution(solutionId);
                            m_solutions.put(solutionId, solution);
                        }
                        IConfigurationElement[] iConfigurationElementArray = usecases;
                        int n = usecases.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IConfigurationElement usecaseElement = iConfigurationElementArray[n3];
                            if (USECASE_TAG.equals(usecaseElement.getName())) {
                                String label = usecaseElement.getAttribute(LABEL);
                                String description = usecaseElement.getAttribute(DESCRIPTION_ATTR);
                                String imagePath = usecaseElement.getAttribute(IMAGE_ATTR);
                                int usecaseRank = QuickLaunchSolutionManager.convertToInt(usecaseElement.getAttribute(RANK_ATTR), 10000);
                                ArrayList<IAction> actions = QuickLaunchSolutionManager.processActions(usecaseElement);
                                QuickLaunchSolutionManager.addPerspectiveSwitcher(actions, perspectiveId);
                                UseCase usecase = new UseCase(label, description, imagePath, actions, groupId, usecaseRank);
                                solution.add(usecase);
                            }
                            ++n3;
                        }
                    } else if (STARTUP_TAG.equals(anElement.getName())) {
                        String productId = anElement.getAttribute(PRODUCT_ID_ATTR);
                        solutionId = anElement.getAttribute(SOLUTION_ID_ATTR);
                        if (productId != null && productId.trim().length() > 0 && solutionId != null && solutionId.trim().length() > 0) {
                            Solution solution = m_solutions.get(solutionId);
                            if (solution == null) {
                                solution = new Solution(solutionId);
                                m_solutions.put(solutionId, solution);
                            }
                            solution.bindProductId(productId);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            Activator.log(e);
            m_solutions = null;
        }
        for (Solution solution : m_solutions.values()) {
            solution.rankChildren();
        }
    }

    private static ArrayList<IAction> processActions(IConfigurationElement p_secaseElement) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        IConfigurationElement[] iConfigurationElementArray = p_secaseElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement usecaseProps = iConfigurationElementArray[n2];
            if (ACTION_TAG.equals(usecaseProps.getName())) {
                action = null;
                try {
                    action = (IAction)usecaseProps.createExecutableExtension(CLASS_ATTR);
                    if (action != null) {
                        actions.add((IAction)action);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            } else if (SHOW_VIEW_TAG.equals(usecaseProps.getName())) {
                viewId = usecaseProps.getAttribute(VIEW_ID_ATTR);
                if (viewId != null && viewId.trim().length() > 0) {
                    String state = usecaseProps.getAttribute(STATE_ATTR);
                    if (state == null || state.trim().length() <= 0) {
                        state = "show";
                    }
                    actions.add((IAction)new ShowViewAction(viewId, state));
                }
            } else if (SHOW_CHEAT_SHEET_TAG.equals(usecaseProps.getName())) {
                String cheatSheetId = usecaseProps.getAttribute(CHEAT_SHEET_ID_ATTR);
                if (cheatSheetId != null && cheatSheetId.trim().length() > 0) {
                    actions.add((IAction)new OpenCheatSheetAction(cheatSheetId));
                }
            } else if (SHOW_HELP_TAG.equals(usecaseProps.getName())) {
                String helpURL = usecaseProps.getAttribute(HELP_URL_ATTR);
                if (helpURL != null && helpURL.trim().length() > 0) {
                    actions.add((IAction)new OpenHelpAction(helpURL));
                }
            } else if (HIDE_VIEW_TAG.equals(usecaseProps.getName())) {
                viewId = usecaseProps.getAttribute(VIEW_ID_ATTR);
                if (viewId != null && viewId.trim().length() > 0) {
                    actions.add((IAction)new ShowViewAction(viewId, HIDE_VALUE));
                }
            } else if (SHOW_SOLUTION_TAG.equals(usecaseProps.getName())) {
                String solId = usecaseProps.getAttribute(SOLUTION_ID_ATTR);
                if (solId != null && solId.trim().length() > 0) {
                    actions.add((IAction)new ShowSolutionCommandAction(solId));
                }
            } else if (SHOW_NEW_WIZARD_TAG.equals(usecaseProps.getName())) {
                String wizardlId = usecaseProps.getAttribute(WIZARD_ID_ATTR);
                if (wizardlId != null && wizardlId.trim().length() > 0) {
                    actions.add((IAction)new OpenNewWizardCommandAction(wizardlId));
                }
            } else if (SHOW_WEB_PAGE_TAG.equals(usecaseProps.getName())) {
                String url = usecaseProps.getAttribute(URL_ATTR);
                String inEditor = usecaseProps.getAttribute(IN_EDITOR_ATTR);
                if (url != null && url.trim().length() > 0) {
                    if (inEditor != null && "true".equalsIgnoreCase(inEditor.trim())) {
                        actions.add((IAction)new OpenBrowserCommandAction(url));
                    } else {
                        actions.add((IAction)new OpenWebPageAction(url));
                    }
                }
            } else if (COMMAND_ACTION_TAG.equals(usecaseProps.getName())) {
                action = null;
                String id = usecaseProps.getAttribute(COMMAND_ID_ATTR);
                action = new GenericCommandAction(id);
                if (action != null) {
                    actions.add((IAction)action);
                }
            }
            ++n2;
        }
        return actions;
    }

    public static IAction getSwitcher() {
        return switcher;
    }

    private static ArrayList<IAction> addPerspectiveSwitcher(ArrayList<IAction> actions, String perspectiveId) {
        if (perspectiveId == null) {
            perspectiveId = "com.ibm.im.ims.workbench.IMSWorkbenchPerspective";
        }
        if (switcher == null) {
            switcher = new OpenPerspectiveAction(perspectiveId);
            actions.add(0, switcher);
        }
        return actions;
    }

    private static int processShowIn(String show) {
        if (show == null || show.trim().length() == 0 || SHOW_IN_SAME_VALUE.equalsIgnoreCase(show)) {
            return 2;
        }
        if (SHOW_IN_VIEW_VALUE.equalsIgnoreCase(show)) {
            return 1;
        }
        if (SHOW_IN_EDITOR_VALUE.equalsIgnoreCase(show)) {
            return 0;
        }
        return 3;
    }

    private static Solution getSolution(String id) {
        if (m_solutions == null && id != null && id.trim().length() > 0) {
            QuickLaunchSolutionManager.initSolutions(true);
        }
        return QuickLaunchSolutionManager.getSolutionInternal(id);
    }

    public static Solution getProductDefaultSolution(String productId) {
        if (m_solutions == null && productId != null && productId.trim().length() > 0) {
            QuickLaunchSolutionManager.initSolutions(true);
        }
        return QuickLaunchSolutionManager.getSolutionInternal(productId);
    }

    private static int convertToInt(String num, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(num);
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    private static Solution getSolutionInternal(String id) {
        Solution solution;
        if (m_solutions != null && (solution = m_solutions.get(id)) != null && solution.isDefined()) {
            return solution;
        }
        return null;
    }

    private static void assurePerspectiveListener() {
        IWorkbenchWindow active = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (active != null) {
            if (Activator.perspectiveListener == null) {
                Activator.perspectiveListener = new PerspectiveAdapter(){

                    private void setQuickLaunch(String perspectiveId) {
                        QuickLaunchSolutionManager.setSolutionId(perspectiveId);
                        try {
                            Solution solution = QuickLaunchSolutionManager.getViewSolution();
                            if (solution != null) {
                                QuickLaunchSolutionManager.assurePageListener();
                                switch (solution.getShowIn()) {
                                    case 3: {
                                        this.show(false);
                                        break;
                                    }
                                    case 0: {
                                        this.show(true);
                                        break;
                                    }
                                    case 1: {
                                        this.show(false);
                                        break;
                                    }
                                    case 2: {
                                        QuickLaunchSolutionManager.showUpdate();
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }

                    private void openQuickLaunch(String p_id) {
                        block9: {
                            QuickLaunchSolutionManager.setSolutionId(p_id);
                            try {
                                Solution solution = QuickLaunchSolutionManager.getViewSolution();
                                if (solution == null) break block9;
                                switch (solution.getShowIn()) {
                                    case 3: {
                                        this.show(false);
                                        break;
                                    }
                                    case 0: {
                                        this.show(true);
                                        solution.onOpenActions();
                                        break;
                                    }
                                    case 1: {
                                        this.show(false);
                                        break;
                                    }
                                    case 2: {
                                        Solution editorSolution;
                                        QuickLaunchSolutionManager.showUpdate();
                                        if (!QuickLaunchSolutionManager.isShowQuickLaunchEditor() || (editorSolution = QuickLaunchSolutionManager.getEditorSolution()) == null) break;
                                        editorSolution.onOpenActions();
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                            catch (PartInitException partInitException) {}
                        }
                    }

                    private void show(boolean editor) throws PartInitException {
                        QuickLaunchSolutionManager.showSolutionsEditor(editor);
                    }

                    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                        this.setQuickLaunch(perspective.getId());
                    }

                    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                        super.perspectiveOpened(page, perspective);
                        this.openQuickLaunch(perspective.getId());
                    }
                };
            }
            if (Activator.perspectiveListener != null) {
                active.addPerspectiveListener((IPerspectiveListener)Activator.perspectiveListener);
            }
        }
    }

    private static void assurePageListener() {
        IWorkbenchPage page;
        IWorkbenchWindow active = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (active != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            if (Activator.partListener == null) {
                Activator.partListener = new IPartListener2(){

                    private boolean isPartReferencingMe(IWorkbenchPartReference partRef) {
                        return "com.ibm.im.ims.workbench.quick.launch.ui.editor.QuickLaunchEditor".equals(partRef.getId());
                    }

                    public void partActivated(IWorkbenchPartReference partRef) {
                    }

                    public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    }

                    public void partClosed(IWorkbenchPartReference partRef) {
                        if (this.isPartReferencingMe(partRef)) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            boolean isWorkbenchClosing = PlatformUI.getWorkbench().isClosing();
                            IWorkbenchPage page = null;
                            if (window != null && (page = window.getActivePage()) != null) {
                                page.removePartListener((IPartListener2)this);
                                window.removePerspectiveListener((IPerspectiveListener)Activator.perspectiveListener);
                                Preferences prefs = Activator.getDefault().getPluginPreferences();
                                boolean bPrompt = prefs.getBoolean("com.ibm.datatools.quick.launch.ui.onClose.information");
                                if (!bPrompt && !isWorkbenchClosing) {
                                    String message = IAManager.QuickLaunchSolutionManager_CloseDialogMessage;
                                    CheckboxMessageDialog switcher = new CheckboxMessageDialog(window.getShell(), 2, "com.ibm.datatools.quick.launch.ui.onClose.information", IAManager.QuickLaunchSolutionManager_CloseDialogTitle, message, IAManager.QuickLaunchSolutionManager_CloseDialogPrompt, new String[]{IAManager.QuickLaunchSolutionManager_CloseDialogButton}, 0, bPrompt);
                                    switcher.open();
                                    prefs.setValue("com.ibm.datatools.quick.launch.ui.onClose.information", switcher.isCheckboxSelected());
                                }
                            }
                        }
                    }

                    public void partDeactivated(IWorkbenchPartReference partRef) {
                    }

                    public void partHidden(IWorkbenchPartReference partRef) {
                    }

                    public void partInputChanged(IWorkbenchPartReference partRef) {
                    }

                    public void partOpened(IWorkbenchPartReference partRef) {
                    }

                    public void partVisible(IWorkbenchPartReference partRef) {
                        if (this.isPartReferencingMe(partRef)) {
                            this.updateContent(partRef);
                        }
                    }

                    private void updateContent(IWorkbenchPartReference partRef) {
                        try {
                            QuickLaunchSolutionManager.showUpdate();
                        }
                        catch (PartInitException e) {
                            Activator.log(e);
                        }
                    }
                };
            }
            if (Activator.partListener != null) {
                page.addPartListener(Activator.partListener);
            }
        }
    }

    public static class Group {
        String id;
        String label;
        int rank;
        int rowspan;
        String colorId;
        int vspace;

        public Group(String groupId, String groupLabel, String color, int groupRank, int groupRowspan, int verticalSpacing) {
            this.id = groupId;
            this.rank = groupRank;
            this.colorId = color;
            this.rowspan = groupRowspan;
            this.label = groupLabel;
            this.vspace = verticalSpacing;
        }

        public String getId() {
            return this.id;
        }

        public int getRank() {
            return this.rank;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public String getLabel() {
            return this.label;
        }

        public Color getColor() {
            return QuickLaunchSolutionManager.getColor(this.colorId);
        }

        public int getVerticalSpacing() {
            return this.vspace;
        }
    }

    public static class Solution {
        String m_label;
        String m_id;
        int m_show;
        Map<String, ArrayList<UseCase>> m_usecases = new HashMap<String, ArrayList<UseCase>>();
        ArrayList<Group> m_groups = new ArrayList();
        Map<String, ArrayList<IAction>> m_macros = new HashMap<String, ArrayList<IAction>>();
        String m_imagePath;
        boolean m_isDefined;
        String m_macroIdOnOpen;
        String m_parentSolutionId;
        int m_rank;
        Set<String> m_boundProductIds = new HashSet<String>();

        public Solution(String id, String label, String imagePath, int show, String macroIdOnOpen, String parentSolutionId, int rank) {
            this.m_label = label;
            this.m_id = id;
            this.m_imagePath = imagePath;
            this.m_isDefined = true;
            this.m_show = show;
            this.m_macroIdOnOpen = macroIdOnOpen;
            this.m_parentSolutionId = parentSolutionId;
            this.m_rank = rank;
        }

        public Solution(String id) {
            this.m_isDefined = false;
            this.m_id = id;
            this.m_show = 3;
        }

        public boolean isDefined() {
            return this.m_isDefined;
        }

        public String getId() {
            return this.m_id;
        }

        public void setDefined(boolean isDefined, String label, String imagePath, int show, int solutionRank) {
            this.m_label = label;
            this.m_imagePath = imagePath;
            this.m_isDefined = isDefined && label != null;
            this.m_show = show;
            this.m_rank = solutionRank;
        }

        public int getShowIn() {
            return this.m_show;
        }

        public void setIsVisible(int show) {
            this.m_show = show;
        }

        public void addAll(ArrayList<UseCase> usecases) {
            for (UseCase usecase : usecases) {
                this.add(usecase);
            }
        }

        public void add(UseCase usecase) {
            ArrayList<UseCase> savedUsecases = this.m_usecases.get(usecase.getGroup());
            if (savedUsecases == null) {
                savedUsecases = new ArrayList();
                this.m_usecases.put(usecase.getGroup(), savedUsecases);
            }
            savedUsecases.add(usecase);
        }

        public void add(Group group) {
            for (Group g : this.m_groups) {
                if (!g.getId().equals(group.getId())) continue;
                return;
            }
            this.m_groups.add(group);
        }

        public void addMacro(String p_macroId, ArrayList<IAction> p_actions) {
            this.m_macros.put(p_macroId, p_actions);
        }

        public IAction getMacro(String p_macroId) {
            if (this.m_macroIdOnOpen != null && this.m_macroIdOnOpen.trim().length() > 0) {
                Object action = null;
                final ArrayList<IAction> actions = this.m_macros.get(p_macroId);
                if (actions != null) {
                    if (actions.size() == 1) {
                        action = actions.get(0);
                    } else if (actions.size() > 1) {
                        action = new Action(){

                            public void run() {
                                for (IAction action : actions) {
                                    action.run();
                                }
                            }
                        };
                    }
                }
                return action;
            }
            return null;
        }

        public void bindProductId(String p_productId) {
            this.m_boundProductIds.add(p_productId);
        }

        public boolean isSolutionForProductId(String p_productId) {
            return this.m_boundProductIds.contains(p_productId);
        }

        public String getParentSolutionId() {
            return this.m_parentSolutionId;
        }

        public int getRank() {
            return this.m_rank;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getImagePath() {
            return this.m_imagePath;
        }

        protected void rankChildren() {
            for (ArrayList<UseCase> usecases : this.m_usecases.values()) {
                Collections.sort(usecases, new Comparator<UseCase>(){

                    @Override
                    public int compare(UseCase object1, UseCase object2) {
                        return object1.getRank() - object2.getRank();
                    }
                });
            }
            Collections.sort(this.m_groups, new Comparator<Group>(){

                @Override
                public int compare(Group object1, Group object2) {
                    return object1.getRank() - object2.getRank();
                }
            });
        }

        public ArrayList<UseCase> getUseCases(String group) {
            return this.m_usecases.get(group);
        }

        public ArrayList<Group> getGroups() {
            return this.m_groups;
        }

        public void onOpenActions() {
            IAction action;
            if (this.m_macroIdOnOpen != null && this.m_macroIdOnOpen.trim().length() > 0 && (action = this.getMacro(this.m_macroIdOnOpen)) != null) {
                try {
                    action.run();
                }
                catch (NullPointerException e) {
                    Activator.log(e);
                }
            }
        }
    }

    public static class UseCase {
        String label;
        String description;
        String imagePath;
        IAction action;
        String group;
        int rank;

        public UseCase(String label, String description, String imagePath, ArrayList<IAction> actions, String group, int rank) {
            this.label = label;
            this.description = description;
            this.imagePath = imagePath;
            this.action = this.groupActions(actions);
            this.group = group;
            this.rank = rank;
        }

        private IAction groupActions(final ArrayList<IAction> actions) {
            Object action = null;
            if (actions != null) {
                if (actions.size() == 1) {
                    action = actions.get(0);
                } else if (actions.size() > 1) {
                    action = new Action(){

                        public void run() {
                            for (IAction action : actions) {
                                action.run();
                            }
                        }
                    };
                }
            }
            return action;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public IAction getAction() {
            return this.action;
        }

        public String getGroup() {
            return this.group;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

