/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.i18n;

import com.ibm.datatools.quick.launch.ui.Activator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class IconManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String QUICK_LAUNCH_UI_ICONS_FOLDER_URL = "platform:/plugin/com.ibm.im.ims.workbench.quick.launch.ui/icons/";
    public static final String OPTIM_BANNER = "platform:/plugin/com.ibm.im.ims.workbench.quick.launch.ui/icons/optimBanner.png";

    public static String[] getIconKeys() {
        ArrayList<String> iconKeys = new ArrayList<String>();
        try {
            Class<?> c = Class.forName("IconManager");
            Field[] f = c.getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                String val = null;
                try {
                    val = (String)f[i].get(val);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                if (val != null) {
                    iconKeys.add(val);
                }
                ++i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return iconKeys.toArray(new String[iconKeys.size()]);
    }

    public static Image getImage(String p_key) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(p_key);
        if (image == null) {
            try {
                URL url = new URL(p_key);
                ImageDescriptor descr = ImageDescriptor.createFromURL((URL)url);
                image = descr.createImage();
                registry.put(p_key, descr);
            }
            catch (IOException e) {
                System.err.println("Unable to resolve url" + p_key);
                Activator.getDefault().log((IStatus)new Status(4, "com.ibm.datatools.quick.launch.ui", e.getMessage() + " Unable to resolve url" + p_key));
            }
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String p_key) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        ImageDescriptor descr = registry.getDescriptor(p_key);
        if (descr == null) {
            try {
                URL url = new URL(p_key);
                descr = ImageDescriptor.createFromURL((URL)url);
                descr.createImage();
                registry.put(p_key, descr);
            }
            catch (IOException e) {
                System.err.println("Unable to resolve url" + p_key);
                Activator.getDefault().log((IStatus)new Status(4, "com.ibm.datatools.quick.launch.ui", e.getMessage()));
            }
        }
        return descr;
    }
}

