/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.actions;

import com.ibm.datatools.quick.launch.ui.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;

public class ShowViewAction
extends Action {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String m_viewId = null;
    int m_state;
    boolean m_show;

    public ShowViewAction(String p_viewId, String p_state) {
        this.m_viewId = p_viewId;
        this.setState(p_state);
    }

    protected void setState(String p_state) {
        if (p_state != null) {
            String state = p_state.trim();
            this.m_show = true;
            if ("minimize".equals(state)) {
                this.m_state = 0;
            } else if ("maximize".equals(state)) {
                this.m_state = 1;
            } else if ("hide".equals(state)) {
                this.m_show = false;
                this.m_state = 1;
            } else {
                this.m_state = 2;
            }
        } else {
            this.m_state = 2;
            this.m_show = true;
        }
    }

    public void run() {
        try {
            IWorkbenchWindow window;
            IWorkbenchPage pg;
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (pg = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) instanceof WorkbenchPage) {
                WorkbenchPage page = (WorkbenchPage)pg;
                IViewPart view = page.findView(this.m_viewId);
                if (this.m_show) {
                    if (view == null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.m_viewId);
                        view = page.findView(this.m_viewId);
                    }
                    if (view != null) {
                        IViewReference ref = page.findViewReference(this.m_viewId);
                        int state = page.getPartState((IWorkbenchPartReference)ref);
                        if (state != this.m_state && this.m_state != 0) {
                            page.setPartState((IWorkbenchPartReference)ref, this.m_state);
                        }
                        if (this.m_state != 0) {
                            page.setPartState((IWorkbenchPartReference)ref, this.m_state);
                            page.bringToTop((IWorkbenchPart)view);
                        }
                    }
                } else if (view != null) {
                    page.hideView(view);
                }
            }
        }
        catch (PartInitException e) {
            Activator.getDefault().log((IStatus)new Status(4, "com.ibm.datatools.quick.launch.ui", e.getMessage()));
        }
    }
}

