/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.actions;

import com.ibm.datatools.quick.launch.ui.Activator;
import com.ibm.datatools.quick.launch.ui.actions.AbstractCommandHandlerAction;
import com.ibm.datatools.quick.launch.ui.internal.core.QuickLaunchSolutionManager;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.intro.IIntroPart;

public class OpenQuickLaunchEditor
extends AbstractCommandHandlerAction
implements IStartup,
IWorkbenchWindowActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String QUICK_LAUNCH_EDITOR_COMMAND_ID = "com.ibm.im.ims.workbench.quick.launch.ui.commands.quickLaunchEditor";

    @Override
    protected void execute(IHandlerService handlerService) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        handlerService.executeCommand(QUICK_LAUNCH_EDITOR_COMMAND_ID, null);
    }

    public void earlyStartup() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        boolean showTaskLauncher = preferences.getBoolean("com.ibm.datatools.quick.launch.ui.showTaskLauncher");
        if (showTaskLauncher) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IProduct product = Platform.getProduct();
                    if (product != null) {
                        QuickLaunchSolutionManager.Solution solutionForProductId = this.getDefaultSolutionForProductId(product.getId());
                        if (solutionForProductId == null) {
                            solutionForProductId = QuickLaunchSolutionManager.getDefaultSolution();
                        }
                        if (solutionForProductId != null) {
                            QuickLaunchSolutionManager.setSolutionId(solutionForProductId.getId());
                            OpenQuickLaunchEditor.this.run();
                            if (QuickLaunchSolutionManager.isShowQuickLaunchEditor()) {
                                solutionForProductId.onOpenActions();
                            }
                            this.closeIntro();
                        }
                    }
                }

                private void closeIntro() {
                    IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
                    if (intro != null) {
                        PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
                    }
                }

                private boolean isNoEditorOpen() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = null;
                    return window != null && (page = window.getActivePage()) != null && page.getEditorReferences() != null && page.getEditorReferences().length == 0;
                }

                private QuickLaunchSolutionManager.Solution getDefaultSolutionForProductId(String p_productId) {
                    QuickLaunchSolutionManager.Solution[] solutionArray = QuickLaunchSolutionManager.getAllSolutions();
                    int n = solutionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        QuickLaunchSolutionManager.Solution solution = solutionArray[n2];
                        if (solution.isSolutionForProductId(p_productId)) {
                            return solution;
                        }
                        ++n2;
                    }
                    return null;
                }
            });
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        super.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

