/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.actions;

import com.ibm.datatools.quick.launch.ui.Activator;
import com.ibm.datatools.quick.launch.ui.actions.CheckboxMessageDialog;
import com.ibm.datatools.quick.launch.ui.i18n.IAManager;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenPerspectiveAction
extends Action {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String m_perspectiveId;

    public OpenPerspectiveAction(String id) {
        this.m_perspectiveId = id;
    }

    public void run() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                IPerspectiveDescriptor perspective = workbench.getPerspectiveRegistry().findPerspectiveWithId(this.m_perspectiveId);
                if (page.getPerspective() != perspective) {
                    Preferences prefs = Activator.getDefault().getPluginPreferences();
                    boolean bPrompt = prefs.getBoolean("com.ibm.datatools.quick.launch.ui.changePerspective.query");
                    if (bPrompt) {
                        String question = MessageFormat.format(IAManager.OpenPerspectiveAction_CHANGE_PERSPECTIVE_QUERY, perspective.getLabel());
                        String title = IAManager.OpenPerspectiveAction_CHANGE_PERSPECTIVE_TITLE;
                        PerspectiveSwitchMessage switcher = new PerspectiveSwitchMessage(window.getShell(), 3, this.m_perspectiveId, title, question, IAManager.OpenHelpAction_HELP_REMEMBER_CHOICE, new String[]{IAManager.OpenHelpAction_YES_BTN, IAManager.OpenHelpAction_NO_BTN}, 0, !bPrompt);
                        if (switcher.open() == 0) {
                            page.setPerspective(perspective);
                        }
                        prefs.setValue("com.ibm.datatools.quick.launch.ui.changePerspective.query", !switcher.isCheckboxSelected());
                        prefs.setValue("com.ibm.datatools.quick.launch.ui.changePerspective.action", switcher.getReturnCode() == 0);
                    } else if (prefs.getBoolean("com.ibm.datatools.quick.launch.ui.changePerspective.action")) {
                        page.setPerspective(perspective);
                    }
                }
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    class PerspectiveSwitchMessage
    extends CheckboxMessageDialog {
        public PerspectiveSwitchMessage(Shell parentShell, int type, String propertiesKey, String title, String message, String checkboxLabel, String[] buttonsLabel, int defaultButtonIndex, boolean checkboxSelected) {
            super(parentShell, type, propertiesKey, title, message, checkboxLabel, buttonsLabel, defaultButtonIndex, checkboxSelected);
        }
    }
}

