/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.actions;

import com.ibm.datatools.quick.launch.ui.Activator;
import com.ibm.datatools.quick.launch.ui.actions.CheckboxMessageDialog;
import com.ibm.datatools.quick.launch.ui.actions.ShowViewAction;
import com.ibm.datatools.quick.launch.ui.i18n.IAManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenHelpAction
extends Action {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String m_url = null;

    public OpenHelpAction(String p_url) {
        this.m_url = p_url;
    }

    public void run() {
        IWorkbenchPage page;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            Preferences prefs = Activator.getDefault().getPluginPreferences();
            boolean bPrompt = prefs.getBoolean("com.ibm.datatools.quick.launch.ui.showHelp.query");
            if (bPrompt) {
                String question = IAManager.OpenHelpAction_GET_HELP_QUERY;
                CheckboxMessageDialog switcher = new CheckboxMessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 3, "com.ibm.datatools.quick.launch.ui.showHelp.query", IAManager.OpenHelpAction_HELP_DIALOG_TITLE, question, IAManager.OpenHelpAction_HELP_REMEMBER_CHOICE, new String[]{IAManager.OpenHelpAction_YES_BTN, IAManager.OpenHelpAction_NO_BTN}, 0, !bPrompt);
                if (switcher.open() == 0) {
                    this.launchHelp(page);
                } else {
                    this.hideHelp(page);
                }
                prefs.setValue("com.ibm.datatools.quick.launch.ui.showHelp.query", !switcher.isCheckboxSelected());
                prefs.setValue("com.ibm.datatools.quick.launch.ui.showHelp.action", switcher.getReturnCode() == 0);
            } else if (prefs.getBoolean("com.ibm.datatools.quick.launch.ui.showHelp.action")) {
                this.launchHelp(page);
            } else {
                this.hideHelp(page);
            }
        }
    }

    private void launchHelp(IWorkbenchPage page) {
        try {
            Preferences prefs = Activator.getDefault().getPluginPreferences();
            boolean windowPref = prefs.getBoolean("com.ibm.datatools.quick.launch.ui.showHelpWindow.action");
            if (!windowPref) {
                IViewPart view = page.showView("org.eclipse.help.ui.HelpView");
                if (view instanceof HelpView) {
                    ((HelpView)view).showHelp(this.m_url);
                }
            } else {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.m_url);
            }
        }
        catch (PartInitException e) {
            Activator.log(e);
        }
    }

    private void hideHelp(IWorkbenchPage page) {
        ShowViewAction hideView = new ShowViewAction("org.eclipse.help.ui.HelpView", "hide");
        hideView.run();
    }
}

