/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.actions;

import com.ibm.datatools.quick.launch.ui.actions.AbstractCommandHandlerAction;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class OpenBrowserCommandAction
extends AbstractCommandHandlerAction {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String OPEN_BROWSER = "org.eclipse.ui.browser.openBrowser";
    public static final String OPEN_BROWSER_URL = "url";
    private String m_url;

    public OpenBrowserCommandAction(String url) {
        this.m_url = url;
    }

    @Override
    protected void execute(IWorkbenchPage page) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        ICommandService commandService = (ICommandService)page.getActivePart().getSite().getService(ICommandService.class);
        if (commandService != null) {
            Command command = commandService.getCommand(OPEN_BROWSER);
            IParameter urlParm = command.getParameter(OPEN_BROWSER_URL);
            Parameterization parm = new Parameterization(urlParm, this.m_url);
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm});
            IHandlerService handlerService = (IHandlerService)page.getActivePart().getSite().getService(IHandlerService.class);
            if (handlerService != null) {
                handlerService.executeCommand(parmCommand, null);
            }
        }
    }
}

