/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CheckboxMessageDialog
extends MessageDialog
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button checkbox = null;
    private boolean checkboxSelected = false;
    private String checkboxLabel;
    private String propertiesKey = null;

    public CheckboxMessageDialog(Shell parentShell, int type, String propertiesKey, String title, String message, String checkboxLabel, String[] buttonsLabel, int defaultButtonIndex, boolean checkboxSelected) {
        super(parentShell, title, null, message, type, buttonsLabel, defaultButtonIndex);
        this.setCheckboxLabel(checkboxLabel);
        this.setPropertiesKey(propertiesKey);
        this.setCheckboxSelected(checkboxSelected);
        this.setBlockOnOpen(true);
    }

    public Control createCustomArea(Composite parent) {
        GridData gd = new GridData();
        gd.heightHint = 40;
        gd.verticalAlignment = 2;
        Button checkbox = new Button(parent, 32);
        checkbox.setText(this.getCheckboxLabel());
        checkbox.setSelection(this.isCheckboxSelected());
        checkbox.setLayoutData((Object)gd);
        checkbox.addSelectionListener((SelectionListener)this);
        this.setCheckbox(checkbox);
        return checkbox;
    }

    private Button getCheckbox() {
        return this.checkbox;
    }

    private void setCheckbox(Button checkbox) {
        this.checkbox = checkbox;
    }

    public String getPropertiesKey() {
        return this.propertiesKey;
    }

    private void setPropertiesKey(String propertiesKey) {
        this.propertiesKey = propertiesKey;
    }

    private String getCheckboxLabel() {
        return this.checkboxLabel;
    }

    private void setCheckboxLabel(String checkboxLabel) {
        this.checkboxLabel = checkboxLabel;
    }

    private void setCheckboxSelected(boolean sw) {
        this.checkboxSelected = sw;
    }

    public boolean isCheckboxSelected() {
        return this.checkboxSelected;
    }

    public Button getSelectedButton() {
        Button button = null;
        try {
            button = this.getButton(this.getReturnCode());
        }
        catch (Exception exception) {}
        return button;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.getCheckbox())) {
            this.setCheckboxSelected(this.getCheckbox().getSelection());
        }
    }
}

