/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.quick.launch.ui;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PLUGIN_ID = "com.ibm.datatools.quick.launch.ui";
    private static Activator plugin;
    public static PerspectiveAdapter perspectiveListener;
    public static IPartListener2 partListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void log(IStatus status) {
        int severity = status.getSeverity();
        switch (severity) {
            case 0: {
                logger.fine(status.getMessage());
                break;
            }
            case 4: {
                logger.error(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            case 2: {
                logger.warn(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            default: {
                logger.info(status.getMessage(), status.getException(), new Object[0]);
            }
        }
    }

    public static void log(Throwable e) {
        String message = e.getMessage();
        Throwable old = e;
        Throwable error = e;
        IStatus status = null;
        if (e instanceof InvocationTargetException) {
            error = ((InvocationTargetException)e).getTargetException();
            if (error == null) {
                error = old;
            } else if (error.getMessage() != null) {
                message = error.getMessage();
            }
        }
        if (error instanceof CoreException) {
            status = ((CoreException)error).getStatus();
        } else {
            if (message == null) {
                message = "";
            }
            status = new Status(4, PLUGIN_ID, 0, message, error);
        }
        Activator.getDefault().log(status);
    }

    public static void log(String message) {
        Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }
}

