/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sql.ui;

import com.ibm.ims.datatools.sqltools.sql.parser.ast.Node;
import com.ibm.ims.datatools.sqltools.sql.ui.INodesImageHandler;
import com.ibm.ims.datatools.sqltools.sql.ui.SQLUIActivator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;

public class SQLImageService {
    public static final SQLImageService INSTANCE = new SQLImageService();
    private Map _nodeImageHandlerMap = new HashMap();

    private SQLImageService() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.ims.datatools.sqltools.sql.ui", "sqlNodesImage");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("nodeImage")) {
                    String nodeClazz = configElements[j].getAttribute("nodeClazzName");
                    INodesImageHandler handler = null;
                    try {
                        handler = (INodesImageHandler)configElements[j].createExecutableExtension("imageHandler");
                        this._nodeImageHandlerMap.put(nodeClazz, handler);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, SQLUIActivator.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the sql node image handler for " + nodeClazz, (Throwable)e);
                        SQLUIActivator.getDefault().log((IStatus)status);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public INodesImageHandler getImageHandler(Node node) {
        INodesImageHandler handler = null;
        Class<?> nodeClazz = node.getClass();
        while (nodeClazz != null) {
            String clazzName = nodeClazz.getName();
            handler = (INodesImageHandler)this._nodeImageHandlerMap.get(clazzName);
            if (handler != null) break;
            nodeClazz = nodeClazz.getSuperclass();
        }
        return handler;
    }

    public Image getNodeImage(Node node) {
        INodesImageHandler handler = this.getImageHandler(node);
        if (handler != null) {
            return handler.getImage(node);
        }
        return null;
    }
}

