/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.icu.text.MessageFormat;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.Messages;
import com.ibm.ims.datatools.modelbase.sql.datatypes.UserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCUDTSuperTypeLoader
extends JDBCBaseLoader {
    public static final String COLUMN_SUPERTYPE_CAT = "SUPERTYPE_CAT";
    public static final String COLUMN_SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    public static final String COLUMN_SUPERTYPE_NAME = "SUPERTYPE_NAME";

    public JDBCUDTSuperTypeLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCUDTSuperTypeLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof UserDefinedType);
    }

    public UserDefinedType loadSuperType() throws SQLException {
        UserDefinedType retVal = null;
        ResultSet rs = null;
        try {
            rs = this.createResultSet();
            if (rs.next()) {
                retVal = this.findUserDefinedType(rs.getString(COLUMN_SUPERTYPE_CAT), rs.getString(COLUMN_SUPERTYPE_SCHEM), rs.getString(COLUMN_SUPERTYPE_NAME));
            }
            UserDefinedType userDefinedType = retVal;
            return userDefinedType;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    protected ResultSet createResultSet() throws SQLException {
        ResultSet retVal = null;
        try {
            UserDefinedType udt = this.getUserDefinedType();
            Schema schema = udt.getSchema();
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                retVal = sqlConn.getMetaData().getSuperTypes(schema.getCatalog().getName(), schema.getName(), udt.getName());
            }
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getSuperTypes()"}));
            error.initCause(e);
            throw error;
        }
        return retVal;
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected UserDefinedType getUserDefinedType() {
        return (UserDefinedType)this.getCatalogObject();
    }

    protected UserDefinedType findUserDefinedType(String catalogName, String schemaName, String typeName) {
        if (typeName == null) {
            return null;
        }
        if (catalogName == null) {
            catalogName = new String();
        }
        if (schemaName == null) {
            schemaName = new String();
        }
        Database db = this.getCatalogObject().getCatalogDatabase();
        for (Catalog catalog : db.getCatalogs()) {
            if (!catalogName.equals(catalog.getName())) continue;
            for (Schema schema : catalog.getSchemas()) {
                if (!schemaName.equals(schema.getName())) continue;
                for (UserDefinedType udt : schema.getUserDefinedTypes()) {
                    if (!typeName.equals(udt.getName())) continue;
                    return udt;
                }
            }
        }
        return null;
    }
}

