/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.icu.text.MessageFormat;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.Messages;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCTableSuperTableLoader
extends JDBCBaseLoader {
    public static final String COLUMN_SUPERTABLE_NAME = "SUPERTABLE_NAME";

    public JDBCTableSuperTableLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableSuperTableLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Table);
    }

    public Table loadSuperTable() throws SQLException {
        Table retVal = null;
        ResultSet rs = null;
        try {
            rs = this.createResultSet();
            if (rs.next()) {
                retVal = this.findTable(rs.getString(COLUMN_SUPERTABLE_NAME));
            }
            Table table = retVal;
            return table;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    protected ResultSet createResultSet() throws SQLException {
        ResultSet retVal = null;
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                retVal = sqlConn.getMetaData().getSuperTables(schema.getCatalog().getName(), schema.getName(), table.getName());
            }
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getSuperTables()"}));
            error.initCause(e);
            throw error;
        }
        return retVal;
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected Table findTable(String tableName) {
        if (tableName == null) {
            return null;
        }
        for (Table table : this.getTable().getSchema().getTables()) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return null;
    }
}

