/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.icu.text.MessageFormat;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCIndex;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.Messages;
import com.ibm.ims.datatools.modelbase.sql.constraints.IncrementType;
import com.ibm.ims.datatools.modelbase.sql.constraints.Index;
import com.ibm.ims.datatools.modelbase.sql.constraints.IndexMember;
import com.ibm.ims.datatools.modelbase.sql.constraints.SQLConstraintsFactory;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JDBCTableIndexLoader
extends JDBCBaseLoader {
    public static final String COLUMN_NON_UNIQUE = "NON_UNIQUE";
    public static final String COLUMN_INDEX_QUALIFIER = "INDEX_QUALIFIER";
    public static final String COLUMN_INDEX_NAME = "INDEX_NAME";
    public static final String COLUMN_TYPE = "TYPE";
    public static final String COLUMN_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_ASC_OR_DESC = "ASC_OR_DESC";
    public static final String TYPE_ORDER_ASC = "A";
    public static final String TYPE_ORDER_DESC = "D";

    public JDBCTableIndexLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableIndexLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Table);
    }

    public List loadIndexes() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadIndexes(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadIndexes(List containmentList, Collection existingIndexes) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            Index index = null;
            rs = this.createResultSet();
            while (rs.next()) {
                IndexMember im;
                Column column;
                String indexName = rs.getString(COLUMN_INDEX_NAME);
                if (indexName == null || this.isFiltered(indexName) || rs.getShort(COLUMN_TYPE) == 0) continue;
                if (index == null || !index.getName().equals(indexName)) {
                    index = (Index)this.getAndRemoveSQLObject(existingIndexes, indexName);
                    if (index == null) {
                        index = this.createIndex();
                        this.initIndex(index, rs);
                    } else {
                        this.initIndex(index, rs);
                        index.getMembers().clear();
                        if (index instanceof ICatalogObject) {
                            ((ICatalogObject)index).refresh();
                        }
                    }
                    containmentList.add(index);
                }
                if ((column = this.findColumn(rs.getString(COLUMN_COLUMN_NAME))) == null || (im = this.createIndexMember()) == null) continue;
                this.initIndexMember(im, column, rs);
                index.getMembers().add((Object)im);
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearIndexes(List indexes) {
        indexes.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        ResultSet retVal = null;
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                retVal = sqlConn.getMetaData().getIndexInfo(schema.getCatalog().getName(), schema.getName(), table.getName(), false, false);
            }
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getIndexInfo()"}));
            error.initCause(e);
            throw error;
        }
        return retVal;
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Index createIndex() {
        return new JDBCIndex();
    }

    protected void initIndex(Index index, ResultSet rs) throws SQLException {
        index.setName(rs.getString(COLUMN_INDEX_NAME));
        index.setUnique(!rs.getBoolean(COLUMN_NON_UNIQUE));
        index.setSchema(this.findSchema(rs.getString(COLUMN_INDEX_QUALIFIER)));
        index.setClustered(1 == rs.getShort(COLUMN_TYPE));
    }

    protected void initIndexMember(IndexMember im, Column column, ResultSet rs) throws SQLException {
        im.setColumn(column);
        im.setIncrementType(this.getIncrementType(rs.getString(COLUMN_ASC_OR_DESC)));
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected IndexMember createIndexMember() {
        return SQLConstraintsFactory.eINSTANCE.createIndexMember();
    }

    protected IncrementType getIncrementType(String type) {
        if (TYPE_ORDER_ASC.equals(type)) {
            return IncrementType.ASC_LITERAL;
        }
        if (TYPE_ORDER_DESC.equals(type)) {
            return IncrementType.DESC_LITERAL;
        }
        return null;
    }

    protected Column findColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        for (Column column : this.getTable().getColumns()) {
            if (!columnName.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    protected Schema findSchema(String schemaName) {
        if (schemaName == null) {
            return this.getTable().getSchema();
        }
        Table table = this.getTable();
        if (schemaName.equals(table.getSchema().getName())) {
            return table.getSchema();
        }
        for (Schema schema : table.getSchema().getCatalog().getSchemas()) {
            if (!schemaName.equals(schema.getName())) continue;
            return schema;
        }
        return table.getSchema();
    }
}

