/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.icu.text.MessageFormat;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.Messages;
import com.ibm.ims.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import com.ibm.ims.datatools.modelbase.sql.datatypes.DataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.PredefinedDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.ReferenceDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.TimeDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.UserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCTableColumnLoader
extends JDBCBaseLoader {
    public static final String COLUMN_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_COLUMN_SIZE = "COLUMN_SIZE";
    public static final String COLUMN_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String COLUMN_NULLABLE = "NULLABLE";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_COLUMN_DEF = "COLUMN_DEF";
    public static final String COLUMN_SCOPE_CATALOG = "SCOPE_CATALOG";
    public static final String COLUMN_SCOPE_SCHEMA = "SCOPE_SCHEMA";
    public static final String COLUMN_SCOPE_TABLE = "SCOPE_TABLE";
    private Pattern mUDTNameMatcherPattern;
    private boolean mCatalogAtStart;

    public JDBCTableColumnLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableColumnLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Table);
    }

    public List loadColumns() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadColumns(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadColumns(List containmentList, Collection existingColumns) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                String columnName = rs.getString(COLUMN_COLUMN_NAME);
                if (columnName == null || this.isFiltered(columnName)) continue;
                Column column = (Column)this.getAndRemoveSQLObject(existingColumns, columnName);
                if (column == null) {
                    column = this.processRow(rs);
                    if (column == null) continue;
                    containmentList.add(column);
                    continue;
                }
                this.initialize(column, rs);
                containmentList.add(column);
                if (!(column instanceof ICatalogObject)) continue;
                ((ICatalogObject)column).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearColumns(List columns) {
        columns.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        ResultSet retVal = null;
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                retVal = sqlConn.getMetaData().getColumns(schema.getCatalog().getName(), schema.getName(), table.getName(), null);
            }
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getColumns()"}));
            error.initCause(e);
            throw error;
        }
        return retVal;
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Column processRow(ResultSet rs) throws SQLException {
        Column column = this.createColumn();
        this.initialize(column, rs);
        return column;
    }

    protected Column createColumn() {
        return new JDBCColumn();
    }

    protected void initialize(Column column, ResultSet rs) throws SQLException {
        column.setName(rs.getString(COLUMN_COLUMN_NAME));
        column.setDescription(rs.getString(COLUMN_REMARKS));
        column.setDefaultValue(rs.getString(COLUMN_COLUMN_DEF));
        this.initColumnType(column, rs);
        column.setNullable(rs.getInt(COLUMN_NULLABLE) == 1);
    }

    protected void initColumnType(Column column, ResultSet rs) throws SQLException {
        String typeName = rs.getString(COLUMN_TYPE_NAME).toUpperCase();
        int typeCode = rs.getInt(COLUMN_DATA_TYPE);
        List pdtds = this.getDatabaseDefinition().getPredefinedDataTypeDefinitionsByJDBCEnumType(typeCode);
        PredefinedDataTypeDefinition pdtd = null;
        if (pdtds != null && !pdtds.isEmpty()) {
            Iterator it = pdtds.iterator();
            block0: while (pdtd == null && it.hasNext()) {
                PredefinedDataTypeDefinition curPDTD = (PredefinedDataTypeDefinition)it.next();
                for (String name : curPDTD.getName()) {
                    if (!typeName.equals(name)) continue;
                    pdtd = curPDTD;
                    continue block0;
                }
            }
        }
        if (pdtd == null) {
            pdtd = this.getDatabaseDefinition().getPredefinedDataTypeDefinition(typeName);
        }
        if (pdtd != null || pdtd == null && typeCode != 1111 && typeCode != 2006) {
            EStructuralFeature feature;
            if (pdtd == null) {
                pdtd = (PredefinedDataTypeDefinition)pdtds.get(0);
            }
            PredefinedDataType pdt = this.getDatabaseDefinition().getPredefinedDataType(pdtd);
            if (pdtd.isLengthSupported()) {
                feature = pdt.eClass().getEStructuralFeature("length");
                pdt.eSet(feature, (Object)rs.getInt(COLUMN_COLUMN_SIZE));
            }
            if (pdtd.isPrecisionSupported()) {
                feature = null;
                feature = pdt instanceof TimeDataType ? pdt.eClass().getEStructuralFeature("fractionalSecondsPrecision") : pdt.eClass().getEStructuralFeature("precision");
                if (feature != null) {
                    pdt.eSet(feature, (Object)rs.getInt(COLUMN_COLUMN_SIZE));
                }
            }
            if (pdtd.isScaleSupported() && (feature = pdt.eClass().getEStructuralFeature("scale")) != null) {
                pdt.eSet(feature, (Object)rs.getInt(COLUMN_DECIMAL_DIGITS));
            }
            column.setDataType((DataType)pdt);
            return;
        }
        if (typeName == null) {
            column.setDataType(null);
            return;
        }
        if (2006 == typeCode) {
            ReferenceDataType ref = this.createReferenceDataType();
            if (ref == null) {
                column.setDataType(null);
                return;
            }
            UserDefinedType udt = this.findUserDefinedType(typeName);
            Table table = this.findScopedTable(rs.getString(COLUMN_SCOPE_CATALOG), rs.getString(COLUMN_SCOPE_SCHEMA), rs.getString(COLUMN_SCOPE_TABLE));
            this.initReferenceDataType(ref, udt, table);
            column.setDataType((DataType)ref);
        } else {
            UserDefinedType udt = this.findUserDefinedType(typeName);
            column.setDataType((DataType)udt);
        }
    }

    protected ReferenceDataType createReferenceDataType() {
        return null;
    }

    protected void initReferenceDataType(ReferenceDataType ref, UserDefinedType udt, Table scopeTable) {
        if (udt instanceof StructuredUserDefinedType) {
            ref.setReferencedType((StructuredUserDefinedType)udt);
        }
        ref.setScopeTable(scopeTable);
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected DatabaseDefinition getDatabaseDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogObject().getCatalogDatabase());
    }

    protected Matcher getUDTNameMatcher(String name) throws SQLException {
        if (this.mUDTNameMatcherPattern == null) {
            DatabaseMetaData dbmd = null;
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                dbmd = sqlConn.getMetaData();
            }
            String namePattern = "([a-zA-Z0-9_" + dbmd.getExtraNameCharacters() + "]*)";
            String catalogSeparator = dbmd.getCatalogSeparator();
            String regex = namePattern + "." + namePattern;
            if (name.indexOf(catalogSeparator) < 0) {
                regex = regex + "()";
            } else if (dbmd.isCatalogAtStart()) {
                this.mCatalogAtStart = true;
                regex = namePattern + catalogSeparator + regex;
            } else {
                regex = regex + catalogSeparator + namePattern;
            }
            this.mUDTNameMatcherPattern = Pattern.compile(regex);
        }
        return this.mUDTNameMatcherPattern.matcher(name);
    }

    protected UserDefinedType findUserDefinedType(String typeName) {
        Matcher matcher;
        try {
            matcher = this.getUDTNameMatcher(typeName);
        }
        catch (SQLException sQLException) {
            return null;
        }
        if (matcher.matches()) {
            String udtName;
            String schemaName;
            String catalogName;
            if (this.mCatalogAtStart) {
                catalogName = matcher.group(1);
                schemaName = matcher.group(2);
                udtName = matcher.group(3);
            } else {
                schemaName = matcher.group(1);
                udtName = matcher.group(2);
                catalogName = matcher.group(3);
            }
            if (udtName == null) {
                return null;
            }
            if (catalogName == null) {
                catalogName = new String();
            }
            if (schemaName == null) {
                schemaName = new String();
            }
            Database db = this.getCatalogObject().getCatalogDatabase();
            for (Catalog catalog : db.getCatalogs()) {
                if (!catalogName.equals(catalog.getName())) continue;
                for (Schema schema : catalog.getSchemas()) {
                    if (!schemaName.equals(schema.getName())) continue;
                    for (UserDefinedType udt : schema.getUserDefinedTypes()) {
                        if (!udtName.equals(udt.getName())) continue;
                        return udt;
                    }
                }
            }
        }
        return null;
    }

    protected Table findScopedTable(String catalogScope, String schemaScope, String tableScope) {
        Connection sqlConn;
        IImsDbConnection imsConn;
        IConnection connection;
        if (tableScope == null) {
            return null;
        }
        if (catalogScope == null) {
            catalogScope = this.getTable().getSchema().getCatalog().getName();
            boolean supportsCatalogsInTableDefinitions = false;
            try {
                connection = this.getCatalogObject().getConnection();
                if (connection instanceof IImsDbConnection) {
                    imsConn = (IImsDbConnection)connection;
                    sqlConn = imsConn.getSqlConnection();
                    supportsCatalogsInTableDefinitions = sqlConn.getMetaData().supportsCatalogsInTableDefinitions();
                }
                if (supportsCatalogsInTableDefinitions) {
                    catalogScope = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (schemaScope == null) {
            schemaScope = this.getTable().getSchema().getName();
            boolean supportsSchemasInTableDefinitions = false;
            try {
                connection = this.getCatalogObject().getConnection();
                if (connection instanceof IImsDbConnection) {
                    imsConn = (IImsDbConnection)connection;
                    sqlConn = imsConn.getSqlConnection();
                    supportsSchemasInTableDefinitions = sqlConn.getMetaData().supportsSchemasInTableDefinitions();
                }
                if (supportsSchemasInTableDefinitions) {
                    schemaScope = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Database db = this.getCatalogObject().getCatalogDatabase();
        for (Catalog catalog : db.getCatalogs()) {
            if (!catalogScope.equals(catalog.getName())) continue;
            for (Schema schema : catalog.getSchemas()) {
                if (!schemaScope.equals(schema.getName())) continue;
                for (Table table : schema.getTables()) {
                    if (!tableScope.equals(table.getName())) continue;
                    return table;
                }
            }
        }
        return null;
    }
}

