/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.icu.text.MessageFormat;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCParameter;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.Messages;
import com.ibm.ims.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import com.ibm.ims.datatools.modelbase.sql.datatypes.DataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.PredefinedDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.UserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.routines.Parameter;
import com.ibm.ims.datatools.modelbase.sql.routines.ParameterMode;
import com.ibm.ims.datatools.modelbase.sql.routines.Routine;
import com.ibm.ims.datatools.modelbase.sql.routines.RoutineResultTable;
import com.ibm.ims.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.schema.TypedElement;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCRoutineColumnLoader
extends JDBCBaseLoader {
    public static final String COLUMN_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_COLUMN_TYPE = "COLUMN_TYPE";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_PRECISION = "PRECISION";
    public static final String COLUMN_LENGTH = "LENGTH";
    public static final String COLUMN_SCALE = "SCALE";
    public static final String COLUMN_NULLABLE = "NULLABLE";
    public static final String COLUMN_REMARKS = "REMARKS";
    private Pattern mUDTNameMatcherPattern;
    private boolean mCatalogAtStart;

    public JDBCRoutineColumnLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCRoutineColumnLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Routine);
    }

    public void loadParameters(List parameterContainmentList, Collection existingParameters) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createParametersResultSet();
            while (rs.next()) {
                String parameterName;
                if (!this.isParameter(rs) || (parameterName = rs.getString(COLUMN_COLUMN_NAME)) == null || this.isFiltered(parameterName)) continue;
                Parameter parameter = (Parameter)this.getAndRemoveSQLObject(existingParameters, parameterName);
                if (parameter == null) {
                    parameter = this.processParameterColumnRow(rs);
                    if (parameter == null) continue;
                    parameterContainmentList.add(parameter);
                    continue;
                }
                this.initParameter(parameter, rs);
                parameterContainmentList.add(parameter);
                if (!(parameter instanceof ICatalogObject)) continue;
                ((ICatalogObject)parameter).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeParametersResultSet(rs);
            }
        }
    }

    public List loadRoutineResultTables() throws SQLException {
        ResultSet rs = null;
        try {
            ArrayList<RoutineResultTable> retVal = new ArrayList<RoutineResultTable>();
            this.initActiveFilter();
            rs = this.createRoutineResultTableResultSet();
            while (rs.next()) {
                Column column;
                RoutineResultTable rst;
                if (this.isParameter(rs)) continue;
                int resultTableIndex = this.getRoutineResultTableIndex(rs);
                if (resultTableIndex >= retVal.size()) {
                    while (retVal.size() <= resultTableIndex) {
                        retVal.add(null);
                    }
                }
                if ((rst = (RoutineResultTable)retVal.get(resultTableIndex)) == null) {
                    rst = this.createRoutineResultTable();
                    this.initRoutineResultTable(rst, rs);
                    retVal.set(resultTableIndex, rst);
                }
                if ((column = this.processRoutineResultTableColumnRow(rs)) == null) continue;
                rst.getColumns().add((Object)column);
            }
            ArrayList<RoutineResultTable> arrayList = retVal;
            if (rs != null) {
                this.closeRoutineResultTableResultSet(rs);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeRoutineResultTableResultSet(rs);
            }
            throw throwable;
        }
    }

    public void clearColumns(List columns) {
        columns.clear();
    }

    protected ResultSet createParametersResultSet() throws SQLException {
        ResultSet retVal = null;
        try {
            Routine routine = this.getRoutine();
            Schema schema = routine.getSchema();
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                retVal = sqlConn.getMetaData().getProcedureColumns(schema.getCatalog().getName(), schema.getName(), routine.getName(), null);
            }
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getProcedureColumns()"}));
            error.initCause(e);
            throw error;
        }
        return retVal;
    }

    protected ResultSet createRoutineResultTableResultSet() throws SQLException {
        return this.createParametersResultSet();
    }

    protected void closeParametersResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected void closeRoutineResultTableResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Parameter processParameterColumnRow(ResultSet rs) throws SQLException {
        Parameter retVal = this.createParameter();
        this.initParameter(retVal, rs);
        return retVal;
    }

    protected Column processRoutineResultTableColumnRow(ResultSet rs) throws SQLException {
        Column retVal = this.createColumn();
        this.initColumn(retVal, rs);
        return retVal;
    }

    protected boolean isParameter(ResultSet rs) throws SQLException {
        return rs.getShort(COLUMN_COLUMN_TYPE) != 3;
    }

    protected Parameter createParameter() {
        return new JDBCParameter();
    }

    protected Column createColumn() {
        return new JDBCColumn();
    }

    protected RoutineResultTable createRoutineResultTable() {
        return SQLRoutinesFactory.eINSTANCE.createRoutineResultTable();
    }

    protected int getRoutineResultTableIndex(ResultSet rs) {
        return 0;
    }

    protected void initParameter(Parameter parameter, ResultSet rs) throws SQLException {
        parameter.setName(rs.getString(COLUMN_COLUMN_NAME));
        parameter.setDescription(rs.getString(COLUMN_REMARKS));
        switch (rs.getShort(COLUMN_COLUMN_TYPE)) {
            case 1: {
                parameter.setMode(ParameterMode.IN_LITERAL);
                break;
            }
            case 2: {
                parameter.setMode(ParameterMode.INOUT_LITERAL);
                break;
            }
            case 4: {
                parameter.setMode(ParameterMode.OUT_LITERAL);
                break;
            }
            case 5: {
                parameter.setMode(ParameterMode.OUT_LITERAL);
                break;
            }
            default: {
                parameter.setMode(ParameterMode.IN_LITERAL);
            }
        }
        this.initType((TypedElement)parameter, rs);
    }

    protected void initColumn(Column column, ResultSet rs) throws SQLException {
        column.setName(rs.getString(COLUMN_COLUMN_NAME));
        column.setDescription(rs.getString(COLUMN_REMARKS));
        this.initType((TypedElement)column, rs);
        column.setNullable(rs.getInt(COLUMN_NULLABLE) == 1);
    }

    protected void initRoutineResultTable(RoutineResultTable resultTable, ResultSet rs) {
    }

    protected void initType(TypedElement element, ResultSet rs) throws SQLException {
        String typeName = rs.getString(COLUMN_TYPE_NAME).toUpperCase();
        int typeCode = rs.getInt(COLUMN_DATA_TYPE);
        List pdtds = this.getDatabaseDefinition().getPredefinedDataTypeDefinitionsByJDBCEnumType(typeCode);
        if (pdtds.size() > 0) {
            PredefinedDataTypeDefinition pdtd = null;
            Iterator it = pdtds.iterator();
            block0: while (pdtd == null && it.hasNext()) {
                PredefinedDataTypeDefinition curPDTD = (PredefinedDataTypeDefinition)it.next();
                for (String name : curPDTD.getName()) {
                    if (!typeName.equals(name)) continue;
                    pdtd = curPDTD;
                    continue block0;
                }
            }
            if (pdtd == null) {
                pdtd = this.getDatabaseDefinition().getPredefinedDataTypeDefinition(typeName);
            }
            if (pdtd != null || pdtd == null && typeCode != 1111 && typeCode != 2006) {
                EStructuralFeature feature;
                if (pdtd == null) {
                    pdtd = (PredefinedDataTypeDefinition)pdtds.get(0);
                }
                PredefinedDataType pdt = this.getDatabaseDefinition().getPredefinedDataType(pdtd);
                if (pdtd.isLengthSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("length");
                    pdt.eSet(feature, (Object)rs.getInt(COLUMN_LENGTH));
                }
                if (pdtd.isPrecisionSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("precision");
                    pdt.eSet(feature, (Object)rs.getInt(COLUMN_PRECISION));
                }
                if (pdtd.isScaleSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("scale");
                    pdt.eSet(feature, (Object)rs.getInt(COLUMN_SCALE));
                }
                element.setDataType((DataType)pdt);
                return;
            }
        }
        if (typeName == null) {
            element.setDataType(null);
            return;
        }
        UserDefinedType udt = this.findUserDefinedType(typeName);
        element.setDataType((DataType)udt);
    }

    protected Routine getRoutine() {
        return (Routine)this.getCatalogObject();
    }

    protected DatabaseDefinition getDatabaseDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogObject().getCatalogDatabase());
    }

    protected Matcher getUDTNameMatcher(String name) throws SQLException {
        if (this.mUDTNameMatcherPattern == null) {
            DatabaseMetaData dbmd = null;
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                dbmd = sqlConn.getMetaData();
            }
            String namePattern = "([a-zA-Z0-9_" + dbmd.getExtraNameCharacters() + "]*)";
            String catalogSeparator = dbmd.getCatalogSeparator();
            String regex = namePattern + "." + namePattern;
            if (name.indexOf(catalogSeparator) < 0) {
                regex = regex + "()";
            } else if (dbmd.isCatalogAtStart()) {
                this.mCatalogAtStart = true;
                regex = namePattern + catalogSeparator + regex;
            } else {
                regex = regex + catalogSeparator + namePattern;
            }
            this.mUDTNameMatcherPattern = Pattern.compile(regex);
        }
        return this.mUDTNameMatcherPattern.matcher(name);
    }

    protected UserDefinedType findUserDefinedType(String typeName) {
        Matcher matcher;
        try {
            matcher = this.getUDTNameMatcher(typeName);
        }
        catch (SQLException sQLException) {
            return null;
        }
        if (matcher.matches()) {
            String udtName;
            String schemaName;
            String catalogName;
            if (this.mCatalogAtStart) {
                catalogName = matcher.group(1);
                schemaName = matcher.group(2);
                udtName = matcher.group(3);
            } else {
                schemaName = matcher.group(1);
                udtName = matcher.group(2);
                catalogName = matcher.group(3);
            }
            if (udtName == null) {
                return null;
            }
            if (catalogName == null) {
                catalogName = new String();
            }
            if (schemaName == null) {
                schemaName = new String();
            }
            Database db = this.getCatalogObject().getCatalogDatabase();
            for (Catalog catalog : db.getCatalogs()) {
                if (!catalogName.equals(catalog.getName())) continue;
                for (Schema schema : catalog.getSchemas()) {
                    if (!schemaName.equals(schema.getName())) continue;
                    for (UserDefinedType udt : schema.getUserDefinedTypes()) {
                        if (!udtName.equals(udt.getName())) continue;
                        return udt;
                    }
                }
            }
        }
        return null;
    }
}

