/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCRoutineColumnLoader;
import com.ibm.ims.datatools.modelbase.sql.routines.Parameter;
import com.ibm.ims.datatools.modelbase.sql.routines.ParameterMode;
import com.ibm.ims.datatools.modelbase.sql.routines.Procedure;
import com.ibm.ims.datatools.modelbase.sql.schema.TypedElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JDBCProcedureColumnLoader
extends JDBCRoutineColumnLoader {
    public JDBCProcedureColumnLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCProcedureColumnLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Procedure);
    }

    public List loadColumns() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadParameters(retVal, Collections.EMPTY_SET);
        List routineResultTables = this.loadRoutineResultTables();
        if (routineResultTables.size() > 0) {
            retVal.add(routineResultTables.get(0));
        }
        return retVal;
    }

    @Override
    protected void initParameter(Parameter parameter, ResultSet rs) throws SQLException {
        parameter.setName(rs.getString("COLUMN_NAME"));
        parameter.setDescription(rs.getString("REMARKS"));
        switch (rs.getShort("COLUMN_TYPE")) {
            case 1: {
                parameter.setMode(ParameterMode.IN_LITERAL);
                break;
            }
            case 2: {
                parameter.setMode(ParameterMode.INOUT_LITERAL);
                break;
            }
            case 4: {
                parameter.setMode(ParameterMode.OUT_LITERAL);
                break;
            }
            default: {
                parameter.setMode(ParameterMode.IN_LITERAL);
            }
        }
        this.initType((TypedElement)parameter, rs);
    }
}

