/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.icu.text.MessageFormat;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCCatalog;
import com.ibm.ims.datatools.connectivity.sqm.loader.CatalogFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.Messages;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JDBCCatalogLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TABLE_CAT = "TABLE_CAT";

    public JDBCCatalogLoader(ICatalogObject catalogObject) {
        this(catalogObject, new CatalogFilterProvider());
    }

    public JDBCCatalogLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Database);
    }

    public Collection loadCatalogs() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadCatalogs(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadCatalogs(List containmentList, Collection existingCatalogs) throws SQLException {
        ResultSet rs = null;
        try {
            boolean catalogsFiltered = false;
            rs = this.createResultSet();
            while (rs.next()) {
                String catalogName = rs.getString(COLUMN_TABLE_CAT);
                if (catalogName == null || this.isFiltered(catalogName)) {
                    catalogsFiltered = true;
                    continue;
                }
                Catalog catalog = (Catalog)this.getAndRemoveSQLObject(existingCatalogs, catalogName);
                if (catalog == null) {
                    catalog = this.processRow(rs);
                    if (catalog == null) continue;
                    containmentList.add(catalog);
                    continue;
                }
                containmentList.add(catalog);
                if (!(catalog instanceof ICatalogObject)) continue;
                ((ICatalogObject)catalog).refresh();
            }
            if (containmentList.size() == 0 && !catalogsFiltered) {
                Catalog catalog = (Catalog)this.getAndRemoveSQLObject(existingCatalogs, new String());
                if (catalog == null) {
                    catalog = this.createCatalog();
                    catalog.setName(new String());
                } else if (catalog instanceof ICatalogObject) {
                    ((ICatalogObject)catalog).refresh();
                }
                containmentList.add(catalog);
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearCatalogs(Collection catalogs) {
        catalogs.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        ResultSet retVal = null;
        try {
            IConnection connection = this.getCatalogObject().getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                Connection sqlConn = imsConn.getSqlConnection();
                retVal = sqlConn.getMetaData().getCatalogs();
            }
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getCatalog()"}));
            error.initCause(e);
            throw error;
        }
        return retVal;
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Catalog processRow(ResultSet rs) throws SQLException {
        Catalog catalog = this.createCatalog();
        this.initialize(catalog, rs);
        return catalog;
    }

    protected Catalog createCatalog() {
        return new JDBCCatalog();
    }

    protected void initialize(Catalog catalog, ResultSet rs) throws SQLException {
        catalog.setName(rs.getString(COLUMN_TABLE_CAT));
    }

    protected Database getDatabase() {
        return (Database)this.getCatalogObject();
    }
}

