/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.loader;

import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import com.ibm.ims.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import java.util.Collection;
import java.util.Iterator;

public class JDBCBaseLoader {
    private ICatalogObject mCatalogObject;
    private IConnectionFilterProvider mConnectionFilterProvider;
    private ConnectionFilter mActiveFilter;

    public JDBCBaseLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this.mCatalogObject = catalogObject;
        this.mConnectionFilterProvider = connectionFilterProvider;
    }

    public ICatalogObject getCatalogObject() {
        return this.mCatalogObject;
    }

    public void setCatalogObject(ICatalogObject catalogObject) {
        this.mCatalogObject = catalogObject;
    }

    protected void initActiveFilter() {
        this.mActiveFilter = null;
        if (this.mConnectionFilterProvider != null) {
            this.mActiveFilter = this.mConnectionFilterProvider.getConnectionFilter(this.mCatalogObject);
        }
    }

    protected String getJDBCFilterPattern() {
        if (this.mActiveFilter != null && "LIKE".equals(this.mActiveFilter.getOperator())) {
            String pattern = this.mActiveFilter.getPattern();
            if (pattern.startsWith("'") && pattern.endsWith("'")) {
                pattern = pattern.substring(1, pattern.length() - 1);
            }
            return pattern;
        }
        return null;
    }

    protected String getSQLFilterExpression() {
        if (this.mActiveFilter == null) {
            return null;
        }
        return this.mActiveFilter.getPredicate();
    }

    protected boolean isFiltered(String name) {
        if (this.mActiveFilter == null) {
            return false;
        }
        return this.mActiveFilter.isFiltered(name);
    }

    protected SQLObject getAndRemoveSQLObject(Collection sqlObjs, String objName) {
        Iterator it = sqlObjs.iterator();
        while (it.hasNext()) {
            SQLObject obj = (SQLObject)it.next();
            if (!obj.getName().equals(objName)) continue;
            it.remove();
            return obj;
        }
        return null;
    }
}

