/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.internal.core.util;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import com.ibm.ims.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import com.ibm.ims.datatools.connectivity.sqm.core.containment.ContainmentService;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;

public class ConnectionUtil {
    public static final String CONNECTION_TYPE = "com.ibm.ims.datatools.connectivity.sqm.core.connection.ConnectionInfo";
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final String CONNECTION_URI = "ConnectionURI";
    private static final String CONNECTION_URI_KEY = "ConnectionKey";

    private static String getConnectionEAnnotationUri() {
        return CONNECTION_URI;
    }

    private static String getConnectionEAnnotationKey() {
        return CONNECTION_URI_KEY;
    }

    public static ConnectionInfo getConnectionForEObject(EObject sqlObject) {
        while (sqlObject != null && !SQLSchemaPackage.eINSTANCE.getDatabase().isSuperTypeOf(sqlObject.eClass())) {
            sqlObject = containmentService.getContainer(sqlObject);
        }
        return sqlObject != null ? DatabaseConnectionRegistry.getConnectionForDatabase((Database)sqlObject) : null;
    }

    public static void setConnectionProfile(SQLObject obj, String infoName) {
        if (infoName == null) {
            throw new NullPointerException();
        }
        EAnnotation annotation = obj.getEAnnotation(ConnectionUtil.getConnectionEAnnotationUri());
        if (annotation == null) {
            annotation = obj.addEAnnotation(ConnectionUtil.getConnectionEAnnotationUri());
        }
        obj.addEAnnotationDetail(annotation, ConnectionUtil.getConnectionEAnnotationKey(), infoName);
    }

    public static void setConnectionProfile(SQLObject obj, IConnectionProfile info) {
        ConnectionUtil.setConnectionProfile(obj, info.getName());
    }

    public static String getConnectionProfileName(SQLObject obj) {
        EAnnotation annotation = obj.getEAnnotation(ConnectionUtil.getConnectionEAnnotationUri());
        if (annotation == null) {
            return null;
        }
        return obj.getEAnnotationDetail(annotation, ConnectionUtil.getConnectionEAnnotationKey());
    }
}

