/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.internal.core.util;

import com.ibm.ims.datatools.connectivity.sqm.core.containment.ContainmentService;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CatalogUtil {
    private static CatalogTaskLabelProvider sDefaultCatalogTaskLabelProvider = new CatalogTaskLabelProvider();

    public static void setDefaultCatalogTaskLabelProvider(CatalogTaskLabelProvider provider) {
        sDefaultCatalogTaskLabelProvider = provider == null ? new CatalogTaskLabelProvider() : provider;
    }

    public void load(EObject obj, IProgressMonitor monitor, int task) {
        this.loadInternal(obj, monitor, task, true);
        for (EStructuralFeature feature : obj.eClass().getEAllStructuralFeatures()) {
            if (feature.isDerived() || feature.isTransient()) continue;
            obj.eGet(feature);
        }
    }

    public void loadWithoutAttributes(EObject obj, IProgressMonitor monitor, int task) {
        this.loadInternal(obj, monitor, task, false);
        for (EStructuralFeature feature : obj.eClass().getEAllReferences()) {
            if (feature.isDerived() || feature.isTransient()) continue;
            obj.eGet(feature);
        }
    }

    private double loadInternal(EObject object, IProgressMonitor monitor, double task, boolean includingAttributes) {
        ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
        Collection c = containmentService.getContainedElements(object);
        double acc = 0.0;
        if (c.size() != 0) {
            double delta = task / (double)c.size();
            for (EObject child : c) {
                String taskLabel;
                if (containmentService.isDisplayableElement(child) && child instanceof ENamedElement && (taskLabel = sDefaultCatalogTaskLabelProvider.getLabel((ENamedElement)child)) != null) {
                    monitor.subTask(taskLabel);
                }
                acc += this.loadInternal(child, monitor, delta, includingAttributes);
                if (monitor.isCanceled()) {
                    return 0.0;
                }
                if (!(acc >= 1.0)) continue;
                monitor.worked((int)acc);
                acc -= (double)((int)acc);
            }
        } else {
            acc = task;
        }
        if (includingAttributes) {
            for (EStructuralFeature feature : object.eClass().getEAllStructuralFeatures()) {
                if (feature.isDerived() || feature.isTransient()) continue;
                object.eGet(feature);
            }
        } else {
            for (EStructuralFeature feature : object.eClass().getEAllReferences()) {
                if (feature.isDerived() || feature.isTransient()) continue;
                object.eGet(feature);
            }
        }
        return acc;
    }

    public static class CatalogTaskLabelProvider {
        public String getLabel(ENamedElement element) {
            return element.getName();
        }
    }
}

