/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.internal.core.connection;

import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionFilterImpl
implements ConnectionFilter {
    private static final long serialVersionUID = 3689626986939299641L;
    private String predicate;
    private IFilter filter;
    private static final String NOT_PREDICATE_TEXT = "NOT";
    private static final String IDENTIFIER_DELIMITER = "'";
    public static final int STARTS_WITH_OPERATOR = 1;
    public static final int CONTAINS_OPERATOR = 2;
    public static final int ENDS_WITH_OPERATOR = 3;
    public static final int NOT_START_WITH_OPERATOR = 4;
    public static final int NOT_CONTAIN_OPERATOR = 5;
    public static final int NOT_END_WITH_OPERATOR = 6;
    private ArrayList predicates = new ArrayList();

    public ConnectionFilterImpl() {
    }

    public ConnectionFilterImpl(String predicate) {
        this.setPredicate(predicate);
    }

    @Override
    public void setPredicate(String predicate) {
        this.filter = null;
        this.predicate = predicate;
    }

    @Override
    public String getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean isValid(String predicate) {
        return predicate != null && predicate.length() > 0;
    }

    @Override
    public String getPattern() {
        String pattern = "";
        if (this.predicate != null) {
            try {
                pattern = this.predicate.indexOf("(") < 0 ? this.predicate.substring(this.predicate.indexOf(IDENTIFIER_DELIMITER), this.predicate.length()) : this.predicate.substring(this.predicate.indexOf("("), this.predicate.length());
            }
            catch (Exception exception) {}
        }
        return pattern;
    }

    @Override
    public String getOperator() {
        String operator = "";
        if (this.predicate != null) {
            try {
                operator = this.predicate.indexOf("(") < 0 ? this.predicate.substring(0, this.predicate.indexOf(IDENTIFIER_DELIMITER)).trim() : this.predicate.substring(0, this.predicate.indexOf("(")).trim();
            }
            catch (Exception exception) {}
        }
        return operator;
    }

    @Override
    public String[] getPatternElements() {
        Object[] elements = new String[]{};
        Vector<String> patternVector = new Vector<String>();
        String pattern = this.getPattern();
        String[] patterns = pattern.split(IDENTIFIER_DELIMITER);
        int i = 0;
        while (i < patterns.length) {
            if (!(patterns[i].equals(", ") || patterns[i].equals("(") || patterns[i].equals(")"))) {
                patternVector.add(patterns[i]);
            }
            ++i;
        }
        elements = new String[patternVector.size()];
        patternVector.copyInto(elements);
        return elements;
    }

    @Override
    public boolean isOperatorInclusive() {
        boolean isInclusive = false;
        if (this.getOperator().equals("IN")) {
            isInclusive = true;
        }
        return isInclusive;
    }

    @Override
    public boolean isOperatorExclusive() {
        boolean isExclusive = false;
        if (this.getOperator().equals("NOT IN")) {
            isExclusive = true;
        }
        return isExclusive;
    }

    @Override
    public boolean isFiltered(String name) {
        if (this.filter == null) {
            this.createFilter();
        }
        return this.filter.isFiltered(name);
    }

    private void createFilter() {
        String operator = this.getOperator();
        if ("LIKE".equals(operator)) {
            this.filter = new LikeFilter(this.getPattern());
        } else if ("NOT LIKE".equals(operator)) {
            this.filter = new NotLikeFilter(this.getPattern());
        } else if ("IN".equals(operator)) {
            this.filter = new InFilter(this.getPattern());
        } else if ("NOT IN".equals(operator)) {
            this.filter = new NotInFilter(this.getPattern());
        }
    }

    @Override
    public ArrayList getPredicatesCollection() {
        this.predicates = new ArrayList();
        if (this.predicate != null && !this.predicate.equals("")) {
            String[] tokenArray = this.predicate.split(IDENTIFIER_DELIMITER);
            int i = 0;
            while (i < tokenArray.length) {
                tokenArray[i] = tokenArray[i].trim();
                ++i;
            }
            ArrayList<String> tempList = new ArrayList<String>();
            int i2 = 0;
            while (i2 + 1 < tokenArray.length) {
                tokenArray[i2 + 1] = IDENTIFIER_DELIMITER + tokenArray[i2 + 1] + IDENTIFIER_DELIMITER;
                if (tokenArray[i2].startsWith("AND")) {
                    tokenArray[i2] = tokenArray[i2].substring(4, tokenArray[i2].length());
                } else if (tokenArray[i2].startsWith("OR")) {
                    tokenArray[i2] = tokenArray[i2].substring(3, tokenArray[i2].length());
                }
                tempList.add(tokenArray[i2]);
                tempList.add(tokenArray[i2 + 1]);
                i2 += 2;
            }
            int operator = -1;
            String value = "";
            Object tempValue = "";
            int j = 0;
            while (j + 1 < tempList.size()) {
                if (tempList.size() == 2) {
                    operator = this.findExpressionOperator(tempList.get(j).toString() + " " + tempList.get(j + 1).toString());
                } else {
                    tempValue = tempList.get(j).toString() + " " + tempList.get(j + 1).toString();
                    tempValue = ((String)tempValue).substring(4, ((String)tempValue).length());
                    operator = this.findExpressionOperator((String)tempValue);
                }
                value = this.findExpressionValue(tempList.get(j).toString() + " " + tempList.get(j + 1).toString());
                Predicate p = new Predicate(operator, value);
                this.predicates.add(p);
                j += 2;
            }
        }
        return this.predicates;
    }

    private int findExpressionOperator(String filterPredicate) {
        String expressionValue;
        int enumExpressionPredicate = 1;
        boolean isNotLike = false;
        boolean startsWithPercentSign = false;
        boolean endsWithPercentSign = false;
        if (filterPredicate.startsWith(NOT_PREDICATE_TEXT)) {
            isNotLike = true;
        }
        if ((expressionValue = filterPredicate.split(IDENTIFIER_DELIMITER)[1]).startsWith("%")) {
            startsWithPercentSign = true;
        }
        if (expressionValue.endsWith("%")) {
            endsWithPercentSign = true;
        }
        if (startsWithPercentSign && endsWithPercentSign) {
            enumExpressionPredicate = isNotLike ? 5 : 2;
        } else if (startsWithPercentSign) {
            enumExpressionPredicate = isNotLike ? 6 : 3;
        } else if (endsWithPercentSign) {
            enumExpressionPredicate = isNotLike ? 4 : 1;
        }
        return enumExpressionPredicate;
    }

    private String findExpressionValue(String filterPredicate) {
        String expressionValue = filterPredicate.split(IDENTIFIER_DELIMITER)[1];
        if (expressionValue.startsWith("%")) {
            expressionValue = expressionValue.substring(1);
        }
        if (expressionValue.endsWith("%")) {
            expressionValue = expressionValue.substring(0, expressionValue.length() - 1);
        }
        return expressionValue;
    }

    @Override
    public boolean isMeetsAllConditions() {
        this.predicates = new ArrayList();
        if (this.predicate != null && !this.predicate.equals("")) {
            String[] tokenArray = this.predicate.split(" ");
            int i = 0;
            while (i < tokenArray.length) {
                if (tokenArray[i].equals("AND")) {
                    return true;
                }
                if (tokenArray[i].equals("OR")) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static interface IFilter {
        public boolean isFiltered(String var1);
    }

    private static class InFilter
    extends NotInFilter {
        InFilter(String pattern) {
            super(pattern);
        }

        @Override
        public boolean isFiltered(String name) {
            return !super.isFiltered(name);
        }
    }

    private static class LikeFilter
    extends NotLikeFilter {
        LikeFilter(String pattern) {
            super(pattern);
        }

        @Override
        public boolean isFiltered(String name) {
            return !super.isFiltered(name);
        }
    }

    private static class NotInFilter
    implements IFilter {
        static Pattern regex = Pattern.compile("'(.*?)'");
        Set values;

        NotInFilter(String pattern) {
            if (pattern == null || pattern.length() < 2) {
                this.values = Collections.EMPTY_SET;
            } else {
                this.values = new TreeSet();
                Matcher m = regex.matcher(pattern);
                while (m.find()) {
                    this.values.add(m.group(1));
                }
            }
        }

        @Override
        public boolean isFiltered(String name) {
            return this.values.contains(name);
        }
    }

    private static class NotLikeFilter
    implements IFilter {
        Pattern pattern;

        NotLikeFilter(String pattern) {
            String regex = pattern == null || pattern.length() < 2 ? new String() : this.quote(pattern.substring(1, pattern.length() - 1));
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean isFiltered(String name) {
            return this.pattern.matcher(name).matches();
        }

        private String quote(String pattern) {
            StringBuffer buf = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(pattern, "%_", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("%".equals(token)) {
                    buf.append(".*");
                    continue;
                }
                if ("_".equals(token)) {
                    buf.append(".?");
                    continue;
                }
                buf.append(token.replaceAll("\\p{Punct}", "\\\\$0"));
            }
            return buf.toString();
        }
    }
}

