/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.RefreshManager;
import com.ibm.ims.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCUDFColumnLoader;
import com.ibm.ims.datatools.modelbase.sql.routines.Parameter;
import com.ibm.ims.datatools.modelbase.sql.routines.ParameterMode;
import com.ibm.ims.datatools.modelbase.sql.routines.RoutineResultTable;
import com.ibm.ims.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import com.ibm.ims.datatools.modelbase.sql.routines.impl.UserDefinedFunctionImpl;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCUserDefinedFunction
extends UserDefinedFunctionImpl
implements ICatalogObject {
    private static final long serialVersionUID = -6800525292996291562L;
    private Boolean parametersLoaded = Boolean.FALSE;
    private Boolean resultTableLoaded = Boolean.FALSE;
    private SoftReference paremeterLoaderRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (this.parametersLoaded.booleanValue()) {
                this.setReturnScalar(null);
                this.parametersLoaded = Boolean.FALSE;
            }
        }
        bl = this.resultTableLoaded;
        synchronized (bl) {
            if (this.resultTableLoaded.booleanValue()) {
                this.setReturnTable(null);
                this.resultTableLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    @Override
    public IConnection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    @Override
    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getParameters() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (!this.parametersLoaded.booleanValue()) {
                this.loadParameters();
            }
        }
        return super.getParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getReturnScalar() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (!this.parametersLoaded.booleanValue()) {
                this.loadParameters();
            }
        }
        return super.getReturnScalar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutineResultTable getReturnTable() {
        Boolean bl = this.resultTableLoaded;
        synchronized (bl) {
            if (!this.resultTableLoaded.booleanValue()) {
                this.loadResultTable();
            }
        }
        return super.getReturnTable();
    }

    protected JDBCUDFColumnLoader createParameterLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLRoutinesFactory.eINSTANCE.createParameter().eClass().getInstanceClassName());
        if (loader != null) {
            JDBCUDFColumnLoader udfColumnLoader = (JDBCUDFColumnLoader)loader;
            udfColumnLoader.setCatalogObject(this);
            return udfColumnLoader;
        }
        return new JDBCUDFColumnLoader(this);
    }

    protected final JDBCUDFColumnLoader getParameterLoader() {
        if (this.paremeterLoaderRef == null || this.paremeterLoaderRef.get() == null) {
            this.paremeterLoaderRef = new SoftReference<JDBCUDFColumnLoader>(this.createParameterLoader());
        }
        return (JDBCUDFColumnLoader)this.paremeterLoaderRef.get();
    }

    private void loadParameters() {
        this.parametersLoaded = Boolean.TRUE;
        boolean deliver = this.eDeliver();
        try {
            try {
                EList parametersContainer = super.getParameters();
                ArrayList existingParameters = new ArrayList(parametersContainer);
                this.eSetDeliver(false);
                parametersContainer.clear();
                this.setReturnScalar(null);
                this.getParameterLoader().loadParameters((List)parametersContainer, existingParameters);
                this.getParameterLoader().clearColumns(existingParameters);
                ArrayList<Parameter> removeList = new ArrayList<Parameter>();
                for (Parameter p : parametersContainer) {
                    if (p.getMode() != ParameterMode.OUT_LITERAL) continue;
                    this.setReturnScalar(p);
                    removeList.add(p);
                    break;
                }
                for (Parameter removedObject : removeList) {
                    parametersContainer.remove(removedObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    private void loadResultTable() {
        this.resultTableLoaded = Boolean.TRUE;
        boolean deliver = this.eDeliver();
        try {
            try {
                this.eSetDeliver(false);
                List returnTableList = this.getParameterLoader().loadRoutineResultTables();
                if (returnTableList.size() > 0) {
                    this.setReturnTable((RoutineResultTable)returnTableList.get(0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 18: {
                this.getParameters();
                break;
            }
            case 26: {
                this.getReturnTable();
                break;
            }
            case 27: {
                this.getReturnScalar();
            }
        }
        return super.eIsSet(eFeature);
    }
}

