/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.RefreshManager;
import com.ibm.ims.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCUDTAttributeLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCUDTSuperTypeLoader;
import com.ibm.ims.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;
import com.ibm.ims.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.UserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.impl.StructuredUserDefinedTypeImpl;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCStructuredUDT
extends StructuredUserDefinedTypeImpl
implements ICatalogObject {
    private static final long serialVersionUID = -8270619856243796282L;
    private Boolean attributesLoaded = Boolean.FALSE;
    private SoftReference paremeterLoaderRef;
    private Boolean superLoaded = Boolean.FALSE;
    private SoftReference superLoaderRef;

    @Override
    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    @Override
    public IConnection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Boolean bl = this.attributesLoaded;
        synchronized (bl) {
            if (this.attributesLoaded.booleanValue()) {
                this.attributesLoaded = Boolean.FALSE;
                this.getParameterLoader().clearAttributeDefinitions((List)super.getAttributes());
            }
        }
        bl = this.superLoaded;
        synchronized (bl) {
            if (this.superLoaded.booleanValue()) {
                this.superLoaded = Boolean.FALSE;
                this.setSuper(null);
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getAttributes() {
        Boolean bl = this.attributesLoaded;
        synchronized (bl) {
            if (!this.attributesLoaded.booleanValue()) {
                this.loadAttributes();
            }
        }
        return super.getAttributes();
    }

    protected JDBCUDTAttributeLoader createParameterLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLDataTypesFactory.eINSTANCE.getSQLDataTypesPackage().getAttributeDefinition().getInstanceClassName());
        if (loader != null) {
            JDBCUDTAttributeLoader parameterLoader = (JDBCUDTAttributeLoader)loader;
            parameterLoader.setCatalogObject(this);
            return parameterLoader;
        }
        return new JDBCUDTAttributeLoader(this);
    }

    protected final JDBCUDTAttributeLoader getParameterLoader() {
        if (this.paremeterLoaderRef == null || this.paremeterLoaderRef.get() == null) {
            this.paremeterLoaderRef = new SoftReference<JDBCUDTAttributeLoader>(this.createParameterLoader());
        }
        return (JDBCUDTAttributeLoader)this.paremeterLoaderRef.get();
    }

    private void loadAttributes() {
        try {
            super.getAttributes().addAll((Collection)this.getParameterLoader().loadAttributeDefinitions());
            this.attributesLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructuredUserDefinedType getSuper() {
        Boolean bl = this.superLoaded;
        synchronized (bl) {
            if (!this.superLoaded.booleanValue()) {
                this.loadSuper();
            }
        }
        return super.getSuper();
    }

    protected JDBCUDTSuperTypeLoader createSuperLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLDataTypesFactory.eINSTANCE.getSQLDataTypesPackage().getUserDefinedType().getInstanceClassName());
        if (loader != null) {
            JDBCUDTSuperTypeLoader superTypeLoader = (JDBCUDTSuperTypeLoader)loader;
            superTypeLoader.setCatalogObject(this);
            return superTypeLoader;
        }
        return new JDBCUDTSuperTypeLoader(this);
    }

    protected final JDBCUDTSuperTypeLoader getSuperLoader() {
        if (this.superLoaderRef == null || this.superLoaderRef.get() == null) {
            this.superLoaderRef = new SoftReference<JDBCUDTSuperTypeLoader>(this.createSuperLoader());
        }
        return (JDBCUDTSuperTypeLoader)this.superLoaderRef.get();
    }

    private void loadSuper() {
        try {
            UserDefinedType udt = this.getSuperLoader().loadSuperType();
            if (udt instanceof StructuredUserDefinedType) {
                this.setSuper((StructuredUserDefinedType)udt);
            }
            this.superLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 14: {
                this.getAttributes();
                break;
            }
            case 12: {
                this.getSuper();
            }
        }
        return super.eIsSet(eFeature);
    }
}

