/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.RefreshManager;
import com.ibm.ims.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCProcedureColumnLoader;
import com.ibm.ims.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import com.ibm.ims.datatools.modelbase.sql.routines.impl.ProcedureImpl;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCProcedure
extends ProcedureImpl
implements ICatalogObject {
    private static final long serialVersionUID = -734520220022088696L;
    private Boolean parametersLoaded = Boolean.FALSE;
    private Boolean resultTablesLoaded = Boolean.FALSE;
    private SoftReference paremeterLoaderRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (this.parametersLoaded.booleanValue()) {
                this.parametersLoaded = Boolean.FALSE;
            }
        }
        bl = this.resultTablesLoaded;
        synchronized (bl) {
            if (this.resultTablesLoaded.booleanValue()) {
                this.resultTablesLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    @Override
    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    @Override
    public IConnection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getParameters() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (!this.parametersLoaded.booleanValue()) {
                this.loadParameters();
            }
        }
        return super.getParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getResultSet() {
        Boolean bl = this.resultTablesLoaded;
        synchronized (bl) {
            if (!this.resultTablesLoaded.booleanValue()) {
                this.loadRoutineResultTables();
            }
        }
        return super.getResultSet();
    }

    protected JDBCProcedureColumnLoader createParameterLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLRoutinesFactory.eINSTANCE.createParameter().eClass().getInstanceClassName());
        if (loader != null) {
            JDBCProcedureColumnLoader procedureColumnLoader = (JDBCProcedureColumnLoader)loader;
            procedureColumnLoader.setCatalogObject(this);
            return procedureColumnLoader;
        }
        return new JDBCProcedureColumnLoader(this);
    }

    protected final JDBCProcedureColumnLoader getParameterLoader() {
        if (this.paremeterLoaderRef == null || this.paremeterLoaderRef.get() == null) {
            this.paremeterLoaderRef = new SoftReference<JDBCProcedureColumnLoader>(this.createParameterLoader());
        }
        return (JDBCProcedureColumnLoader)this.paremeterLoaderRef.get();
    }

    private void loadParameters() {
        this.parametersLoaded = Boolean.TRUE;
        boolean deliver = this.eDeliver();
        try {
            try {
                EList parametersContainer = super.getParameters();
                ArrayList existingParameters = new ArrayList(parametersContainer);
                this.eSetDeliver(false);
                parametersContainer.clear();
                this.getParameterLoader().loadParameters((List)parametersContainer, existingParameters);
                this.getParameterLoader().clearColumns(existingParameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    private void loadRoutineResultTables() {
        this.resultTablesLoaded = Boolean.TRUE;
        boolean deliver = this.eDeliver();
        try {
            try {
                EList resultTablesContainer = super.getResultSet();
                this.eSetDeliver(false);
                resultTablesContainer.clear();
                resultTablesContainer.addAll(this.getParameterLoader().loadRoutineResultTables());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 18: {
                this.getParameters();
                break;
            }
            case 21: {
                this.getMaxResultSets();
            }
        }
        return super.eIsSet(eFeature);
    }
}

