/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.RefreshManager;
import com.ibm.ims.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCCatalogLoader;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLSchemaPackage;
import com.ibm.ims.datatools.modelbase.sql.schema.impl.DatabaseImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCDatabase
extends DatabaseImpl
implements ICatalogObject {
    private static final long serialVersionUID = 7464150486346999662L;
    private IConnection connection;
    private Boolean catalogsLoaded = Boolean.FALSE;
    private transient ConnectionFilterListener filterListener;
    private SoftReference catalogLoaderRef;

    public JDBCDatabase(IConnection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (this.catalogsLoaded.booleanValue()) {
                this.catalogsLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getCatalogs() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (!this.catalogsLoaded.booleanValue()) {
                this.loadCatalogs();
            }
        }
        return super.getCatalogs();
    }

    protected JDBCCatalogLoader createLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLSchemaPackage.eINSTANCE.getCatalog().getInstanceClassName());
        if (loader != null) {
            JDBCCatalogLoader catLoader = (JDBCCatalogLoader)loader;
            catLoader.setCatalogObject(this);
            return catLoader;
        }
        return new JDBCCatalogLoader(this);
    }

    protected final JDBCCatalogLoader getLoader() {
        if (this.catalogLoaderRef == null || this.catalogLoaderRef.get() == null) {
            this.catalogLoaderRef = new SoftReference<JDBCCatalogLoader>(this.createLoader());
        }
        return (JDBCCatalogLoader)this.catalogLoaderRef.get();
    }

    private void loadCatalogs() {
        boolean deliver = this.eDeliver();
        try {
            try {
                EList container = super.getCatalogs();
                ArrayList existingCatalogs = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getLoader().loadCatalogs((List)container, existingCatalogs);
                this.getLoader().clearCatalogs(existingCatalogs);
                this.catalogsLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 12) {
            this.getCatalogs();
        }
        return super.eIsSet(eFeature);
    }

    private void handleFilterChanged(String filterKey) {
        if (!this.catalogsLoaded.booleanValue()) {
            return;
        }
        if ("DatatoolsCatalogFilterPredicate".equals(filterKey)) {
            this.refresh();
        }
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private FilterListener() {
        }

        @Override
        public void connectionFilterAdded(String filterKey) {
            JDBCDatabase.this.handleFilterChanged(filterKey);
        }

        @Override
        public void connectionFilterRemoved(String filterKey) {
            JDBCDatabase.this.handleFilterChanged(filterKey);
        }
    }
}

