/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.RefreshManager;
import com.ibm.ims.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import com.ibm.ims.datatools.connectivity.sqm.loader.JDBCSchemaLoader;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLSchemaPackage;
import com.ibm.ims.datatools.modelbase.sql.schema.impl.CatalogImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCCatalog
extends CatalogImpl
implements ICatalogObject {
    private static final long serialVersionUID = 8409098315478607573L;
    private Boolean schemasLoaded = Boolean.FALSE;
    private transient ConnectionFilterListener filterListener;
    private SoftReference schemaLoaderRef;

    @Override
    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    @Override
    public IConnection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (this.schemasLoaded.booleanValue()) {
                this.schemasLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSchemas() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (!this.schemasLoaded.booleanValue()) {
                this.loadSchemas();
            }
        }
        return super.getSchemas();
    }

    protected JDBCSchemaLoader createLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLSchemaPackage.eINSTANCE.getSchema().getInstanceClassName());
        if (loader != null) {
            JDBCSchemaLoader schemaLoader = (JDBCSchemaLoader)loader;
            schemaLoader.setCatalogObject(this);
            return schemaLoader;
        }
        return new JDBCSchemaLoader(this);
    }

    private JDBCSchemaLoader getLoader() {
        if (this.schemaLoaderRef == null || this.schemaLoaderRef.get() == null) {
            this.schemaLoaderRef = new SoftReference<JDBCSchemaLoader>(this.createLoader());
        }
        return (JDBCSchemaLoader)this.schemaLoaderRef.get();
    }

    private void loadSchemas() {
        boolean deliver = this.eDeliver();
        try {
            try {
                EList container = super.getSchemas();
                ArrayList existingSchemas = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getLoader().loadSchemas((List)container, existingSchemas);
                this.getLoader().clearSchemas(existingSchemas);
                this.schemasLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    private String getSchemaFilterKey() {
        return this.getName() + "::DatatoolsSchemaFilterPredicate";
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getSchemas();
        }
        return super.eIsSet(eFeature);
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.schemasLoaded.booleanValue() && (filterKey.equals(this.getSchemaFilterKey()) || conInf != null && "DatatoolsSchemaFilterPredicate".equals(filterKey) && conInf.getFilter(this.getSchemaFilterKey()) == null)) {
            this.schemasLoaded = Boolean.FALSE;
            this.getLoader().clearSchemas((List)super.getSchemas());
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh(this);
        }
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private FilterListener() {
        }

        @Override
        public void connectionFilterAdded(String filterKey) {
            JDBCCatalog.this.handleFilterChanged(filterKey);
        }

        @Override
        public void connectionFilterRemoved(String filterKey) {
            JDBCCatalog.this.handleFilterChanged(filterKey);
        }
    }
}

