/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.rte;

import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import java.util.Hashtable;
import java.util.Vector;

public class RefreshManager {
    private static RefreshManager instance = null;
    private Hashtable listeners = new Hashtable();
    private Vector globalListeners = new Vector();

    private RefreshManager() {
    }

    public static RefreshManager getInstance() {
        if (instance == null) {
            instance = new RefreshManager();
        }
        return instance;
    }

    public void AddListener(ICatalogObject interestedObject, ICatalogObjectListener listener) {
        if (interestedObject == null) {
            if (!this.globalListeners.contains(listener)) {
                this.globalListeners.add(listener);
            }
        } else if (this.listeners.containsKey(interestedObject)) {
            Vector listenerLinks = (Vector)this.listeners.get(interestedObject);
            if (!listenerLinks.contains(listener)) {
                listenerLinks.add(listener);
            }
        } else {
            Vector<ICatalogObjectListener> listenerLinks = new Vector<ICatalogObjectListener>();
            listenerLinks.add(listener);
            this.listeners.put(interestedObject, listenerLinks);
        }
    }

    public void removeListener(ICatalogObject interestedObject, ICatalogObjectListener listener) {
        Vector listenerLinks;
        if (interestedObject == null) {
            if (this.globalListeners.contains(listener)) {
                this.globalListeners.remove(listener);
            }
        } else if (this.listeners.containsKey(interestedObject) && (listenerLinks = (Vector)this.listeners.get(interestedObject)).contains(listener)) {
            listenerLinks.remove(listener);
        }
    }

    public void clearListener() {
        this.listeners.clear();
        this.globalListeners.clear();
    }

    public void referesh(ICatalogObject object) {
        int i = 0;
        while (i < this.globalListeners.size()) {
            ((ICatalogObjectListener)this.globalListeners.elementAt(i)).notifyChanged(object, 0);
            ++i;
        }
        if (this.listeners.containsKey(object)) {
            Vector listenerLinks = (Vector)this.listeners.get(object);
            int i2 = 0;
            while (i2 < listenerLinks.size()) {
                ICatalogObjectListener listener = (ICatalogObjectListener)listenerLinks.elementAt(i2);
                listener.notifyChanged(object, 0);
                ++i2;
            }
        }
    }
}

