/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.mappings;

import com.ibm.ims.datatools.connectivity.drivers.models.CategoryDescriptor;
import com.ibm.ims.datatools.connectivity.drivers.models.TemplateDescriptor;
import com.ibm.ims.datatools.connectivity.sqm.core.mappings.ProviderIDtoDriverCategoryIDDescriptor;
import java.util.HashMap;

public class ProviderIDMappingRegistry {
    private static ProviderIDMappingRegistry sRegistry;
    private static HashMap<String, String> sProviderIDToCategoryIDMap;
    private static HashMap<String, String> sCategoryIDtoProviderIDMap;
    private static HashMap<String, String> sVendorVersionToProviderIDMap;
    private static HashMap<String, String> sVendorVersionToCategoryIDMap;
    private static final String VENDORVERSION_SEPARATOR = "::";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProviderIDMappingRegistry getInstance() {
        if (sRegistry != null) return sRegistry;
        Class<ProviderIDMappingRegistry> clazz = ProviderIDMappingRegistry.class;
        synchronized (ProviderIDMappingRegistry.class) {
            sRegistry = new ProviderIDMappingRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRegistry;
        }
    }

    private ProviderIDMappingRegistry() {
        this.loadMaps();
    }

    private void loadMaps() {
        String categoryID;
        ProviderIDtoDriverCategoryIDDescriptor[] categoryIDDescriptors = ProviderIDtoDriverCategoryIDDescriptor.getMappingDescriptors();
        sProviderIDToCategoryIDMap = new HashMap();
        sCategoryIDtoProviderIDMap = new HashMap();
        if (categoryIDDescriptors != null && categoryIDDescriptors.length > 0) {
            int i = 0;
            while (i < categoryIDDescriptors.length) {
                ProviderIDtoDriverCategoryIDDescriptor descriptor = categoryIDDescriptors[i];
                String providerID = descriptor.getProviderId();
                categoryID = descriptor.getDriverCategoryID();
                sProviderIDToCategoryIDMap.put(providerID, categoryID);
                sCategoryIDtoProviderIDMap.put(categoryID, providerID);
                ++i;
            }
        }
        sVendorVersionToCategoryIDMap = new HashMap();
        TemplateDescriptor[] templates = TemplateDescriptor.getDriverTemplateDescriptors();
        if (templates != null && templates.length > 0) {
            int i = 0;
            while (i < templates.length) {
                String vendor = templates[i].getPropertyValueFromId("com.ibm.ims.datatools.connectivity.db.vendor");
                String version = templates[i].getPropertyValueFromId("com.ibm.ims.datatools.connectivity.db.version");
                if (vendor != null && vendor.trim().length() > 0 && version != null && version.trim().length() > 0) {
                    String encoded = ProviderIDMappingRegistry.encodeVendorVersion(vendor, version);
                    String categoryID2 = templates[i].getParentCategory();
                    if (categoryID2 != null) {
                        sVendorVersionToCategoryIDMap.put(encoded, categoryID2);
                    }
                }
                ++i;
            }
        }
        sVendorVersionToProviderIDMap = new HashMap();
        for (String key : sVendorVersionToCategoryIDMap.keySet()) {
            categoryID = sVendorVersionToCategoryIDMap.get(key);
            String providerID = this.getProviderIDforDriverCategoryID(categoryID);
            if (providerID == null || providerID.trim().length() <= 0) continue;
            sVendorVersionToProviderIDMap.put(key, providerID);
        }
    }

    public String getProviderIDforDriverCategoryID(String driverCategoryID) {
        if (driverCategoryID != null) {
            if (sCategoryIDtoProviderIDMap.get(driverCategoryID) != null) {
                return sCategoryIDtoProviderIDMap.get(driverCategoryID);
            }
            CategoryDescriptor cd = CategoryDescriptor.getCategoryDescriptor((String)driverCategoryID);
            if (cd != null) {
                CategoryDescriptor parent = cd.getParent();
                while (parent != null && !parent.getId().equals("com.ibm.ims.datatools.connectivity.db.driverCategory")) {
                    String providerID = sCategoryIDtoProviderIDMap.get(parent.getId());
                    if (providerID != null) {
                        return providerID;
                    }
                    parent = parent.getParent();
                }
                return sCategoryIDtoProviderIDMap.get(driverCategoryID);
            }
        }
        return null;
    }

    public String getCategoryIDforProviderID(String providerID) {
        if (providerID != null) {
            return sProviderIDToCategoryIDMap.get(providerID);
        }
        return null;
    }

    public String getProviderIDforVendorVersion(String vendor, String version) {
        if (vendor != null && version != null) {
            return sVendorVersionToProviderIDMap.get(ProviderIDMappingRegistry.encodeVendorVersion(vendor, version));
        }
        return null;
    }

    private static String encodeVendorVersion(String vendor, String version) {
        return vendor + VENDORVERSION_SEPARATOR + version;
    }
}

