/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.utils;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class JDBCURL {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger;
    private Properties additionalProperties = null;
    private String metadataURL = "";
    private String metadataClassName = "";
    private String port = "";
    private String currentSchema = "";
    private String datastoreServer = "";
    private String dbViewLocation = "";
    private String xmlMetadataLocation = "";
    private String propertiesStr = "";
    private String traceDirectory = "";
    private String traceFile = "";
    private String traceFileAppend = "";
    private String traceLevel = "";
    private String sslConnection = "";
    private String loginTimeout = "";
    public static final String TRACE_DIRECTORY_PROPERTY_NAME = "traceDirectory";
    public static final String TRACE_FILE_PROPERTY_NAME = "traceFile";
    public static final String TRACE_FILE_APPEND_PROPERTY_NAME = "traceFileAppend";
    public static final String TRACE_LEVEL_PROPERTY_NAME = "traceLevel";
    public static final String SSL_CONNECTION_PROPERTY_NAME = "sslConnection";
    public static final String LOGIN_TIMEOUT_PROPERTY_NAME = "loginTimeout";
    public static final String DPSB_ON_COMMIT = "dpsbOnCommit";
    public static final String TREAT_INVALID_DECIMAL_AS_NULL = "treatInvalidDecimalAsNull";
    public static final String DBVIEW_LOCATION = "dbViewLocation";
    public static final String XML_METADATA_LOCATION = "xmlMetadataLocation";
    public static final String CURRENT_SCHEMA = "currentSchema";
    public static final String DATASTORE_NAME = "datastoreName";
    public static final String FETCH_SIZE = "fetchSize";
    private boolean isCatalogEnabled = false;
    public static final String JAVA_METADATA_FOLDER = "IMS Universal Drivers Metadata";

    public JDBCURL(String url) {
        logger = Logger.getLogger(this.getClass().getName());
        this.parseURL(url);
    }

    public String getDatastoreServer() {
        return this.datastoreServer;
    }

    public String getPort() {
        return this.port;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public String getMetadataURL() {
        return this.metadataURL;
    }

    public String getMetadataClassName() {
        return this.metadataClassName;
    }

    public boolean isCatalogEnabled() {
        return this.isCatalogEnabled;
    }

    private void parseURL(String url) {
        logger.entering(this.getClass().getName(), "parseURL()", url);
        int colonIndex = url.indexOf(58);
        if (colonIndex < 0) {
            return;
        }
        String remainingURL = url.substring(colonIndex + 1);
        if ((colonIndex = remainingURL.indexOf(58)) < 0) {
            return;
        }
        if ((colonIndex = (remainingURL = remainingURL.substring(colonIndex + 1)).indexOf(58)) < 0) {
            return;
        }
        this.datastoreServer = remainingURL.substring(2, colonIndex);
        logger.finest("datastoreServer: " + this.datastoreServer);
        remainingURL = remainingURL.substring(colonIndex + 1);
        logger.finest("remainingURL: " + remainingURL);
        int fwdSlashIndex = remainingURL.indexOf(47);
        if (fwdSlashIndex < 0) {
            return;
        }
        this.port = remainingURL.substring(0, fwdSlashIndex);
        logger.finest("port: " + this.port);
        remainingURL = remainingURL.substring(fwdSlashIndex + 1);
        logger.finest("remainingURL: " + remainingURL);
        colonIndex = remainingURL.indexOf(":");
        if (remainingURL.contains("://")) {
            if (colonIndex < 0) {
                this.metadataURL = remainingURL;
            } else if ((colonIndex = remainingURL.indexOf(":", colonIndex + 1)) >= 0) {
                this.metadataURL = remainingURL.substring(0, colonIndex);
                remainingURL = remainingURL.substring(colonIndex + 1);
            }
        } else {
            this.metadataURL = remainingURL.substring(0, colonIndex);
            remainingURL = remainingURL.substring(colonIndex + 1);
            this.isCatalogEnabled = true;
        }
        if (this.metadataURL.contains("://")) {
            this.metadataClassName = this.metadataURL.substring(this.metadataURL.indexOf("://") + 3);
        }
        logger.finest("metadataClassName: " + this.metadataClassName);
        this.propertiesStr = remainingURL;
        logger.finest("properties: " + this.propertiesStr);
        Properties properties = this.parseProperties(this.propertiesStr);
        Iterator<String> propNames = properties.stringPropertyNames().iterator();
        this.additionalProperties = new Properties();
        while (propNames.hasNext()) {
            String propName = propNames.next();
            if (propName.equals(TRACE_DIRECTORY_PROPERTY_NAME)) {
                String traceDirectoryStr = properties.getProperty(TRACE_DIRECTORY_PROPERTY_NAME);
                if (traceDirectoryStr == null || traceDirectoryStr.isEmpty()) continue;
                this.traceDirectory = traceDirectoryStr;
                logger.finest("traceDirectory: " + this.traceDirectory);
                continue;
            }
            if (propName.equals(TRACE_FILE_PROPERTY_NAME)) {
                String traceFileStr = properties.getProperty(TRACE_FILE_PROPERTY_NAME);
                if (traceFileStr == null || traceFileStr.isEmpty()) continue;
                this.traceFile = traceFileStr;
                logger.finest("traceFile: " + this.traceFile);
                continue;
            }
            if (propName.equals(TRACE_FILE_APPEND_PROPERTY_NAME)) {
                String traceFileAppendStr = properties.getProperty(TRACE_FILE_APPEND_PROPERTY_NAME);
                if (traceFileAppendStr == null || traceFileAppendStr.isEmpty()) continue;
                this.traceFileAppend = traceFileAppendStr;
                logger.finest("traceFileAppend: " + this.traceFileAppend);
                continue;
            }
            if (propName.equals(TRACE_LEVEL_PROPERTY_NAME)) {
                String traceLevelStr = properties.getProperty(TRACE_LEVEL_PROPERTY_NAME);
                if (traceLevelStr == null || traceLevelStr.isEmpty()) continue;
                this.traceLevel = traceLevelStr;
                logger.finest("traceLevel: " + this.traceLevel);
                continue;
            }
            if (propName.equals(SSL_CONNECTION_PROPERTY_NAME)) {
                String sslConnectionStr = properties.getProperty(SSL_CONNECTION_PROPERTY_NAME);
                if (sslConnectionStr == null || sslConnectionStr.isEmpty()) continue;
                this.sslConnection = sslConnectionStr;
                logger.finest("sslConnection: " + this.sslConnection);
                continue;
            }
            if (propName.equals(LOGIN_TIMEOUT_PROPERTY_NAME)) {
                String loginTimeoutStr = properties.getProperty(LOGIN_TIMEOUT_PROPERTY_NAME);
                if (loginTimeoutStr == null || loginTimeoutStr.isEmpty()) continue;
                this.loginTimeout = loginTimeoutStr;
                logger.finest("loginTimeout: " + this.loginTimeout);
                continue;
            }
            if (propName.equals(CURRENT_SCHEMA)) {
                String currentSchemaStr = properties.getProperty(CURRENT_SCHEMA);
                if (currentSchemaStr == null || currentSchemaStr.isEmpty()) continue;
                this.currentSchema = currentSchemaStr;
                logger.finest("currentSchema: " + this.currentSchema);
                continue;
            }
            if (propName.equals(DBVIEW_LOCATION)) {
                String dbViewLocStr = properties.getProperty(DBVIEW_LOCATION);
                if (dbViewLocStr == null || dbViewLocStr.isEmpty()) continue;
                this.dbViewLocation = dbViewLocStr;
                logger.finest("dbViewLocation: " + this.dbViewLocation);
                continue;
            }
            if (propName.equals(XML_METADATA_LOCATION)) {
                String xmlMetadataLocStr = properties.getProperty(XML_METADATA_LOCATION);
                if (xmlMetadataLocStr == null || xmlMetadataLocStr.isEmpty()) continue;
                this.xmlMetadataLocation = xmlMetadataLocStr;
                logger.finest("xmlMetadataLocation: " + this.xmlMetadataLocation);
                continue;
            }
            if (propName.equals(DPSB_ON_COMMIT) || propName.equals(TREAT_INVALID_DECIMAL_AS_NULL)) continue;
            this.additionalProperties.setProperty(propName, properties.getProperty(propName));
        }
        logger.exiting(this.getClass().getName(), "parseURL()");
    }

    private Properties parseProperties(String propertiesStr) {
        Properties properties = new Properties();
        int equalsIx = propertiesStr.indexOf("=");
        int semicolonIx = propertiesStr.indexOf(";");
        while (semicolonIx > 0 && equalsIx > 0) {
            properties.setProperty(propertiesStr.substring(0, equalsIx), propertiesStr.substring(equalsIx + 1, semicolonIx));
            propertiesStr = propertiesStr.substring(semicolonIx + 1);
            equalsIx = propertiesStr.indexOf("=");
            semicolonIx = propertiesStr.indexOf(";");
        }
        return properties;
    }

    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public String getTraceFileAppend() {
        return this.traceFileAppend;
    }

    public String getTraceLevel() {
        return this.traceLevel;
    }

    public String getSslConnection() {
        return this.sslConnection;
    }

    public String getDbViewLocation() {
        return this.dbViewLocation;
    }

    public String getXmlMetadataLocation() {
        return this.xmlMetadataLocation;
    }

    public String getProjectName() {
        String dbViewLocStr = this.getDbViewLocation();
        StringTokenizer tokr = new StringTokenizer(dbViewLocStr, File.separator + "/", false);
        String prevTok = null;
        String currTok = null;
        String projectName = null;
        while (tokr.hasMoreTokens()) {
            currTok = tokr.nextToken();
            if (currTok.equals(JAVA_METADATA_FOLDER)) {
                projectName = prevTok;
                break;
            }
            prevTok = currTok;
        }
        return projectName;
    }

    public String getPsbName() {
        String psbName = null;
        if (this.isCatalogEnabled) {
            psbName = this.getMetadataURL();
        } else {
            String metadataClassNameStr = this.getMetadataClassName();
            psbName = metadataClassNameStr.substring(metadataClassNameStr.lastIndexOf(".") + 1);
            if (psbName.indexOf("DatabaseView") > 0) {
                psbName = psbName.substring(0, psbName.indexOf("DatabaseView"));
            }
        }
        return psbName;
    }

    public String getLoginTimeout() {
        return this.loginTimeout;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }
}

