/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.utils;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionAquireLockException;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionReleaseLockException;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.Xlat;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ImsDbUtils {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private static IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
    private static ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();

    public static void addListener(ConnectionManagerListener listener) {
        connectionManager.addListener(listener);
    }

    public static IImsDbConnection getConnectionById(String connProfId, boolean connect) {
        IConnection connection;
        IImsDbConnection retVal = null;
        ConnectionProfile connProf = ImsDbUtils.getConnectionProfileById(connProfId);
        IConnectionState connectionState = connectionService.getConnectionState(connProf);
        if (connectionState instanceof DisconnectedState && connect) {
            connectionService.connect(connProf.getId());
            connectionState = connectionService.getConnectionState(connProf);
        }
        if (connectionState instanceof ConnectedState && (connection = ((ConnectedState)connectionState).getConnection()) instanceof IImsDbConnection) {
            retVal = (IImsDbConnection)connection;
        }
        return retVal;
    }

    public static IImsDbConnection getConnectionByName(String connProfName, boolean connect) {
        IImsDbConnection retVal = null;
        ConnectionProfile connProf = ImsDbUtils.getConnectionProfileByName(connProfName);
        if (connProf != null) {
            IConnection connection;
            IConnectionState connectionState = connectionService.getConnectionState(connProf);
            if (connectionState instanceof DisconnectedState && connect) {
                connectionService.connect(connProf.getId());
                connectionState = connectionService.getConnectionState(connProf);
            }
            if (connectionState instanceof ConnectedState && (connection = ((ConnectedState)connectionState).getConnection()) instanceof IImsDbConnection) {
                retVal = (IImsDbConnection)connection;
            }
        }
        return retVal;
    }

    public static boolean isDefaultConnectionProfile(ConnectionProfile profile) {
        IConnectionService cs = ConnectionsPlugin.getDefault().getConnectionService();
        DefaultConnectionService dcs = ((ConnectionService)cs).getDefaultConnectionService();
        return dcs.isDefault(profile);
    }

    public static void doConnect(ConnectionProfile profile, boolean async) {
        if (profile != null) {
            if (async) {
                connectionService.connectAsync(profile.getId());
            } else {
                connectionService.connect(profile.getId());
            }
        }
    }

    public static void doDisconnect(final ConnectionProfile profile) {
        if (profile != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ConnectionUtils.supportsMultipleConnections((IConnectionDescriptor)profile.getConnectionDescriptor())) {
                        ImsDbUtils.multiConnectionPreDisconnect(profile);
                    }
                    try {
                        connectionService.disconnect(profile.getConnectionDescriptor().getCategory().getId());
                    }
                    catch (ConnectionException e) {
                        logger.error((Throwable)e);
                    }
                }
            });
        }
    }

    public static void doDisconnectSync(final ConnectionProfile profile) {
        if (profile != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ConnectionUtils.supportsMultipleConnections((IConnectionDescriptor)profile.getConnectionDescriptor())) {
                        ImsDbUtils.multiConnectionPreDisconnect(profile);
                    }
                    try {
                        connectionService.disconnect(profile.getConnectionDescriptor().getCategory().getId());
                    }
                    catch (ConnectionException e) {
                        logger.error((Throwable)e);
                    }
                }
            });
        }
    }

    private static void multiConnectionPreDisconnect(ConnectionProfile connectionProfile) {
        IConnectionState desirableState;
        String connectionCategoryId = connectionProfile.getConnectionDescriptor().getCategory().getId();
        IConnectionState state = connectionService.getConnectionState(connectionCategoryId);
        if (!state.getID().equals(connectionProfile.getId()) && (desirableState = connectionService.getConnectionState(connectionProfile)) instanceof ConnectedState) {
            IConnection connection = ((ConnectedState)desirableState).getConnection();
            ((ConnectionService)connectionService).switchToAlreadyConnected(connection, connectionProfile);
        }
    }

    public static List<String> getConnectionProfileNames() {
        List profList = connectionManager.getConnectionProfiles("com.ibm.im.ims.workbench.imsdb.connections.type");
        ArrayList<String> retVal = new ArrayList<String>(profList.size());
        int i = 0;
        while (i < profList.size()) {
            retVal.add(((ConnectionProfile)profList.get(i)).getName());
            ++i;
        }
        return retVal;
    }

    public static List<ConnectionProfile> getConnectionProfiles() {
        List profList = connectionManager.getConnectionProfiles("com.ibm.im.ims.workbench.imsdb.connections.type");
        return profList;
    }

    public static ConnectionProfile getConnectionProfileById(String connProfId) {
        ConnectionProfile connectionProfile = null;
        List<ConnectionProfile> connectionProfiles = ImsDbUtils.getConnectionProfiles();
        int i = 0;
        while (i < connectionProfiles.size()) {
            ConnectionProfile currConnProf = connectionProfiles.get(i);
            if (currConnProf.getId().equals(connProfId)) {
                connectionProfile = currConnProf;
                break;
            }
            ++i;
        }
        return connectionProfile;
    }

    public static ConnectionProfile getConnectionProfileByName(String connProfName) {
        ConnectionProfile connectionProfile = null;
        List<ConnectionProfile> connectionProfiles = ImsDbUtils.getConnectionProfiles();
        int i = 0;
        while (i < connectionProfiles.size()) {
            ConnectionProfile currConnProf = connectionProfiles.get(i);
            if (currConnProf.getName().equals(connProfName)) {
                connectionProfile = currConnProf;
                break;
            }
            ++i;
        }
        return connectionProfile;
    }

    public static void disconnectAllWithSameCredential(final ConnectionProfile profile) {
        if (profile != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImsDbUtils.disconnectAllWithSameCred(profile);
                }
            });
        }
    }

    private static void disconnectAllWithSameCred(ConnectionProfile profile) {
        ImsDbUtils.doDisconnect(profile);
        CredentialsConfiguration credsConfig = profile.getCredentials();
        if (credsConfig == null) {
            return;
        }
        for (ConnectionProfile nextProfile : connectionManager.getConnectionProfiles("com.ibm.im.ims.workbench.imsdb.connections.type")) {
            CredentialsConfiguration nextCredsConfig;
            if (StringUtils.equals((CharSequence)nextProfile.getId(), (CharSequence)profile.getId()) || (nextCredsConfig = nextProfile.getCredentials()) == null || !StringUtils.equals((CharSequence)nextCredsConfig.getID(), (CharSequence)credsConfig.getID())) continue;
            ImsDbUtils.doDisconnect(nextProfile);
        }
    }

    public static String getServerNameWithHostAndPort(ConnectionProfile profile) {
        if (profile == null || profile.getConnectionConfiguration() == null) {
            return "";
        }
        ConnectionConfiguration config = profile.getConnectionConfiguration();
        return ImsDbUtils.getServerNameWithHostAndPort(config);
    }

    public static String getServerNameWithHostAndPort(ConnectionConfiguration config) {
        if (config == null) {
            return "";
        }
        StringBuilder serverName = new StringBuilder();
        serverName.append("\"");
        serverName.append(config.getName());
        serverName.append("\" (");
        serverName.append(config.getHost());
        serverName.append(Xlat.colon());
        serverName.append(config.getPort());
        serverName.append(")");
        return serverName.toString();
    }

    public static int getTextWidth(Composite composite, int style, String label) {
        Text text = new Text(composite, style);
        text.setText(label);
        text.setFont(composite.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public static int getTextHeight(Composite composite, int style, int margin) {
        Text text = new Text(composite, style);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int charHeight = fm.getHeight();
        int charWidth = fm.getAverageCharWidth();
        gc.dispose();
        int retVal = text.computeSize((int)charWidth, (int)charHeight).y;
        text.dispose();
        return retVal + margin * 2;
    }

    public static CredentialsConfiguration getCredentialsConfiguration(ConnectionConfiguration configuration) {
        return credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
    }

    public static CredentialsConfiguration getCredentialsConfiguration(ConnectionProfile profile) {
        return credentialsManager.findCredentialsConfigurationByID(profile.getConnectionConfiguration().getCredentialsID());
    }

    public static List<Pair<String, String>> getQualifiedProfileNames() {
        ArrayList<Pair<String, String>> profileQNames = new ArrayList<Pair<String, String>>();
        for (ConnectionProfile profile : ImsDbUtils.getConnectionProfiles()) {
            profileQNames.add((Pair<String, String>)Pair.of((Object)profile.getName(), (Object)profile.getId()));
        }
        return profileQNames;
    }

    public static boolean lockConnectionByName(String profileName) throws ImsDbConnectionAquireLockException {
        boolean locked = false;
        IImsDbConnection conn = ImsDbUtils.getConnectionByName(profileName, false);
        if (conn != null) {
            locked = conn.acquireLock();
        }
        return locked;
    }

    public static boolean unlockConnectionByName(String profileName) throws ImsDbConnectionReleaseLockException {
        boolean unlocked = false;
        IImsDbConnection conn = ImsDbUtils.getConnectionByName(profileName, false);
        if (conn != null) {
            unlocked = conn.releaseLock();
        }
        return unlocked;
    }
}

