/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.types;

import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.im.ims.workbench.imsdb.connections.customizers.ImsDbConnectionPreferences;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionAquireLockException;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionReleaseLockException;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.ICredManagerListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.ImsDbCredentialsManagerListener;
import com.ibm.im.ims.workbench.imsdb.connections.models.ImsDbResourceType;
import com.ibm.im.ims.workbench.imsdb.connections.properties.ResourceLoader;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.imsdb.connections.utils.Xlat;
import com.ibm.ims.dli.PCB;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import com.ibm.ims.explorer.files.ProjectTreeFileHelper;
import com.ibm.ims.jdbc.IMSDataSource;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImsDbConnection
extends AbstractConnection
implements IImsDbConnection,
ICredManagerListener {
    public static final String TAG = ImsDbConnection.class.getName();
    public static final String CONNECT_TIMEOUT_KEY = "CONNECT_TIMEOUT";
    public static final int DEFAULT_TRY_LOCK_ATTEMPTS = 11;
    public static final int DEFAULT_TRY_LOCK_TIMEOUT_MS = 3000;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private static ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private Connection connection;
    private ReentrantLock lock = new ReentrantLock();

    public void connect() throws ConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "connect", new Object[0]);
        }
        try {
            this.acquireLock();
        }
        catch (Throwable t) {
            logger.error(t);
            return;
        }
        try {
            try {
                if (this.isSecure()) {
                    this.initSSLConfiguration();
                    this.checkConnectionCertChain();
                }
                this.initDbConnection();
                this.testConnection();
                ImsDbCredentialsManagerListener.addListener(this);
            }
            catch (ImsDbConnectionException e) {
                logger.error((Throwable)e);
                if (e.isCausedByCertificateException()) {
                    throw new ConnectionException((Exception)e);
                }
                final ConnectionConfiguration configuration = this.getConfiguration();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = logger.createMultiStatus(4, Xlat.label("VIEW_DETAILS", new String[0]), (Throwable)e);
                        ErrorDialog.openError((Shell)XSwt.getActiveShell(), (String)Xlat.label("ERRDLG_TITLE", new String[0]), (String)Xlat.label("CONNECT_ERROR", configuration.getName()), (IStatus)status);
                    }
                });
                throw new ConnectionException(e.getExternalMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                ImsDbCredentialsManagerListener.removeListener(this);
                throw new ConnectionException(e);
            }
        }
        finally {
            try {
                this.releaseLock();
            }
            catch (Throwable t) {
                logger.error(t);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "connect", new Object[0]);
        }
    }

    public void disconnect() throws ConnectionException {
        block8: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "disconnect", new Object[0]);
            }
            if (this.connection != null) {
                try {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e) {
                        logger.error((Throwable)e);
                        ImsDbCredentialsManagerListener.removeListener(this);
                        this.connection = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    ImsDbCredentialsManagerListener.removeListener(this);
                    this.connection = null;
                    throw throwable;
                }
                ImsDbCredentialsManagerListener.removeListener(this);
                this.connection = null;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "disconnect", new Object[0]);
        }
    }

    public boolean isConnected() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "isConnected", new Object[0]);
        }
        boolean connected = false;
        if (this.connection != null) {
            connected = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "isConnected(): {0}", new Object[]{connected});
        }
        return connected;
    }

    private void testConnection() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "testConnection", new Object[0]);
        }
        try {
            try {
                if (this.connection == null) {
                    throw new ImsDbConnectionException(new ConnectException("No existing connection."));
                }
                try {
                    Statement stmt = this.connection.createStatement();
                    ResultSet rsst = stmt.executeQuery("SELECT IMSNAME FROM DFSCAT00.HEADER WHERE TYPE = 'PSB' AND IMSNAME = 'DFSCP000'");
                    rsst.next();
                }
                catch (Throwable t) {
                    throw new ImsDbConnectionException(t);
                }
            }
            catch (Throwable t) {
                if (t instanceof ImsDbConnectionException) {
                    throw (ImsDbConnectionException)t;
                }
                throw new ImsDbConnectionException(t);
            }
        }
        finally {
            block17: {
                try {
                    if (this.connection != null) {
                        this.connection.commit();
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINER)) break block17;
                    logger.finer(t.getMessage());
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "testConnection", new Object[0]);
        }
    }

    private boolean ensureConnected() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "ensureConnected", new Object[0]);
        }
        boolean connected = false;
        try {
            this.testConnection();
            connected = true;
        }
        catch (ImsDbConnectionException e) {
            if (e.isCausedByConnectivityException()) {
                ConnectionProfile profile = connectionManager.getConnectionProfile(this.getConfiguration().getID());
                try {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("reconnecting profile {0} due to error {1}", new Object[]{profile.getName(), e.getMessage()});
                    }
                    this.initDbConnection();
                    this.testConnection();
                    connected = true;
                }
                catch (ImsDbConnectionException e1) {
                    if (e1.isCausedByConnectivityException()) {
                        ImsDbUtils.doDisconnectSync(profile);
                    }
                    throw e1;
                }
            }
            throw e;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "ensureConnected", new Object[0]);
        }
        return connected;
    }

    public boolean isSecure() {
        return this.getConfiguration().getSecureHint();
    }

    private void initDbConnection() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "initDbConnection", new Object[0]);
        }
        ConnectionConfiguration configuration = null;
        ConnectionProfile profile = null;
        CredentialsConfiguration credential = null;
        try {
            this.connection = null;
            configuration = this.getConfiguration();
            profile = connectionManager.getConnectionProfile(configuration.getID());
            credential = credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
            String hostName = configuration.getHost();
            int portNumber = configuration.getPort();
            String userName = null;
            String password = null;
            if (!this.isClientCert() && credential != null) {
                userName = credential.getUserID();
                password = String.valueOf(credential.getPasswordAsCharArray());
            }
            int seconds = 10;
            String loginTimeoutStr = configuration.getExtendedAttribute("LOGIN_TIMEOUT");
            try {
                if (loginTimeoutStr != null && !loginTimeoutStr.isEmpty()) {
                    seconds = Integer.parseInt(loginTimeoutStr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean isSsl = configuration.getSecureHint();
            Properties props = new Properties();
            if (isSsl) {
                String sslTrustStoreLocationStr = ExplorerSecurityHelper.getCurrentTrustStore();
                String sslTrustStorePassphraseStr = String.valueOf(ExplorerSecurityHelper.getCurrentTrustStorePassphraseAsCharArray());
                String sslKeyStoreLocationStr = ExplorerSecurityHelper.getCurrentKeyStore();
                String sslKeyStorePassphraseStr = String.valueOf(ExplorerSecurityHelper.getCurrentKeyStorePassphraseAsCharArray());
                String sslProtocol = this.sslContext.getProtocol();
                props.put("sslConnection", "true");
                if (sslTrustStoreLocationStr != null && !sslTrustStoreLocationStr.isEmpty()) {
                    props.put("sslTrustStoreLocation", sslTrustStoreLocationStr);
                }
                if (sslTrustStorePassphraseStr != null && !sslTrustStorePassphraseStr.isEmpty()) {
                    props.put("sslTrustStorePassword", sslTrustStorePassphraseStr);
                }
                if (sslKeyStoreLocationStr != null && !sslKeyStoreLocationStr.isEmpty()) {
                    props.put("sslKeyStoreLocation", sslKeyStoreLocationStr);
                }
                if (sslKeyStorePassphraseStr != null && !sslKeyStorePassphraseStr.isEmpty()) {
                    props.put("sslKeyStorePassword", sslKeyStorePassphraseStr);
                }
                if (sslProtocol != null && !sslProtocol.isEmpty()) {
                    props.put("sslSecureSocketProtocol", sslProtocol);
                }
            }
            IMSDataSource ds = new IMSDataSource();
            String projectPsbName = configuration.getExtendedAttribute("PROJECT_PSB_NAME");
            String metadataClass = configuration.getExtendedAttribute("METADATA_CLASS");
            String catalogPsbName = configuration.getExtendedAttribute("PSB_NAME");
            String projectName = configuration.getExtendedAttribute("PROJECT_NAME");
            String fileName = configuration.getExtendedAttribute("FILE_LOCATION");
            String metadataSource = configuration.getExtendedAttribute("METADATA_SOURCE");
            if (metadataSource.equals("PROJECT") && projectName.isEmpty()) {
                throw new ImsDbConnectionException(Xlat.label("PROJECT_EMPTY", new String[0]));
            }
            if (metadataSource.equals("FILE") && fileName.isEmpty()) {
                throw new ImsDbConnectionException(Xlat.label("FILE_EMPTY", new String[0]));
            }
            if (metadataSource.equals("CATALOG") && catalogPsbName.isEmpty() || metadataSource.equals("PROJECT") && projectPsbName.isEmpty() || metadataSource.equals("FILE") && metadataClass.isEmpty()) {
                throw new ImsDbConnectionException(Xlat.label("PSB_EMPTY", new String[0]));
            }
            if (catalogPsbName != null && !catalogPsbName.isEmpty()) {
                ds.setDatabaseName(catalogPsbName);
            } else if (projectPsbName != null && !projectPsbName.isEmpty()) {
                String databaseName = "xml://" + projectPsbName + ".psb";
                ds.setDatabaseName(databaseName);
                String xmlMetadataLocationStr = ProjectTreeFileHelper.getProjectFolder((String)projectName).getLocationURI().getPath().toString();
                props.setProperty("xmlMetadataLocation", xmlMetadataLocationStr);
            } else if (metadataClass != null && !metadataClass.isEmpty()) {
                ds.setDatabaseName(metadataClass);
            }
            ds.setDatastoreName(configuration.getExtendedAttribute("DATASTORE"));
            ds.setDatastoreServer(hostName);
            ds.setPortNumber(portNumber);
            ds.setDriverType(4);
            ds.setLoginTimeout(seconds);
            ds.setUser(userName);
            ds.setPassword(password);
            this.additionalProperties(props, configuration);
            ds.setProperties(props);
            this.connection = ds.getConnection();
        }
        catch (Exception exception) {
            Exception filteredException = exception;
            String message = exception.getMessage();
            boolean isRacfError = StringUtils.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"HWSK2850E", "HWSK2862E", "HWSK2863E", "HWSK2865E"});
            if (isRacfError) {
                message = MessageFormat.format(ResourceLoader.IMS_AUTH_CRED_ERROR, profile.getName(), credential.getName());
                filteredException = new Exception(message);
                if (credential != null) {
                    logger.info("Disconnecting all connections that use credential: {0}", new Object[]{credential.getName()});
                    ImsDbUtils.disconnectAllWithSameCredential(profile);
                    logger.info("Authentication failed so invalidating credential: {0}", new Object[]{credential.getName()});
                    credentialsManager.invalidate(credential.getID());
                }
            }
            throw new ImsDbConnectionException(filteredException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "initDbConnection", new Object[0]);
        }
    }

    private void additionalProperties(Properties props, ConnectionConfiguration configuration) {
        String traceFileAppend;
        String traceFile;
        String traceDirectory;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "additionalProperties(props={0},configuration={1})", new Object[]{props, configuration});
        }
        props.put("dpsbOnCommit", "true");
        props.put("treatInvalidDecimalAsNull", "true");
        String traceLevel = configuration.getExtendedAttribute("TRACE_LEVEL");
        if (traceLevel != null && !traceLevel.trim().isEmpty()) {
            props.put("traceLevel", traceLevel);
        }
        if ((traceDirectory = configuration.getExtendedAttribute("TRACE_DIRECTORY")) != null && !traceDirectory.trim().isEmpty()) {
            props.put("traceDirectory", traceDirectory);
        }
        if ((traceFile = configuration.getExtendedAttribute("TRACE_FILE")) != null && !traceFile.trim().isEmpty()) {
            props.put("traceFile", traceFile);
        }
        if ((traceFileAppend = configuration.getExtendedAttribute("TRACE_APPEND")) != null && !traceFileAppend.trim().isEmpty()) {
            props.put("traceFileAppend", traceFileAppend);
        }
        String addProperties = configuration.getExtendedAttribute("ADDITIONAL_PROPERTIES");
        logger.finer("additional properties: " + addProperties);
        Properties additionalProperties = new Properties();
        if (addProperties != null && !addProperties.isEmpty()) {
            additionalProperties = this.parseProperties(addProperties);
            for (String propName : additionalProperties.stringPropertyNames()) {
                if (propName.equals("dbViewLocation") || propName.equals("xmlMetadataLocation")) continue;
                String propValue = additionalProperties.getProperty(propName);
                props.put(propName, propValue);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "additionalProperties(Properties,ConnectionConfiguration)", new Object[0]);
        }
    }

    private Properties parseProperties(String propertiesStr) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "parseProperties(propertiesStr={0})", new Object[]{propertiesStr});
        }
        Properties properties = new Properties();
        int equalsIx = propertiesStr.indexOf("=");
        int semicolonIx = propertiesStr.indexOf(";");
        while (semicolonIx > 0 && equalsIx > 0) {
            properties.setProperty(propertiesStr.substring(0, equalsIx), propertiesStr.substring(equalsIx + 1, semicolonIx));
            propertiesStr = propertiesStr.substring(semicolonIx + 1);
            equalsIx = propertiesStr.indexOf("=");
            semicolonIx = propertiesStr.indexOf(";");
        }
        Iterator<String> propNames = properties.stringPropertyNames().iterator();
        Properties additionalProperties = new Properties();
        while (propNames.hasNext()) {
            String propName = propNames.next();
            additionalProperties.setProperty(propName, properties.getProperty(propName));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "parseProperties(String})", new Object[0]);
        }
        return additionalProperties;
    }

    private void initSSLConfiguration() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "initSSLConfiguration", new Object[0]);
        }
        boolean enableExtraTLSProtocols = false;
        if (this.isClientCert()) {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
        } else {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.info("protocol={0},enableExtraTLSProtocols={1}", new Object[]{this.sslContext.getProtocol(), enableExtraTLSProtocols});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "initSSLConfiguration", new Object[0]);
        }
    }

    private void checkConnectionCertChain() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(TAG, "checkCert", new Object[0]);
        }
        ConnectionConfiguration configuration = this.getConfiguration();
        try {
            URL url = null;
            url = new URL("https://" + configuration.getHost() + ":" + configuration.getPort());
            HttpsURLConnection urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setSSLSocketFactory(this.sslSocketFactory);
            urlConn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            Integer connectTimeout = 30000;
            urlConn.setConnectTimeout(connectTimeout);
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.setRequestProperty("Accept", "application/json");
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("GET");
            urlConn.connect();
            urlConn.disconnect();
        }
        catch (IOException ioe) {
            throw new ImsDbConnectionException(ioe);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(TAG, "checkCert", new Object[0]);
        }
    }

    @Override
    public void credUpdated(CredentialsConfiguration oldCredConfig, CredentialsConfiguration newCredConfig) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "credUpdated(oldCredConfig={0}:{1},newCredConfig={2}:{3})", new Object[]{oldCredConfig != null ? oldCredConfig.getName() : "", oldCredConfig != null ? oldCredConfig.getID() : "", newCredConfig != null ? newCredConfig.getName() : "", newCredConfig != null ? newCredConfig.getID() : ""});
        }
        ConnectionConfiguration configuration = this.getConfiguration();
        ConnectionProfile profile = connectionManager.getConnectionProfile(configuration.getID());
        CredentialsConfiguration credConfig = credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
        if (profile != null && oldCredConfig != null && credConfig != null && StringUtils.equals((CharSequence)oldCredConfig.getID(), (CharSequence)credConfig.getID())) {
            ImsDbUtils.doDisconnectSync(profile);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "credUpdated", new Object[0]);
        }
    }

    @Override
    public void credAdded(CredentialsConfiguration newCredConfig) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "credAdded(newCredConfig={0}:{1}", new Object[]{newCredConfig != null ? newCredConfig.getName() : "", newCredConfig != null ? newCredConfig.getID() : ""});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "credAdded", new Object[0]);
        }
    }

    @Override
    public void credRemoved(CredentialsConfiguration remCredConfig) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "credRemoved(remCredConfig={0}:{1}", new Object[]{remCredConfig != null ? remCredConfig.getName() : "", remCredConfig != null ? remCredConfig.getID() : ""});
        }
        ConnectionConfiguration configuration = this.getConfiguration();
        ConnectionProfile profile = connectionManager.getConnectionProfile(configuration.getID());
        CredentialsConfiguration credential = credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
        if (profile != null && remCredConfig != null && credential != null && StringUtils.equals((CharSequence)remCredConfig.getID(), (CharSequence)credential.getID())) {
            ImsDbUtils.doDisconnectSync(profile);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "credRemoved", new Object[0]);
        }
    }

    public boolean isClientCert() {
        return this.getConfiguration().getCertificateDetails() != null;
    }

    @Override
    public String getId() {
        return this.getConfiguration().getID();
    }

    @Override
    public String getName() {
        return this.getConfiguration().getName();
    }

    @Override
    public String getCurrentSchemaName() {
        return ImsDbConnectionPreferences.getCurrentSchema(this.getConfiguration());
    }

    @Override
    public String getPsbName() {
        return ImsDbConnectionPreferences.getPsbName(this.getConfiguration());
    }

    @Override
    public Object getPCB(Object psbObj, String pcbName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPCB(psbObj={0},pcbName={1}", new Object[]{psbObj, pcbName});
        }
        Object pcbObj = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                pcbObj = this.getPCBInternal(psbObj, pcbName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPCB(Object,String)", new Object[0]);
        }
        return pcbObj;
    }

    private Object getPCBInternal(Object psbObj, String pcbName) throws ImsDbConnectionException {
        ImsDbConnectionException imsConnError;
        Object pcbObj;
        block8: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "getPCBInternal(psbObj={0},pcbName={1}", new Object[]{psbObj, pcbName});
            }
            pcbObj = null;
            imsConnError = null;
            try {
                Method getPcbMethod = psbObj.getClass().getMethod("getPCB", String.class);
                pcbObj = getPcbMethod.invoke(psbObj, pcbName);
            }
            catch (InvocationTargetException e) {
                imsConnError = new ImsDbConnectionException(e.getCause());
            }
            catch (Exception e) {
                imsConnError = new ImsDbConnectionException(e);
            }
            try {
                this.connection.commit();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINER)) break block8;
                logger.finer(t.getMessage());
            }
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPCBInternal(Object,String)", new Object[0]);
        }
        return pcbObj;
    }

    @Override
    public Object getPSB() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPSB", new Object[0]);
        }
        Object psbObj = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                psbObj = this.getPSBInternal();
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPSB", new Object[0]);
        }
        return psbObj;
    }

    private Object getPSBInternal() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPSBInternal", new Object[0]);
        }
        Object psbObj = null;
        ImsDbConnectionException imsConnError = null;
        try {
            Method getPsbMethod = this.connection.getClass().getMethod("getPSB", new Class[0]);
            psbObj = getPsbMethod.invoke((Object)this.connection, new Object[0]);
        }
        catch (InvocationTargetException e) {
            imsConnError = new ImsDbConnectionException(e.getCause());
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPSBInternal", new Object[0]);
        }
        return psbObj;
    }

    @Override
    public List<String> getPsbList() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbList", new Object[0]);
        }
        List<String> psbList = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                psbList = this.getPsbListInternal();
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbList", new Object[0]);
        }
        return psbList;
    }

    private List<String> getPsbListInternal() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbListInternal", new Object[0]);
        }
        ArrayList<String> psbList = new ArrayList<String>();
        ImsDbConnectionException imsConnError = null;
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rsst = stmt.executeQuery("SELECT IMSNAME FROM DFSCAT00.HEADER WHERE TYPE = 'PSB'");
            while (rsst.next()) {
                psbList.add(rsst.getString(1));
            }
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbListInternal", new Object[0]);
        }
        return psbList;
    }

    @Override
    public byte[] getCatalogMetaDataAsXML(Object pcbObj, String resourceName, byte[] resourceType) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getCatalogMetaDataAsXML(psbObj={0},resourceName={1},resourceType={2}", new Object[]{pcbObj, resourceName, resourceType});
        }
        byte[] catXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                catXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, resourceName, resourceType);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getCatalogMetaDataAsXML(Object,String,byte[])", new Object[0]);
        }
        return catXml;
    }

    private byte[] getCatalogMetaDataAsXMLInternal(Object pcbObj, String resourceName, byte[] resourceType) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getCatalogMetaDataAsXMLInternal(psbObj={0},resourceName={1},resourceType={2}", new Object[]{pcbObj, resourceName, resourceType});
        }
        byte[] catXml = null;
        ImsDbConnectionException imsConnError = null;
        try {
            Method getCatalogMetaDataAsXMLMethod = pcbObj.getClass().getMethod("getCatalogMetaDataAsXML", String.class, byte[].class);
            catXml = (byte[])getCatalogMetaDataAsXMLMethod.invoke(pcbObj, resourceName, resourceType);
        }
        catch (InvocationTargetException e) {
            imsConnError = new ImsDbConnectionException(e.getCause());
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getCatalogMetaDataAsXMLInternal(Object,String,byte[])", new Object[0]);
        }
        return catXml;
    }

    @Override
    public byte[] getCatalogMetaDataAsXML(Object pcbObj, String resourceName, byte[] resourceType, String timestamp) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getCatalogMetaDataAsXML(psbObj={0},resourceName={1},resourceType={2},timestamp={3}", new Object[]{pcbObj, resourceName, resourceType, timestamp});
        }
        byte[] catXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                catXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, resourceName, resourceType, timestamp);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getCatalogMetaDataAsXML(Object,String,byte[],String)", new Object[0]);
        }
        return catXml;
    }

    private byte[] getCatalogMetaDataAsXMLInternal(Object pcbObj, String resourceName, byte[] resourceType, String timestamp) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getCatalogMetaDataAsXMLInternal(psbObj={0},resourceName={1},resourceType={2},timestamp={3}", new Object[]{pcbObj, resourceName, resourceType, timestamp});
        }
        byte[] catXml = null;
        ImsDbConnectionException imsConnError = null;
        try {
            Method getCatalogMetaDataAsXMLMethod = pcbObj.getClass().getMethod("getCatalogMetaDataAsXML", String.class, byte[].class, String.class);
            catXml = (byte[])getCatalogMetaDataAsXMLMethod.invoke(pcbObj, resourceName, resourceType, timestamp);
        }
        catch (InvocationTargetException e) {
            imsConnError = new ImsDbConnectionException(e.getCause());
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getCatalogMetaDataAsXMLInternal(Object,String,byte[],String)", new Object[0]);
        }
        return catXml;
    }

    @Override
    public List<String> getAllTimestamps(ImsDbResourceType resourceType, String resourceName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getAllTimestamps(resourceType={0},resourceName={1}", new Object[]{resourceType, resourceName});
        }
        List<String> allTimestamps = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                allTimestamps = this.getAllTimestampsInternal(resourceType, resourceName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getAllTimestamps(ResourceType,String)", new Object[0]);
        }
        return allTimestamps;
    }

    private List<String> getAllTimestampsInternal(ImsDbResourceType resourceType, String resourceName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getAllTimestampsInternal(resourceType={0},resourceName={1}", new Object[]{resourceType, resourceName});
        }
        ArrayList<String> allTimestamps = new ArrayList<String>();
        ImsDbConnectionException imsConnError = null;
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT TSVERS FROM DFSCAT00.HEADER, DFSCAT00." + String.valueOf((Object)resourceType) + " where IMSNAME = ?");
            stmt.setString(1, resourceName);
            ResultSet rsst = stmt.executeQuery();
            while (rsst.next()) {
                String currTimestamp = rsst.getString(1);
                allTimestamps.add(currTimestamp);
            }
            stmt.close();
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getAllTimestampsInternal(ResourceType,String)", new Object[0]);
        }
        return allTimestamps;
    }

    @Override
    public String getLatestTimestamp(ImsDbResourceType resourceType, String resourceName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getLatestTimestamp(resourceType={0},resourceName={1}", new Object[]{resourceType, resourceName});
        }
        String latestTimestamp = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                latestTimestamp = this.getLatestTimestampInternal(resourceType, resourceName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getLatestTimestamp(ResourceType,String)", new Object[0]);
        }
        return latestTimestamp;
    }

    private String getLatestTimestampInternal(ImsDbResourceType resourceType, String resourceName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getLatestTimestampInternal(resourceType={0},resourceName={1}", new Object[]{resourceType, resourceName});
        }
        String latestTimestamp = "0000000000000";
        ImsDbConnectionException imsConnError = null;
        try {
            List<String> timeStamps = this.getAllTimestampsInternal(resourceType, resourceName);
            int i = 0;
            while (i < timeStamps.size()) {
                String currTimestamp = timeStamps.get(i);
                if (currTimestamp.equals("9936500000000")) {
                    currTimestamp = "0000000000000";
                }
                if (Long.valueOf(currTimestamp) > Long.valueOf(latestTimestamp)) {
                    latestTimestamp = currTimestamp;
                }
                ++i;
            }
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getLatestTimestampInternal(ResourceType,String)", new Object[0]);
        }
        return latestTimestamp;
    }

    @Override
    public List<String> getDbdList() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdList", new Object[0]);
        }
        List<String> dbdList = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                dbdList = this.getDbdListInternal();
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdList", new Object[0]);
        }
        return dbdList;
    }

    private List<String> getDbdListInternal() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdListInternal", new Object[0]);
        }
        ArrayList<String> dbdList = new ArrayList<String>();
        ImsDbConnectionException imsConnError = null;
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rsst = stmt.executeQuery("SELECT IMSNAME FROM DFSCAT00.HEADER WHERE TYPE = 'DBD'");
            while (rsst.next()) {
                dbdList.add(rsst.getString(1));
            }
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdListInternal", new Object[0]);
        }
        return dbdList;
    }

    @Override
    public Vector<String[]> getReferencingPsbs(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getReferencingPsbs(dbdName={0})", new Object[]{dbdName});
        }
        Vector<String[]> psbList = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                psbList = this.getReferencingPsbsInternal(dbdName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getReferencingPsbs(String)", new Object[0]);
        }
        return psbList;
    }

    private Vector<String[]> getReferencingPsbsInternal(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getReferencingPsbsInternal(dbdName={0})", new Object[]{dbdName});
        }
        Vector<String[]> psbList = new Vector<String[]>();
        Object paddedDbdname = dbdName;
        while (((String)paddedDbdname).length() < 8) {
            paddedDbdname = (String)paddedDbdname + " ";
        }
        String queryParm1 = (String)paddedDbdname + ".                    ";
        String queryParm2 = (String)paddedDbdname + "Z99999999999999999999";
        ImsDbConnectionException imsConnError = null;
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT PSBNAME, TSVERS FROM DFSCATSX.DBDXREF WHERE DBD2PSB >= '" + queryParm1 + "' AND DBD2PSB <= '" + queryParm2 + "'");
            ResultSet rsst = stmt.executeQuery();
            while (rsst.next()) {
                String[] psb = new String[]{rsst.getString(1), rsst.getString(2)};
                psbList.add(psb);
            }
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getReferencingPsbsInternal(String)", new Object[0]);
        }
        return psbList;
    }

    @Override
    public String getActiveTimestampFromHeader(String srcName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getActiveTimestampFromHeader(srcName={0})", new Object[]{srcName});
        }
        String activeTimestamp = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                activeTimestamp = this.getActiveTimestampFromHeaderInternal(srcName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getActiveTimestampFromHeader(String)", new Object[0]);
        }
        return activeTimestamp;
    }

    public String getActiveTimestampFromHeaderInternal(String srcName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getActiveTimestampFromHeaderInternal(srcName={0})", new Object[]{srcName});
        }
        String activeTimestamp = null;
        ImsDbConnectionException imsConnError = null;
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT PACTTS FROM DFSCAT00.HEADER WHERE IMSNAME = ?");
            stmt.setString(1, srcName);
            ResultSet rsst = stmt.executeQuery();
            if (rsst.next()) {
                activeTimestamp = rsst.getString(1);
            }
            if (activeTimestamp != null && activeTimestamp.trim().equals("9936500000000")) {
                activeTimestamp = null;
            }
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getActiveTimestampFromHeaderInternal(String)", new Object[0]);
        }
        return activeTimestamp;
    }

    @Override
    public byte[] getPsbXml(String psbName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbXml(psbName={0})", new Object[]{psbName});
        }
        byte[] psbXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                psbXml = this.getPsbXmlInternal(psbName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbXml(String)", new Object[0]);
        }
        return psbXml;
    }

    private byte[] getPsbXmlInternal(String psbName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbXmlInternal(psbName={0})", new Object[]{psbName});
        }
        byte[] psbXml = null;
        Object psbObj = this.getPSBInternal();
        Object pcbObj = this.getPCBInternal(psbObj, "DFSCAT00");
        boolean notActive = false;
        ImsDbConnectionException imsConnError = null;
        try {
            try {
                psbXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, psbName, PCB.PSB_RESOURCE);
            }
            catch (Exception e) {
                String eMsg = e.getMessage();
                if (eMsg != null && eMsg.contains("AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 338")) {
                    notActive = true;
                }
                throw e;
            }
            if (notActive) {
                String latestTimestamp = this.getLatestTimestampInternal(ImsDbResourceType.PSB, psbName);
                psbXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, psbName, PCB.PSB_RESOURCE, latestTimestamp);
            }
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbXmlInternal(String)", new Object[0]);
        }
        return psbXml;
    }

    @Override
    public byte[] getDbdXml(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdXml(dbdName={0})", new Object[]{dbdName});
        }
        byte[] dbdXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                dbdXml = this.getDbdXml_(dbdName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdXml(String)", new Object[0]);
        }
        return dbdXml;
    }

    private byte[] getDbdXml_(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdXml_(dbdName={0})", new Object[]{dbdName});
        }
        byte[] dbdXml = null;
        Object psb = this.getPSBInternal();
        Object pcb = this.getPCBInternal(psb, "DFSCAT00");
        boolean notActive = false;
        ImsDbConnectionException imsConnError = null;
        try {
            try {
                dbdXml = this.getCatalogMetaDataAsXMLInternal(pcb, dbdName, PCB.DBD_RESOURCE);
            }
            catch (Exception e) {
                String eMsg = e.getMessage();
                if (eMsg != null && eMsg.contains("AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 338")) {
                    notActive = true;
                }
                throw e;
            }
            if (notActive) {
                String latestTimestamp = this.getLatestTimestampInternal(ImsDbResourceType.DBD, dbdName);
                dbdXml = this.getCatalogMetaDataAsXMLInternal(pcb, dbdName, PCB.DBD_RESOURCE, latestTimestamp);
            }
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdXml_(String)", new Object[0]);
        }
        return dbdXml;
    }

    @Override
    public byte[] getPsbXmlByTS(String psbName, String timestamp) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbXmlByTS(psbName={0},timestamp={1})", new Object[]{psbName, timestamp});
        }
        byte[] psbXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                psbXml = this.getPsbXmlByTSInternal(psbName, timestamp);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbXmlByTS(String,String)", new Object[0]);
        }
        return psbXml;
    }

    private byte[] getPsbXmlByTSInternal(String psbName, String timestamp) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbXmlByTSInternal(psbName={0},timestamp={1})", new Object[]{psbName, timestamp});
        }
        byte[] psbXml = null;
        Object psbObj = this.getPSBInternal();
        Object pcbObj = this.getPCBInternal(psbObj, "DFSCAT00");
        ImsDbConnectionException imsConnError = null;
        try {
            if (timestamp.equals("9936500000000")) {
                timestamp = "0000000000000";
            }
            psbXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, psbName, PCB.PSB_RESOURCE, timestamp);
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbXmlByTSInternal(String,String)", new Object[0]);
        }
        return psbXml;
    }

    @Override
    public byte[] getDbdXmlByTS(String dbdName, String timestamp) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdXmlByTS(dbdName={0},timestamp={1})", new Object[]{dbdName, timestamp});
        }
        byte[] dbdXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                dbdXml = this.getDbdXmlByTSInternal(dbdName, timestamp);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdXmlByTS(String,String)", new Object[0]);
        }
        return dbdXml;
    }

    private byte[] getDbdXmlByTSInternal(String dbdName, String timestamp) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdXmlByTSInternal(dbdName={0},timestamp={1})", new Object[]{dbdName, timestamp});
        }
        byte[] dbdXml = null;
        Object psbObj = this.getPSBInternal();
        Object pcbObj = this.getPCBInternal(psbObj, "DFSCAT00");
        ImsDbConnectionException imsConnError = null;
        try {
            if (timestamp.equals("9936500000000")) {
                timestamp = "0000000000000";
            }
            dbdXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, dbdName, PCB.DBD_RESOURCE, timestamp);
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null && !StringUtils.contains((CharSequence)imsConnError.getMessage(), (CharSequence)"AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 338")) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdXmlByTSInternal(String,String)", new Object[0]);
        }
        return dbdXml;
    }

    @Override
    public byte[] getActiveDbdXml(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getActiveDbdXml(dbdName={0})", new Object[]{dbdName});
        }
        byte[] dbdXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                dbdXml = this.getActiveDbdXmlInternal(dbdName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getActiveDbdXml(String)", new Object[0]);
        }
        return dbdXml;
    }

    private byte[] getActiveDbdXmlInternal(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getActiveDbdXmlInternal(dbdName={0})", new Object[]{dbdName});
        }
        byte[] retVal = null;
        Object psbObj = this.getPSBInternal();
        Object pcbObj = this.getPCBInternal(psbObj, "DFSCAT00");
        ImsDbConnectionException imsConnError = null;
        try {
            retVal = this.getCatalogMetaDataAsXMLInternal(pcbObj, dbdName, PCB.DBD_RESOURCE);
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null && !StringUtils.contains((CharSequence)imsConnError.getMessage(), (CharSequence)"AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 338")) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getActiveDbdXmlInternal(String)", new Object[0]);
        }
        return retVal;
    }

    @Override
    public byte[] getActivePsbXml(String psbName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getActivePsbXml(psbName={0})", new Object[]{psbName});
        }
        byte[] psbXml = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                psbXml = this.getActivePsbXmlInternal(psbName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getActivePsbXml(String)", new Object[0]);
        }
        return psbXml;
    }

    private byte[] getActivePsbXmlInternal(String psbName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getActivePsbXmlInternal(psbName={0})", new Object[]{psbName});
        }
        byte[] psbXml = null;
        Object psbObj = this.getPSBInternal();
        Object pcbObj = this.getPCBInternal(psbObj, "DFSCAT00");
        ImsDbConnectionException imsConnError = null;
        try {
            psbXml = this.getCatalogMetaDataAsXMLInternal(pcbObj, psbName, PCB.PSB_RESOURCE);
        }
        catch (ImsDbConnectionException e) {
            imsConnError = e;
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        if (imsConnError != null && !StringUtils.contains((CharSequence)imsConnError.getMessage(), (CharSequence)"AIB return code (AIBRETRN): 108 AIB reason code (AIBREASN): 338")) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getActivePsbXmlInternal(String)", new Object[0]);
        }
        return psbXml;
    }

    @Override
    public List<String> getDbdAllTSVersions(String dbdName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDbdAllTSVersions(dbdName={0})", new Object[]{dbdName});
        }
        List<String> allVersions = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                allVersions = this.getAllTimestampsInternal(ImsDbResourceType.DBD, dbdName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDbdAllTSVersions(String)", new Object[0]);
        }
        return allVersions;
    }

    @Override
    public List<String> getPsbAllTSVersions(String psbName) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getPsbAllTSVersions(psbName={0})", new Object[]{psbName});
        }
        List<String> allVersions = null;
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                allVersions = this.getAllTimestampsInternal(ImsDbResourceType.PSB, psbName);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getPsbAllTSVersions(String): {0}", new Object[]{allVersions});
        }
        return allVersions;
    }

    @Override
    public void executeDdl(List<String> ddlStmts, IProgressMonitor monitor) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "executeDdl(ddlStmts={0},monitor={1})", new Object[]{ddlStmts, monitor});
        }
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                this.executeDdlInternal(ddlStmts, monitor);
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "executeDdl(List<String>,IProgressMonitor)", new Object[0]);
        }
    }

    private void executeDdlInternal(List<String> ddlStmts, IProgressMonitor monitor) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "executeDdl(ddlStmts={0},monitor={1})", new Object[]{ddlStmts, monitor});
        }
        ImsDbConnectionException imsConnError = null;
        Boolean autoCommitSave = null;
        Statement stmt = null;
        try {
            try {
                stmt = this.connection.createStatement();
                autoCommitSave = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                int i = 0;
                while (i < ddlStmts.size() && imsConnError == null) {
                    if (monitor.isCanceled()) {
                        this.connection.rollback();
                        break;
                    }
                    String currStmt = ddlStmts.get(i);
                    try {
                        String[] statements = currStmt.split(";");
                        int j = 0;
                        while (j < statements.length) {
                            currStmt = statements[j];
                            if (!currStmt.trim().isEmpty()) {
                                stmt.execute(currStmt);
                            }
                            ++j;
                        }
                    }
                    catch (SQLException e) {
                        this.connection.rollback();
                        imsConnError = new ImsDbConnectionException(e);
                    }
                    ++i;
                }
                if (ddlStmts.size() > 0) {
                    stmt.execute("COMMIT DDL");
                    this.connection.commit();
                }
            }
            catch (Throwable t) {
                throw new ImsDbConnectionException(t);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                logger.finer(e.getMessage());
            }
            try {
                if (autoCommitSave != null) {
                    this.connection.setAutoCommit(autoCommitSave);
                }
            }
            catch (SQLException e) {
                logger.finer(e.getMessage());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "executeDdlInternal(List<String>,IProgressMonitor)", new Object[0]);
        }
    }

    @Override
    public void clearCache() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "clearCache", new Object[0]);
        }
        this.acquireLock();
        try {
            if (this.ensureConnected()) {
                this.clearCacheInternal();
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "clearCache", new Object[0]);
        }
    }

    private void clearCacheInternal() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "clearCacheInternal", new Object[0]);
        }
        ImsDbConnectionException imsConnError = null;
        try {
            Class<?> connectionClazz = this.connection.getClass();
            logger.info("Methods available in class: " + connectionClazz.getName(), new Object[0]);
            Method[] connectionMethods = connectionClazz.getDeclaredMethods();
            int i = 0;
            while (i < connectionMethods.length) {
                Method connMethod = connectionMethods[i];
                String mname = connMethod.getName();
                logger.info(mname, new Object[0]);
                if (mname.equals("getPSB")) {
                    Object t4PsbImpl = connMethod.invoke((Object)this.connection, null);
                    Class<?> t4PsbClazz = t4PsbImpl.getClass();
                    Class<?> psbImplClazz = t4PsbClazz.getSuperclass();
                    logger.info("Methods available in class: " + psbImplClazz.getName(), new Object[0]);
                    Method[] psbMethods = psbImplClazz.getDeclaredMethods();
                    int j = 0;
                    while (j < psbMethods.length) {
                        Method psbMethod = psbMethods[j];
                        String psbMethodName = psbMethod.getName();
                        logger.info(psbMethodName, new Object[0]);
                        if (psbMethodName.equals("clearDBDCache")) {
                            logger.info("Invoking method: " + psbMethodName, new Object[0]);
                            psbMethod.invoke(t4PsbImpl, null);
                        } else if (psbMethodName.equals("clearPSBCache")) {
                            logger.info("Invoking method: " + psbMethodName, new Object[0]);
                            psbMethod.invoke(t4PsbImpl, null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (InvocationTargetException e) {
            imsConnError = new ImsDbConnectionException(e.getCause());
        }
        catch (Exception e) {
            imsConnError = new ImsDbConnectionException(e);
        }
        try {
            this.connection.commit();
        }
        catch (Throwable t) {
            logger.finer(t.getMessage());
        }
        if (imsConnError != null) {
            throw imsConnError;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "clearCacheInternal", new Object[0]);
        }
    }

    @Override
    public String nativeSQL(String sqlText) throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "nativeSQL(sqlText={0})", new Object[]{sqlText});
        }
        String natSql = null;
        this.acquireLock();
        try {
            try {
                if (this.ensureConnected()) {
                    natSql = this.connection.nativeSQL(sqlText);
                    this.connection.commit();
                }
            }
            catch (Throwable t) {
                ImsDbConnectionException imsConnError = null;
                imsConnError = t instanceof ImsDbConnectionException ? (ImsDbConnectionException)t : new ImsDbConnectionException(t);
                throw imsConnError;
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "nativeSQL(String): {0}", new Object[]{natSql});
        }
        return natSql;
    }

    @Override
    public String getCatalog() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getCatalog", new Object[0]);
        }
        String catalog = null;
        this.acquireLock();
        try {
            try {
                if (this.ensureConnected()) {
                    catalog = this.connection.getCatalog();
                    this.connection.commit();
                }
            }
            catch (Throwable t) {
                ImsDbConnectionException imsConnError = null;
                imsConnError = t instanceof ImsDbConnectionException ? (ImsDbConnectionException)t : new ImsDbConnectionException(t);
                throw imsConnError;
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getCatalog: {0}", new Object[]{catalog});
        }
        return catalog;
    }

    @Override
    public int getDatabaseMajorVersion() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDatabaseMajorVersion", new Object[0]);
        }
        int dataBaseMajorVersion = -1;
        this.acquireLock();
        try {
            try {
                if (this.ensureConnected()) {
                    dataBaseMajorVersion = this.connection.getMetaData().getDatabaseMajorVersion();
                    this.connection.commit();
                }
            }
            catch (Throwable t) {
                ImsDbConnectionException imsConnError = null;
                imsConnError = t instanceof ImsDbConnectionException ? (ImsDbConnectionException)t : new ImsDbConnectionException(t);
                throw imsConnError;
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDatabaseMajorVersion: {0}", new Object[]{dataBaseMajorVersion});
        }
        return dataBaseMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws ImsDbConnectionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getDatabaseMinorVersion", new Object[0]);
        }
        int databaseMinorVersion = -1;
        this.acquireLock();
        try {
            try {
                if (this.ensureConnected()) {
                    databaseMinorVersion = this.connection.getMetaData().getDatabaseMinorVersion();
                    this.connection.commit();
                }
            }
            catch (Throwable t) {
                ImsDbConnectionException imsConnError = null;
                imsConnError = t instanceof ImsDbConnectionException ? (ImsDbConnectionException)t : new ImsDbConnectionException(t);
                throw imsConnError;
            }
        }
        finally {
            this.releaseLock();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getDatabaseMinorVersion: {0}", new Object[]{databaseMinorVersion});
        }
        return databaseMinorVersion;
    }

    @Override
    public boolean ping(boolean locking, boolean reconnect) throws ImsDbConnectionException {
        boolean connected;
        block18: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "ping(locking={0},reconnect={1})", new Object[]{locking, reconnect});
            }
            connected = false;
            if (locking) {
                this.acquireLock();
            }
            try {
                try {
                    this.testConnection();
                    connected = true;
                }
                catch (ImsDbConnectionException e) {
                    if (e.isCausedByConnectivityException()) {
                        ConnectionProfile profile = connectionManager.getConnectionProfile(this.getConfiguration().getID());
                        if (reconnect) {
                            try {
                                if (logger.isLoggable(Level.INFO)) {
                                    logger.info("reconnecting profile {0} due to error {1}", new Object[]{profile.getName(), e.getMessage()});
                                }
                                this.initDbConnection();
                                this.testConnection();
                                connected = true;
                            }
                            catch (ImsDbConnectionException e1) {
                                if (e1.isCausedByConnectivityException()) {
                                    ImsDbUtils.doDisconnectSync(profile);
                                }
                                throw e1;
                            }
                        }
                    } else {
                        throw e;
                    }
                    if (locking) {
                        this.releaseLock();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (locking) {
                    this.releaseLock();
                }
                throw throwable;
            }
            if (locking) {
                this.releaseLock();
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "ping(boolean,boolean): {0}", new Object[]{connected});
        }
        return connected;
    }

    @Override
    public Connection getSqlConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean acquireLock() throws ImsDbConnectionAquireLockException {
        if (this.lock.isHeldByCurrentThread()) {
            String message = MessageFormat.format("Thread {0} already owns the lock for connection {1}", Thread.currentThread().getId(), this.getName());
            throw new ImsDbConnectionAquireLockException(message);
        }
        try {
            int attempts = 11;
            int tOutSecs = 3000;
            while (!this.lock.isHeldByCurrentThread() && attempts > 0) {
                --attempts;
                if (logger.isLoggable(Level.FINE)) {
                    String message = MessageFormat.format("Thread {0} attempting to aquire lock for connection {1}. {2} attempts remain.", Thread.currentThread().getId(), this.getName(), attempts);
                    logger.fine(message);
                }
                this.lock.tryLock(tOutSecs, TimeUnit.MILLISECONDS);
                Thread.yield();
            }
        }
        catch (Throwable t) {
            logger.error(t);
        }
        if (!this.lock.isHeldByCurrentThread()) {
            String message = MessageFormat.format("Thread {0} failed to acquire the lock for connection {1}", Thread.currentThread().getId(), this.getName());
            throw new ImsDbConnectionAquireLockException(message);
        }
        if (logger.isLoggable(Level.FINE)) {
            String message = MessageFormat.format("Thread {0} acquired the lock for connection {1}", Thread.currentThread().getId(), this.getName());
            logger.fine(message);
        }
        return this.lock.isHeldByCurrentThread();
    }

    @Override
    public boolean releaseLock() throws ImsDbConnectionReleaseLockException {
        if (!this.lock.isHeldByCurrentThread()) {
            String message = MessageFormat.format("Thread {0} does not own the lock for connection {1}", Thread.currentThread().getId(), this.getName());
            throw new ImsDbConnectionReleaseLockException(message);
        }
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException e) {
            logger.error((Throwable)e);
        }
        if (this.lock.isHeldByCurrentThread()) {
            String message = MessageFormat.format("Thread {0} failed to release the lock for connection {1}", Thread.currentThread().getId(), this.getName());
            throw new ImsDbConnectionReleaseLockException(message);
        }
        if (logger.isLoggable(Level.FINE)) {
            String message = MessageFormat.format("Thread {0} released the lock for connection {1}", Thread.currentThread().getId(), this.getName());
            logger.fine(message);
        }
        return !this.lock.isHeldByCurrentThread();
    }
}

