/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.listeners;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.CredentialsManagerListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.ICredManagerListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.HashMap;

public class ImsDbCredentialsManagerListener
extends CredentialsManagerListener {
    public static final String TAG = ImsDbCredentialsManagerListener.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static HashMap<String, ICredManagerListener> listeners = new HashMap();

    public void event(CredentialsManagerListener.CredentialsManagerEvent event) {
        logger.entering(TAG, "event(event={0})", new Object[]{event});
        for (ICredManagerListener listener : listeners.values()) {
            logger.info("Notifying nested credential listener {0}", new Object[]{listener.getId()});
            try {
                if (event instanceof CredentialsManagerListener.CredentialModifiedEvent) {
                    CredentialsManagerListener.CredentialModifiedEvent updEvent = (CredentialsManagerListener.CredentialModifiedEvent)event;
                    CredentialsConfiguration oldConfig = updEvent.getExisting();
                    CredentialsConfiguration newConfig = updEvent.getReplacement();
                    logger.info("Credential updated from {0}:{1} to {2}:{3}", new Object[]{oldConfig.getName(), oldConfig.getID(), newConfig.getName(), newConfig.getID()});
                    listener.credUpdated(oldConfig, newConfig);
                    continue;
                }
                if (event instanceof CredentialsManagerListener.CredentialAddedEvent) {
                    CredentialsManagerListener.CredentialAddedEvent addEvent = (CredentialsManagerListener.CredentialAddedEvent)event;
                    CredentialsConfiguration addConfig = addEvent.getCredentialsConfiguration();
                    logger.info("Credential added: {0}:{1}", new Object[]{addConfig.getName(), addConfig.getID()});
                    listener.credAdded(addConfig);
                    continue;
                }
                if (!(event instanceof CredentialsManagerListener.CredentialRemovedEvent)) continue;
                CredentialsManagerListener.CredentialRemovedEvent delEvent = (CredentialsManagerListener.CredentialRemovedEvent)event;
                CredentialsConfiguration delConfig = delEvent.getRemoved();
                logger.info("Credential deleted: {0}:{1}", new Object[]{delConfig.getName(), delConfig.getID()});
                listener.credRemoved(delConfig);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        logger.exiting(TAG, "event(CredentialsManagerEvent)", new Object[0]);
    }

    public static void addListener(ICredManagerListener listener) {
        listeners.put(listener.getId(), listener);
    }

    public static void removeListener(ICredManagerListener listener) {
        listeners.remove(listener.getId());
    }
}

