/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.listeners;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.IConnServiceListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;

public class ImsDbConnectionServiceListener
extends ConnectionServiceListener {
    public static final String TAG = ImsDbConnectionServiceListener.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IConnServiceListener listener = null;

    public ImsDbConnectionServiceListener(IConnServiceListener listener) {
        this.listener = listener;
    }

    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
        logger.entering(TAG, "event(event={0})", new Object[]{event});
        try {
            if ("com.ibm.im.ims.workbench.imsdb.connections.category".equals(event.getConnectionCategoryId())) {
                ConnectionProfile profile = event.getConnectionProfile();
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    logger.info("IMS DB connection \"{0}\" {1} connected", new Object[]{profile.getName(), profile.getId()});
                    this.listener.connProfileConnected(profile);
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    logger.info("IMS DB connection \"{0}\" {1} disconnected", new Object[]{profile.getName(), profile.getId()});
                    this.listener.connProfileDisconnected(profile);
                } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                    Exception eventException = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                    logger.info("IMS DB connection \"{0}\" {1} exception: {2}", new Object[]{profile.getName(), profile.getId(), eventException.getMessage()});
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "event(ConnectionServiceEvent)", new Object[0]);
    }
}

