/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.listeners;

import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.listeners.IConnManagerListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;

public class ImsDbConnectionManagerListener
extends ConnectionManagerListener {
    public static final String TAG = ImsDbConnectionManagerListener.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IConnManagerListener listener = null;

    public ImsDbConnectionManagerListener(IConnManagerListener listener) {
        this.listener = listener;
    }

    public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
        logger.entering(TAG, "event(event={0})", new Object[]{event});
        try {
            ConnectionProfile profile = event.getConnectionProfile();
            IConnectionCategory category = profile.getConnectionDescriptor().getCategory();
            if ("com.ibm.im.ims.workbench.imsdb.connections.category".equals(category.getId())) {
                if (event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                    logger.info("IMS DB connection \"{0}\" {1} updated.", new Object[]{profile.getName(), profile.getId()});
                    this.listener.connProfileUpdated(profile);
                } else if (event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                    logger.info("IMS DB connection \"{0}\" {1} added.", new Object[]{profile.getName(), profile.getId()});
                    this.listener.connProfileAdded(profile);
                } else if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                    logger.info("IMS DB connection \"{0}\" {1} removed.", new Object[]{profile.getName(), profile.getId()});
                    this.listener.connProfileRemoved(profile);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "event(ConnectionManagerEvent)", new Object[0]);
    }
}

