/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.imsdb.connections.exceptions;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.IImsDbConnectionException;
import com.ibm.ims.drda.base.DisconnectException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.bind.JAXBException;

public class ImsDbConnectionException
extends Exception
implements IImsDbConnectionException {
    private static final long serialVersionUID = 1L;
    private static final int maxCauseDepth = 7;
    IConnection connection;

    public ImsDbConnectionException() {
    }

    public ImsDbConnectionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ImsDbConnectionException(String message, Throwable cause, IConnection connection) {
        super(message, cause);
        this.connection = connection;
    }

    public ImsDbConnectionException(Throwable throwable, IConnection connection) {
        super(throwable);
        this.connection = connection;
    }

    public ImsDbConnectionException(String message, IConnection connection) {
        super(message);
        this.connection = connection;
    }

    public ImsDbConnectionException(String message) {
        super(message);
    }

    public ImsDbConnectionException(Throwable cause) {
        super(cause);
    }

    @Override
    public Exception getExternalException() {
        return this;
    }

    @Override
    public String getExternalMessage() {
        return this.getMessage();
    }

    public static String getMessage(Throwable t) {
        String msg;
        String retVal = t.getMessage();
        if (t instanceof JAXBException && (msg = ImsDbConnectionException.getMessage((JAXBException)t)) != null) {
            retVal = msg;
        }
        return retVal;
    }

    private static String getMessage(JAXBException e) {
        String retVal = e.getMessage();
        Throwable linked = e.getLinkedException();
        if (linked != null && linked.getMessage() != null && !linked.getMessage().isEmpty()) {
            retVal = linked.getMessage();
        }
        return retVal;
    }

    @Override
    public boolean isCausedByConnectivityException() {
        boolean isConnectivityException = false;
        Throwable cause = this.getCause();
        int causeDepth = 1;
        while (cause != null && causeDepth < 7 && !isConnectivityException) {
            if (cause instanceof DisconnectException || cause instanceof ConnectException || cause instanceof SocketException || cause instanceof UnknownHostException || cause instanceof SocketTimeoutException) {
                isConnectivityException = true;
            } else {
                cause = cause.getCause();
            }
            ++causeDepth;
        }
        return isConnectivityException;
    }

    @Override
    public boolean isCausedBySecurityException() {
        return false;
    }

    @Override
    public boolean isCausedByUnexpectedResponse() {
        return false;
    }

    @Override
    public boolean isCausedByCertificateException() {
        boolean result = false;
        Throwable cause = this.getCause();
        if (cause instanceof SSLHandshakeException && cause.getCause() instanceof CertificateException) {
            result = true;
        }
        return result;
    }

    public static String getExternalMessage(StackTraceElement ele) {
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append(ele.getClassName());
        msgBuf.append(".");
        msgBuf.append(ele.getMethodName());
        msgBuf.append("(");
        if (ele.isNativeMethod()) {
            msgBuf.append("Native Method");
        } else if (ele.getFileName() != null) {
            msgBuf.append(ele.getFileName());
            if (ele.getLineNumber() >= 0) {
                msgBuf.append(":");
                msgBuf.append(ele.getLineNumber());
            }
        } else {
            msgBuf.append("Unknown Source");
        }
        msgBuf.append(")");
        return msgBuf.toString();
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }
}

