/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class MultiFolderProperty
extends BaseMultiValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = "/\\:.";
    protected int customPropertyFlag = 24;
    protected boolean mustExist = true;

    public MultiFolderProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    public MultiFolderProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, boolean mustExist) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiFolderProperty property = (MultiFolderProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() != this) return;
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            return;
        }
        if (!(newValue instanceof URI)) throw new PropertyVetoException(MessageResource.ERR_INVALID_OBJECT_TYPE, evt);
        URI fileURI = (URI)newValue;
        if ("platform".equals(fileURI.scheme())) {
            if (fileURI.segmentCount() <= 1 || !"resource".equals(fileURI.segment(0))) throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FOLDER, evt);
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = fileURI.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)fileURI.segment(i)));
                ++i;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validatePath(platformResourcePath.toString(), 2);
            if (status.getSeverity() == 4) {
                throw new PropertyVetoException(status.getMessage(), evt);
            }
            if (status.getSeverity() != 2) return;
            throw new PropertyVetoException(status.getMessage(), evt, 1);
        }
        if (!"file".equals(fileURI.scheme())) throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FOLDER, evt);
        String directoryPath = fileURI.toFileString();
        File directory = new File(directoryPath);
        if (!directory.isDirectory()) {
            throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FOLDER, evt);
        }
        if (directory != null && directory.exists()) return;
        throw new PropertyVetoException(MessageResource.bind((String)MessageResource.ERR_DIR_NOT_FOUND, (Object)directoryPath), evt, 1);
    }

    @Override
    protected Object convertStringValue(String newValue) throws CoreException {
        block5: {
            if (newValue != null && !"".equals(newValue.trim())) break block5;
            return null;
        }
        try {
            File file = new File(newValue);
            if (!file.isDirectory()) {
                Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_URI_NOT_FOLDER, null);
                throw new CoreException((IStatus)status);
            }
            java.net.URI fileURI = file.toURI();
            return URI.createURI((String)fileURI.toString());
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public String[] getValuesAsStrings() {
        Object[] currentValues = this.getValues();
        String[] stringValues = new String[currentValues.length];
        int i = 0;
        while (i < currentValues.length) {
            if (currentValues[i] != null) {
                URI uri = (URI)currentValues[i];
                if (uri.isFile()) {
                    stringValues[i] = uri.toFileString();
                } else if ("platform".equals(uri.scheme())) {
                    String value;
                    String decodedURI = URI.decode((String)uri.toString());
                    String path = "platform:/resource";
                    int index = decodedURI.indexOf(path);
                    String wsPath = decodedURI.substring(index += path.length());
                    String wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                    stringValues[i] = value = String.valueOf(wsRoot) + wsPath;
                }
            }
            ++i;
        }
        return stringValues;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }
}

