/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.JavaClassNameProperty;
import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaTypePropertyGroup
extends BasePropertyGroup
implements ICustomProperty {
    public static String DEFAULT_CLASS_DESCRIPTION = MessageResource.DEFAULT_CLASS_DESCRIPTION;
    public static String CLASS_NAME = "Class Name";
    public static String DEFAULT_CLASS_NAME = MessageResource.DEFAULT_CLASS_NAME;
    public static String DEFAULT_GROUP_DESCRIPTION = MessageResource.DEFAULT_GROUP_DESCRIPTION;
    public static String GROUP_NAME = "Java Type Name";
    public static String DEFAULT_GROUP_NAME = MessageResource.DEFAULT_GROUP_NAME;
    public static String DEFAULT_OVERWRITE_DESCRIPTION = MessageResource.DEFAULT_OVERWRITE_DESCRIPTION;
    public static String OVERWRITE_NAME = "Overwrite existing class";
    public static String DEFAULT_OVERWRITE_NAME = MessageResource.DEFAULT_OVERWRITE_NAME;
    public static String DEFAULT_PACKAGE_DESCRIPTION = MessageResource.DEFAULT_PACKAGE_DESCRIPTION;
    public static String PACKAGE_NAME = "Package Name";
    public static String DEFAULT_PACKAGE_NAME = MessageResource.DEFAULT_PACKAGE_NAME;
    public static String DEFAULT_PROJECT_DESCRIPTION = MessageResource.DEFAULT_PROJECT_DESCRIPTION;
    public static String PROJECT_NAME = "Project Name";
    public static String DEFAULT_PROJECT_NAME = MessageResource.DEFAULT_PROJECT_NAME;
    protected JavaClassNameProperty classProperty;
    protected int customPropertyFlag = 2048;
    protected BaseSingleValuedProperty overwriteProperty;
    protected JavaPackageProperty packageProperty;
    protected JavaProjectProperty projectProperty;

    public JavaTypePropertyGroup() throws CoreException {
        super(GROUP_NAME, DEFAULT_GROUP_NAME, DEFAULT_GROUP_DESCRIPTION);
        this.propertyFlag |= 0x104;
        this.initialize(DEFAULT_PROJECT_NAME, DEFAULT_PROJECT_DESCRIPTION, DEFAULT_PACKAGE_NAME, DEFAULT_PACKAGE_DESCRIPTION, DEFAULT_CLASS_NAME, DEFAULT_CLASS_DESCRIPTION, DEFAULT_OVERWRITE_NAME, DEFAULT_OVERWRITE_DESCRIPTION);
    }

    public JavaTypePropertyGroup(String groupName, String displayName, String groupDescription, String projectPropertyName, String projectPropertyDescription, String packagePropertyName, String packagePropertyDescription, String classPropertyName, String classPropertyDescription, String overwritePropertyName, String overwritePropertyDescription) throws CoreException {
        super(groupName, displayName, groupDescription);
        this.initialize(projectPropertyName, projectPropertyDescription.intern(), packagePropertyName, packagePropertyDescription, classPropertyName, classPropertyDescription, overwritePropertyName, overwritePropertyDescription);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JavaTypePropertyGroup group = (JavaTypePropertyGroup)super.clone();
        JavaProjectProperty projectProperty = (JavaProjectProperty)group.getProperty(PROJECT_NAME);
        JavaPackageProperty packageProperty = (JavaPackageProperty)group.getProperty(PACKAGE_NAME);
        JavaClassNameProperty classProperty = (JavaClassNameProperty)group.getProperty(CLASS_NAME);
        BaseSingleValuedProperty overwriteProperty = (BaseSingleValuedProperty)group.getProperty(OVERWRITE_NAME);
        group.projectProperty = projectProperty;
        group.packageProperty = packageProperty;
        group.classProperty = classProperty;
        group.overwriteProperty = overwriteProperty;
        projectProperty.addPropertyChangeListener(group);
        projectProperty.addVetoablePropertyChangeListener(group);
        packageProperty.addVetoablePropertyChangeListener(group);
        classProperty.addVetoablePropertyChangeListener(group);
        overwriteProperty.addVetoablePropertyChangeListener(group);
        return group;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0 && evt.getSource() == this.projectProperty) {
            if (evt.getNewValue() == null || "".equals(evt.getNewValue())) {
                this.packageProperty.unSet();
                this.packageProperty.setEnabled(false);
                this.classProperty.setEnabled(false);
                this.overwriteProperty.setEnabled(false);
            } else {
                this.packageProperty.setEnabled(true);
                this.classProperty.setEnabled(true);
                this.overwriteProperty.setEnabled(true);
                try {
                    this.packageProperty.setJavaProject((IJavaProject)evt.getNewValue());
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage(e.getStatus());
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this.projectProperty) {
            if (evt.getNewValue() == null || "".equals(evt.getNewValue())) throw new PropertyVetoException(MessageResource.ERR_INVALID_PROJECT_NAME, evt);
            String className = (String)this.classProperty.getValue();
            IJavaProject javaProject = (IJavaProject)evt.getNewValue();
            Boolean overwrite = (Boolean)this.overwriteProperty.getValue();
            IPackageFragment packageFragment = (IPackageFragment)this.packageProperty.getValue();
            if (packageFragment != null && !packageFragment.getJavaProject().equals(javaProject)) {
                IPackageFragmentRoot pkgRoot = JavaPackageProperty.getSourcePackage(javaProject);
                packageFragment = pkgRoot.getPackageFragment(packageFragment.getElementName());
            }
            this.validateClass(className, packageFragment, javaProject, overwrite, evt);
            return;
        } else if (evt.getSource() == this.packageProperty) {
            String className = (String)this.classProperty.getValue();
            IJavaProject javaProject = (IJavaProject)this.projectProperty.getValue();
            Boolean overwrite = (Boolean)this.overwriteProperty.getValue();
            IPackageFragment packageFragment = (IPackageFragment)evt.getNewValue();
            this.validateClass(className, packageFragment, javaProject, overwrite, evt);
            return;
        } else if (evt.getSource() == this.classProperty) {
            String className = (String)evt.getNewValue();
            IJavaProject javaProject = (IJavaProject)this.projectProperty.getValue();
            Boolean overwrite = (Boolean)this.overwriteProperty.getValue();
            IPackageFragment packageFragment = (IPackageFragment)this.packageProperty.getValue();
            this.validateClass(className, packageFragment, javaProject, overwrite, evt);
            return;
        } else {
            if (evt.getSource() != this.overwriteProperty) return;
            String className = (String)this.classProperty.getValue();
            IJavaProject javaProject = (IJavaProject)this.projectProperty.getValue();
            Boolean overwrite = (Boolean)evt.getNewValue();
            IPackageFragment packageFragment = (IPackageFragment)this.packageProperty.getValue();
            this.validateClass(className, packageFragment, javaProject, overwrite, evt);
        }
    }

    private void initialize(String projectPropertyName, String projectPropertyDescription, String packagePropertyName, String packagePropertyDescription, String classPropertyName, String classPropertyDescription, String overwritePropertyName, String overwritePropertyDescription) throws CoreException {
        if (projectPropertyName == null || packagePropertyName == null || classPropertyName == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_PROP_NAME_NULL, null);
            throw new CoreException((IStatus)status);
        }
        this.projectProperty = new JavaProjectProperty(PROJECT_NAME, projectPropertyName, projectPropertyDescription, this);
        this.packageProperty = new JavaPackageProperty(PACKAGE_NAME, packagePropertyName, packagePropertyDescription, this);
        this.classProperty = new JavaClassNameProperty(CLASS_NAME, classPropertyName, classPropertyDescription, this);
        this.overwriteProperty = new BaseSingleValuedProperty(OVERWRITE_NAME, overwritePropertyName, overwritePropertyDescription, Boolean.class, this);
        this.overwriteProperty.setDefaultValue(Boolean.TRUE);
        this.overwriteProperty.setValue(Boolean.TRUE);
        this.projectProperty.addPropertyChangeListener(this);
        this.projectProperty.addVetoablePropertyChangeListener(this);
        this.packageProperty.addVetoablePropertyChangeListener(this);
        this.classProperty.addVetoablePropertyChangeListener(this);
        this.overwriteProperty.addVetoablePropertyChangeListener(this);
    }

    private void validateClass(String selectedClassName, IPackageFragment selectedPackage, IJavaProject selectedProject, boolean overwrite, PropertyChangeEvent event) throws PropertyVetoException {
        IType javaType = null;
        try {
            if (selectedProject != null) {
                if (selectedPackage != null) {
                    ICompilationUnit cu;
                    IResource resource;
                    IPath location;
                    String packageName;
                    if (selectedClassName != null && !"".equals(selectedClassName) && (javaType = selectedProject.findType(packageName = selectedPackage.getElementName(), selectedClassName)) == null && (location = (resource = (cu = selectedPackage.getCompilationUnit(String.valueOf(selectedClassName) + ".java")).getResource()).getLocation()) != null && location.toFile().exists()) {
                        throw new PropertyVetoException(MessageResource.ERR_TYPE_EXISTS_DIFFERENT_CASE, event);
                    }
                } else if (selectedClassName != null && !"".equals(selectedClassName)) {
                    javaType = selectedProject.findType(selectedClassName);
                }
                if (javaType != null && !overwrite) {
                    throw new PropertyVetoException(MessageResource.ERR_TYPE_EXISTS, event);
                }
            }
        }
        catch (JavaModelException e) {
            throw new PropertyVetoException(e.getLocalizedMessage(), event);
        }
    }
}

