/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BindingTypeProperty
extends BaseSingleValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = "/:.{}";
    protected int customPropertyFlag = 128;
    protected String[] tags;

    public BindingTypeProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] tags) throws CoreException {
        super(propertyName, displayName, propertyDescription, QName.class, parentGroup);
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.tags = tags;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BindingTypeProperty property = (BindingTypeProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public String getValueAsString() {
        return super.getValueAsString();
    }

    @Override
    public void setValueAsString(String newValue) throws CoreException {
        if (newValue != null) {
            int openCurly_index = newValue.indexOf("{");
            int closeCurly_index = newValue.indexOf("}");
            if (openCurly_index < 0 && closeCurly_index < 0) {
                this.setValue(new QName(newValue));
                return;
            }
            if (openCurly_index >= 0 && closeCurly_index >= 0 && openCurly_index < closeCurly_index && newValue.indexOf("{", openCurly_index + 1) < 0 && newValue.indexOf("}", closeCurly_index + 1) < 0) {
                this.setValue(new QName(newValue.substring(openCurly_index + 1, closeCurly_index), newValue.substring(closeCurly_index + 1)));
                return;
            }
        }
        Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_SCHEMA_TYPE_NOTATION, (Object)newValue), null);
        throw new CoreException((IStatus)status);
    }

    public String[] getTags() {
        return this.tags;
    }
}

