/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.spi.BasePropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaBeanPropertyGroup
extends BasePropertyGroup {
    public static IPropertyDescriptor[] getPropertyDescriptorArray(Class bean, BasePropertyGroup parentGroup) throws CoreException {
        List propertyDescriptors = JavaBeanPropertyGroup.getPropertyDescriptorList(bean, parentGroup);
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[propertyDescriptors.size()];
        propertyDescriptors.toArray(descriptors);
        return descriptors;
    }

    public static List getPropertyDescriptorList(Class bean, BasePropertyGroup parentGroup) throws CoreException {
        ArrayList<BasePropertyDescriptor> propertyDescriptors = new ArrayList<BasePropertyDescriptor>();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bean.getClassLoader());
        try {
            Object beanInstance = bean.newInstance();
            BeanInfo bInfo = Introspector.getBeanInfo(bean);
            PropertyDescriptor[] properties = bInfo.getPropertyDescriptors();
            if (properties.length > 0) {
                propertyDescriptors.ensureCapacity(properties.length);
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].getReadMethod() != null && properties[i].getWriteMethod() != null) {
                        Object defaultValue = null;
                        try {
                            defaultValue = properties[i].getReadMethod().invoke(beanInstance, null);
                        }
                        catch (IllegalArgumentException e1) {
                            LogFacility.logErrorMessage(e1.getLocalizedMessage(), e1);
                        }
                        catch (IllegalAccessException e1) {
                            LogFacility.logErrorMessage(e1.getLocalizedMessage(), e1);
                        }
                        catch (InvocationTargetException e1) {
                            LogFacility.logErrorMessage(e1.getLocalizedMessage(), e1);
                        }
                        catch (RuntimeException e) {
                            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                        }
                        Class<?> typeClass = properties[i].getPropertyType();
                        if (typeClass != null) {
                            Class<?> propertyType = null;
                            if (typeClass.equals(String.class) || typeClass.equals(Integer.TYPE) || typeClass.equals(Integer.class) || typeClass.equals(Boolean.TYPE) || typeClass.equals(Boolean.class) || typeClass.equals(Byte.TYPE) || typeClass.equals(Byte.class) || typeClass.equals(Character.TYPE) || typeClass.equals(Character.class) || typeClass.equals(Double.TYPE) || typeClass.equals(Double.class) || typeClass.equals(Float.TYPE) || typeClass.equals(Float.class) || typeClass.equals(Long.TYPE) || typeClass.equals(Long.class) || typeClass.equals(Short.TYPE) || typeClass.equals(Short.class)) {
                                propertyType = typeClass;
                            }
                            if (propertyType != null) {
                                JavaBeanPropertyDescriptor propertyDescriptor = new JavaBeanPropertyDescriptor(properties[i].getName(), null, properties[i].getShortDescription(), propertyType, parentGroup);
                                propertyDescriptor.setDefaultValue(defaultValue);
                                propertyDescriptor.setWriteMethod(properties[i].getWriteMethod());
                                propertyDescriptor.setBeanInstance(beanInstance);
                                propertyDescriptors.add(propertyDescriptor);
                            } else {
                                try {
                                    Constructor<?> defaultCtor = typeClass.getConstructor(null);
                                    if (defaultCtor != null) {
                                        JavaBeanPropertyGroup propertyGroup = new JavaBeanPropertyGroup(typeClass, properties[i].getName(), properties[i].getDisplayName(), properties[i].getShortDescription());
                                        propertyDescriptors.add(propertyGroup);
                                        parentGroup.addProperty(propertyGroup);
                                    }
                                }
                                catch (NoSuchMethodException noSuchMethodException) {}
                            }
                        }
                    }
                    ++i;
                }
            }
            ArrayList<BasePropertyDescriptor> arrayList = propertyDescriptors;
            return arrayList;
        }
        catch (InstantiationException e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
        catch (IllegalAccessException e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
        catch (IntrospectionException e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public JavaBeanPropertyGroup(Class bean, String description) throws CoreException {
        super(bean.getName(), null, description);
        this.propertyFlag |= 0x104;
        try {
            JavaBeanPropertyGroup.getPropertyDescriptorList(bean, this);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage(e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    protected JavaBeanPropertyGroup(Class bean, String name, String displayName, String description) throws CoreException {
        super(name, displayName, description);
        this.propertyFlag |= 0x104;
        try {
            JavaBeanPropertyGroup.getPropertyDescriptorList(bean, this);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage(e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    public static class JavaBeanPropertyDescriptor
    extends BaseSingleValuedProperty {
        private Object beanInstance;
        private Method writeMethod;

        public JavaBeanPropertyDescriptor(String propertyName, String displayName, String propertyDescription, Class propertyType, BasePropertyGroup parentGroup) throws CoreException {
            super(propertyName, displayName, propertyDescription, propertyType, parentGroup);
            this.addVetoablePropertyChangeListener(this);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            JavaBeanPropertyDescriptor property = (JavaBeanPropertyDescriptor)super.clone();
            property.addVetoablePropertyChangeListener(property);
            return property;
        }

        public Object getBeanInstance() {
            return this.beanInstance;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setBeanInstance(Object beanInstance) {
            this.beanInstance = beanInstance;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getSource() == this && this.writeMethod != null && this.beanInstance != null) {
                try {
                    this.writeMethod.invoke(this.beanInstance, evt.getNewValue());
                }
                catch (IllegalArgumentException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    throw new PropertyVetoException(e.getLocalizedMessage(), evt);
                }
                catch (IllegalAccessException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    throw new PropertyVetoException(e.getLocalizedMessage(), evt);
                }
                catch (InvocationTargetException e) {
                    String message = e.getLocalizedMessage() == null ? (e.getTargetException() != null ? e.getTargetException().getLocalizedMessage() : (e.getCause() != null ? e.getCause().getLocalizedMessage() : "")) : e.getLocalizedMessage();
                    LogFacility.logErrorMessage(message, e);
                    throw new PropertyVetoException(message, evt);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    throw new PropertyVetoException(e.getLocalizedMessage(), evt);
                }
            }
        }
    }
}

