/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BasePropertyType
implements IPropertyType {
    protected static final int BOOLEAN_OBJECT = 1;
    protected static final int BYTE_OBJECT = 2;
    protected static final int CHAR_OBJECT = 3;
    protected static final int DOUBLE_OBJECT = 4;
    protected static final int FLOAT_OBJECT = 5;
    protected static final int INT_OBJECT = 6;
    protected static final int LONG_OBJECT = 7;
    protected static final int OBJECT = 8;
    protected static final int STRING = 0;
    protected Object defaultValue = null;
    protected boolean defaultValueDerived = false;
    protected boolean expert = false;
    protected boolean hidden = false;
    protected boolean primitive = false;
    protected int propertyTypeIdentifier = 8;
    protected boolean readOnly = false;
    protected boolean required = false;
    protected boolean sensitive = false;
    protected final Class type;
    protected String[] validStringValues = null;
    protected Object[] validValues = null;
    protected boolean validValuesEditable = false;
    protected String bidiDelimiters = null;

    public BasePropertyType(Class propertyType) throws CoreException {
        if (propertyType == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_TYPE_NULL, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (propertyType == Boolean.TYPE) {
            this.propertyTypeIdentifier = 1;
            this.type = Boolean.class;
            this.primitive = true;
        } else if (propertyType == Byte.TYPE) {
            this.propertyTypeIdentifier = 2;
            this.type = Byte.class;
            this.primitive = true;
        } else if (propertyType == Character.TYPE) {
            this.propertyTypeIdentifier = 3;
            this.type = Character.class;
            this.primitive = true;
        } else if (propertyType == Double.TYPE) {
            this.propertyTypeIdentifier = 4;
            this.type = Double.class;
            this.primitive = true;
        } else if (propertyType == Float.TYPE) {
            this.propertyTypeIdentifier = 5;
            this.type = Float.class;
            this.primitive = true;
        } else if (propertyType == Integer.TYPE) {
            this.propertyTypeIdentifier = 6;
            this.type = Integer.class;
            this.primitive = true;
        } else if (propertyType == Long.TYPE) {
            this.propertyTypeIdentifier = 7;
            this.type = Long.class;
            this.primitive = true;
        } else if (propertyType == String.class) {
            this.propertyTypeIdentifier = 0;
            this.type = propertyType;
        } else if (propertyType == Boolean.class) {
            this.propertyTypeIdentifier = 1;
            this.type = propertyType;
        } else if (propertyType == Byte.class) {
            this.propertyTypeIdentifier = 2;
            this.type = propertyType;
        } else if (propertyType == Character.class) {
            this.propertyTypeIdentifier = 3;
            this.type = propertyType;
        } else if (propertyType == Double.class) {
            this.propertyTypeIdentifier = 4;
            this.type = propertyType;
        } else if (propertyType == Float.class) {
            this.propertyTypeIdentifier = 5;
            this.type = propertyType;
        } else if (propertyType == Integer.class) {
            this.propertyTypeIdentifier = 6;
            this.type = propertyType;
        } else if (propertyType == Long.class) {
            this.propertyTypeIdentifier = 7;
            this.type = propertyType;
        } else {
            this.propertyTypeIdentifier = 8;
            this.type = propertyType;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getPropertyTypeIdentifier() {
        return this.propertyTypeIdentifier;
    }

    public Class getType() {
        return this.type;
    }

    @Override
    public Object[] getValidValues() {
        return this.validValues;
    }

    @Override
    public String[] getValidValuesAsStrings() {
        return this.validStringValues;
    }

    @Override
    public boolean isDefaultValueDerived() {
        return this.defaultValueDerived;
    }

    @Override
    public boolean isExpert() {
        return this.expert;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public boolean isValidValuesEditable() {
        return this.validValuesEditable;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultValueDerived(boolean defaultValueDerived) {
        this.defaultValueDerived = defaultValueDerived;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public void setValidValues(Object[] values, PropertyChangeSupport propertyChanges) throws CoreException {
        int i;
        boolean valid = true;
        if (values != null) {
            i = values.length;
            while (--i >= 0) {
                if (this.getType().isAssignableFrom(values[i].getClass())) continue;
                valid = false;
                break;
            }
        }
        if (!valid) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_INVALID_PROPERTY_TYPE, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.validValues = values;
        if (this.validValues != null && this.propertyTypeIdentifier != 8) {
            if (this.propertyTypeIdentifier == 0) {
                this.validStringValues = (String[])this.validValues;
            } else {
                this.validStringValues = new String[this.validValues.length];
                i = this.validValues.length;
                while (--i >= 0) {
                    this.validStringValues[i] = this.validValues[i].toString();
                }
            }
        }
        if (propertyChanges != null) {
            propertyChanges.firePropertyValidValuesChanged();
        }
    }

    public void setValidValuesEditable(boolean editable) {
        this.validValuesEditable = editable;
    }

    @Override
    public String getBidiDelimiters() {
        return null;
    }

    public void setBidiDelimiters(String bidiDelimiters) {
        this.bidiDelimiters = bidiDelimiters;
    }
}

