/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.spi.BaseProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;

public class BaseNodeProperty
extends BaseProperty
implements INodeProperty {
    protected boolean selected = false;
    protected boolean highlighted = false;
    protected IPropertyGroup configurationParameters;
    protected IPropertyGroup currrentConfigurationParameters;
    protected ArrayList<INodeProperty> children = new ArrayList();

    public BaseNodeProperty(String propertyName, String displayName, String propertyDescription) throws CoreException {
        super(propertyName, displayName, propertyDescription, null);
        this.propertyFlag |= 0x110;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.propertyChanges.fireTreePropertySelected();
        } else {
            this.propertyChanges.fireTreePropertyDeselected();
        }
    }

    @Override
    public INodeProperty[] getChildren() {
        INodeProperty[] childNodes = this.children.toArray(new INodeProperty[0]);
        return childNodes;
    }

    @Override
    public IPropertyGroup createConfigurationProperties() {
        try {
            if (this.currrentConfigurationParameters != null) {
                return (IPropertyGroup)this.currrentConfigurationParameters.clone();
            }
            if (this.configurationParameters != null) {
                return (IPropertyGroup)this.configurationParameters.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public void applyConfigurationProperties(IPropertyGroup properties) {
        this.currrentConfigurationParameters = properties;
        this.currrentConfigurationParameters.setParent(this);
    }

    @Override
    public IPropertyGroup getActiveConfigurationProperties() {
        return this.currrentConfigurationParameters;
    }

    @Override
    public void unSet() {
        this.setSelected(false);
    }

    public void setConfigurationParameters(IPropertyGroup configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    public void addChild(INodeProperty child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(INodeProperty child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public void removeAllChildren() {
        for (INodeProperty child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    public void addChildren(INodeProperty[] childNodes) {
        this.children.addAll(Arrays.asList(childNodes));
        int i = 0;
        while (i < childNodes.length) {
            childNodes[i].setParent(this);
            ++i;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseNodeProperty newType = (BaseNodeProperty)super.clone();
        if (this.currrentConfigurationParameters != null) {
            newType.currrentConfigurationParameters = (IPropertyGroup)this.currrentConfigurationParameters.clone();
        }
        newType.children = new ArrayList();
        for (INodeProperty element : this.children) {
            INodeProperty clonedChild = (INodeProperty)element.clone();
            clonedChild.setParent(newType);
            newType.children.add(clonedChild);
        }
        return newType;
    }

    @Override
    public void setHighLighted() {
    }

    @Override
    public boolean isHighLighted() {
        return this.highlighted;
    }

    @Override
    public void setHighLighted(boolean highlighted) {
        this.highlighted = highlighted;
        if (highlighted) {
            this.propertyChanges.fireTreeNodeHighlighted();
        } else {
            this.propertyChanges.fireTreeNodeDehighlighted();
        }
    }
}

