/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeIterator;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.spi.HaltVisitingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class BaseResultNodeVisitor {
    boolean depthFirst;

    public boolean isDepthFirst() {
        return this.depthFirst;
    }

    public abstract boolean processQueryResultNode(IResultNode var1) throws BaseException, HaltVisitingException;

    public void setDepthFirst(boolean depthFirst) {
        this.depthFirst = depthFirst;
    }

    public void visitQueryResultNode(IResultNode node) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this.isDepthFirst()) {
                this.visitDepthFirst(node);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            } else {
                this.visitBreadthFirst(node);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.adapter.framework", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            throw new BaseException((IStatus)status);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private void visitBreadthFirst(IResultNode node) throws BaseException {
        LinkedList<IResultNode> searchList = new LinkedList<IResultNode>();
        ArrayList<IResultNode> processedList = new ArrayList<IResultNode>();
        searchList.add(node);
        while (!searchList.isEmpty()) {
            IResultNode currentNode = (IResultNode)searchList.removeFirst();
            if (processedList.contains(currentNode)) continue;
            try {
                IResultNodeResponse response;
                boolean continueVisiting = this.processQueryResultNode(currentNode);
                if (continueVisiting && (response = currentNode.getChildren(null, null)).hasContent()) {
                    IResultNodeIterator iter = response.getResultNodeIterator();
                    while (iter.hasNext()) {
                        searchList.add((IResultNode)iter.next());
                    }
                }
                processedList.add(currentNode);
            }
            catch (HaltVisitingException haltVisitingException) {
                return;
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                Status status = new Status(4, "com.ibm.adapter.framework", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
                throw new BaseException((IStatus)status);
            }
        }
    }

    private void visitDepthFirst(IResultNode node) throws BaseException {
        Stack<IResultNode> searchStack = new Stack<IResultNode>();
        searchStack.push(node);
        ArrayList<IResultNode> processedList = new ArrayList<IResultNode>();
        while (!searchStack.empty()) {
            try {
                IResultNodeResponse response;
                IResultNode currentNode = (IResultNode)searchStack.pop();
                if (processedList.contains(currentNode)) continue;
                boolean continueVisiting = this.processQueryResultNode(currentNode);
                if (continueVisiting && (response = currentNode.getChildren(null, null)).hasContent()) {
                    IResultNodeIterator iter = response.getResultNodeIterator();
                    while (iter.hasNext()) {
                        searchStack.push(iter.nextResultNode());
                    }
                }
                processedList.add(currentNode);
            }
            catch (HaltVisitingException haltVisitingException) {
                return;
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                Status status = new Status(4, "com.ibm.adapter.framework", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
                throw new BaseException((IStatus)status);
            }
        }
    }
}

