/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.adapter.framework.spi.BaseResultNodeResponse;
import com.ibm.adapter.framework.spi.BaseResultNodeVisitor;
import com.ibm.adapter.framework.spi.NodePrunningVisitor;
import com.ibm.propertygroup.IPropertyGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BaseResultNode
implements IResultNode {
    static String EMPTY_STRING = "";
    protected ArrayList children = new ArrayList();
    protected boolean childSelected = false;
    protected IPropertyGroup configurationParameters;
    protected IPropertyGroup currrentConfigurationParameters;
    protected Object data;
    protected String description = null;
    protected IPropertyGroup displayProperties;
    protected IPropertyGroup appliedFilter;
    protected IPropertyGroup filteringProperties;
    protected boolean hasChildren = false;
    protected String name = null;
    protected IResultNode parent;
    protected boolean selectable = false;
    protected boolean selected = false;
    protected IResultNode.IResultNodeType type;

    public void accept(BaseResultNodeVisitor visitor) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                visitor.visitQueryResultNode(this);
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (RuntimeException e) {
                BaseException ex = BaseException.createException(e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage(ex.getStatus());
                throw ex;
            }
            catch (Throwable e) {
                BaseException ex = BaseException.createException(e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage(ex.getStatus());
                throw ex;
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(IResultNode childNode) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        this.children.add(childNode);
        if (!this.hasChildren) {
            this.hasChildren = true;
        }
        try {
            try {
                BaseResultNode node = (BaseResultNode)childNode;
                node.setParent(this);
                return;
            }
            catch (ClassCastException classCastException) {
                if (!LogFacility.trace) return;
                LogFacility.TrcExit();
                return;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (!LogFacility.trace) return;
                LogFacility.TrcExit();
                return;
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (!LogFacility.trace) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                LogFacility.TrcExit();
                return;
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public void applyConfigurationParameters(IPropertyGroup parameteres) throws BaseException {
        this.currrentConfigurationParameters = parameteres;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public IPropertyGroup createConfigurationParameters() {
        try {
            if (this.currrentConfigurationParameters != null) {
                return (IPropertyGroup)this.currrentConfigurationParameters.clone();
            }
            if (this.configurationParameters != null) {
                return (IPropertyGroup)this.configurationParameters.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public IPropertyGroup getActiveConfigurationParameters() {
        return this.currrentConfigurationParameters;
    }

    @Override
    public IPropertyGroup getAppliedFilter() {
        return this.appliedFilter;
    }

    @Override
    public IResultNodeResponse getChildren(IPropertyGroup filterParameters, IEnvironment environment) throws BaseException {
        this.setAppliedFilter(filterParameters);
        return new BaseResultNodeResponse(this.children, EMPTY_STRING);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IPropertyGroup getDisplayProperties() {
        return this.displayProperties;
    }

    @Override
    public IPropertyGroup getFilteringProperties() {
        try {
            if (this.filteringProperties != null) {
                return (IPropertyGroup)this.filteringProperties.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public String getLocation() {
        if (this.getParent() == null) {
            return this.getName();
        }
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getParent().getLocation());
            buf.append('/');
            buf.append(this.getName());
            return buf.toString();
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return this.getName();
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return this.getName();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IResultNode getParent() {
        return this.parent;
    }

    @Override
    public String getParentLocation() {
        if (this.parent != null) {
            return this.parent.getLocation();
        }
        return null;
    }

    @Override
    public IResultNode.IResultNodeType getType() {
        return this.type;
    }

    @Override
    public boolean hasChildren() {
        return this.hasChildren;
    }

    public boolean isChildSelected() {
        return this.childSelected;
    }

    @Override
    public boolean isLeafNode() {
        return this.children.isEmpty();
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void pruneUnselectedNodes() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                this.accept(NodePrunningVisitor.createVisitor());
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage(e.getStatus());
                throw e;
            }
            catch (RuntimeException e) {
                BaseException ex = BaseException.createException(e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage(ex.getStatus());
                throw ex;
            }
            catch (Throwable e) {
                BaseException ex = BaseException.createException(e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage(ex.getStatus());
                throw ex;
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void removeChild(IResultNode childNode) {
        this.children.remove(childNode);
    }

    public void setAppliedFilter(IPropertyGroup appliedFilter) {
        this.appliedFilter = appliedFilter;
    }

    public void setChildren(List children) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    try {
                        IResultNode node = (IResultNode)iter.next();
                        this.addChild(node);
                    }
                    catch (ClassCastException e) {
                        String msg = MessageResource.MSG_ERROR__NODE_LIST_INVALID;
                        LogFacility.logErrorMessage(msg, e);
                        throw BaseException.createException(msg, e);
                    }
                }
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage(e.getStatus());
                throw e;
            }
            catch (RuntimeException e) {
                BaseException ex = BaseException.createException(e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage(ex.getStatus());
                throw ex;
            }
            catch (Throwable e) {
                BaseException ex = BaseException.createException(e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage(ex.getStatus());
                throw ex;
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void setChildSelected(boolean childSelected) {
        try {
            if (childSelected) {
                this.childSelected = childSelected;
            } else {
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    try {
                        BaseResultNode child = (BaseResultNode)iter.next();
                        if (!child.isSelected() && !child.isChildSelected()) continue;
                        return;
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (RuntimeException e) {
                        LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    }
                }
            }
            if (this.parent != null) {
                try {
                    ((BaseResultNode)this.parent).setChildSelected(childSelected);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayProperties(IPropertyGroup displayProperties) {
        this.displayProperties = displayProperties;
    }

    public void setFilteringProperties(IPropertyGroup filteringProperties) {
        this.filteringProperties = filteringProperties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(IResultNode parent) {
        this.parent = parent;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public void setSelected(boolean selection) {
        try {
            this.selected = selection;
            if (this.parent != null) {
                try {
                    ((BaseResultNode)this.parent).setChildSelected(selection);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    public void setType(IResultNode.IResultNodeType type) {
        this.type = type;
    }

    public void setConfigurationParameters(IPropertyGroup configurationParameters) {
        this.configurationParameters = configurationParameters;
    }
}

