/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.adapter.framework.internal.MessageResource;
import com.ibm.propertygroup.IPropertyGroup;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class BaseResourceWriter
implements IResourceWriter {
    protected IPropertyGroup initializeProperties;
    protected String description;
    protected String displayName;
    protected QName name;

    public BaseResourceWriter() {
    }

    public BaseResourceWriter(QName name, String displayName, String description) {
        this.setName(name);
        this.setDisplayName(displayName);
        this.setDescription(description);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (obj == null) {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return false;
            }
            if (this == obj) {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return true;
            }
            if (!(obj instanceof IResourceWriter)) {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return false;
            }
            IResourceWriter writer = (IResourceWriter)obj;
            if (this.name == writer.getName()) {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return true;
            }
            if (this.name == null) {
                return false;
            }
            try {
                if (this.name.getNamespaceURI().equals(writer.getName().getNamespaceURI()) && this.name.getLocalPart().equals(writer.getName().getLocalPart())) {
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return true;
                }
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return false;
            }
            catch (NullPointerException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return false;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return false;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this.initializeProperties != null) {
                IPropertyGroup props;
                IPropertyGroup iPropertyGroup = props = (IPropertyGroup)this.initializeProperties.clone();
                return iPropertyGroup;
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            throw BaseException.createException(e.getLocalizedMessage(), e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public int hashCode() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this.name != null) {
                int ret = this.name.getNamespaceURI().hashCode() + this.name.getLocalPart().hashCode();
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return ret;
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return -1;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return -1;
        }
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    protected void setName(QName name) {
        this.name = name;
    }

    protected void setInitializeProperties(IPropertyGroup _initializeProperties) {
        this.initializeProperties = _initializeProperties;
    }

    @Override
    public String[] getSupportedConfiguration() {
        return null;
    }

    @Override
    public String[] getConfiguration() {
        return null;
    }

    @Override
    public void setConfiguration(String[] capabilities) throws BaseException {
        Status status = new Status(1, "com.ibm.adapter.framework", 1, MessageResource.bind((String)MessageResource.MSG_ERROR__CONFIGURATION_NOT_SUPPORTED, (Object)this.getName()), null);
        throw new BaseException((IStatus)status);
    }

    @Override
    public void close() throws BaseException {
    }

    @Override
    public void initializeContext(Object[] context) throws BaseException {
    }

    @Override
    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
    }
}

