/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.framework.spi;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.internal.LogFacility;
import com.ibm.propertygroup.IPropertyGroup;

public abstract class BasePublishingSet
implements IPublishingSet {
    protected IPropertyGroup currentPublishingProperties;
    protected IPropertyGroup publishingProperties;
    protected IPropertyGroup currentResolutionProperties;
    protected IPropertyGroup resolutionProperties;

    @Override
    public void applyPublishingProperties(IPropertyGroup publishingProperties) throws BaseException {
        this.currentPublishingProperties = publishingProperties;
    }

    @Override
    public void applyResolutionProperties(IPropertyGroup resolutionProperties) throws BaseException {
        this.currentResolutionProperties = resolutionProperties;
    }

    @Override
    public IPropertyGroup createPublishingProperties() {
        try {
            if (this.currentPublishingProperties != null) {
                return (IPropertyGroup)this.currentPublishingProperties.clone();
            }
            if (this.publishingProperties != null) {
                return (IPropertyGroup)this.publishingProperties.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public IPropertyGroup createResolutionProperties() {
        try {
            if (this.currentResolutionProperties != null) {
                return (IPropertyGroup)this.currentResolutionProperties.clone();
            }
            if (this.resolutionProperties != null) {
                return (IPropertyGroup)this.resolutionProperties.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public IPropertyGroup getActivePublishingProperties() {
        return this.currentPublishingProperties;
    }

    public IPropertyGroup getActiveResolutionProperties() {
        return this.currentResolutionProperties;
    }

    protected void setPublishingProperties(IPropertyGroup publishingProperties) {
        this.publishingProperties = publishingProperties;
    }

    protected void setResolutionProperties(IPropertyGroup resolutionProperties) {
        this.resolutionProperties = resolutionProperties;
    }
}

